/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoc.notification;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.DateFormatter;
import com.atlassian.confluence.core.FormatSettingsManager;
import com.atlassian.confluence.core.TimeZone;
import com.atlassian.confluence.jmx.JmxSMTPMailServer;
import com.atlassian.confluence.mail.notification.Notification;
import com.atlassian.confluence.mail.notification.NotificationManager;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.pages.TinyUrl;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.search.service.ContentTypeEnum;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.PersonalInformation;
import com.atlassian.confluence.user.PersonalInformationManager;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.core.filters.ServletContextThreadLocal;
import com.atlassian.mail.Email;
import com.atlassian.mail.MailException;
import com.atlassian.mail.MailFactory;
import com.atlassian.mail.queue.SingleMailQueueItem;
import com.atlassian.mail.server.SMTPMailServer;
import com.atlassian.user.User;
import com.comalatech.confluence.adhoc.notification.AdhocNotificationService;
import com.comalatech.confluence.adhoc.notification.model.AdHocEmail;
import com.comalatech.confluence.dataextractor.queue.AppfireQueueService;
import com.comalatech.confluence.license.WorkflowsFeatureManagerImpl;
import com.comalatech.confluence.workflow.user.WorkflowAuthenticatedUserThreadLocal;
import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.util.TextUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.MimetypesFileTypeMap;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import javax.mail.util.ByteArrayDataSource;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAdhocNotificationService
implements AdhocNotificationService {
    private static final Logger log = LoggerFactory.getLogger(DefaultAdhocNotificationService.class);
    private final PageManager pageManager;
    private final UserAccessor userAccessor;
    private final FormatSettingsManager formatSettingsManager;
    private final PersonalInformationManager personalInformationManager;
    private final AttachmentManager attachmentManager;
    private final AppfireQueueService appfireQueueService;
    private final PermissionManager permissionManager;
    private final NotificationManager notificationManager;
    private static final MimetypesFileTypeMap fileTypeMap = new MimetypesFileTypeMap();

    public DefaultAdhocNotificationService(PageManager pageManager, UserAccessor userAccessor, FormatSettingsManager formatSettingsManager, PersonalInformationManager personalInformationManager, AttachmentManager attachmentManager, AppfireQueueService appfireQueueService, PermissionManager permissionManager, NotificationManager notificationManager) {
        this.pageManager = pageManager;
        this.userAccessor = userAccessor;
        this.formatSettingsManager = formatSettingsManager;
        this.personalInformationManager = personalInformationManager;
        this.attachmentManager = attachmentManager;
        this.appfireQueueService = appfireQueueService;
        this.permissionManager = permissionManager;
        this.notificationManager = notificationManager;
    }

    @Override
    public Set<ConfluenceUser> getContentWatchers(AbstractPage page, ConfluenceUser updator, boolean includeSpaceWatchers, Collection<ConfluenceUser> usersToExclude, Collection<ConfluenceUser> extraUsersToInclude) {
        List notifications = this.notificationManager.getNotificationsByContent((ContentEntityObject)page);
        if (includeSpaceWatchers) {
            notifications.addAll(this.notificationManager.getNotificationsBySpaceAndType(page.getSpace(), null));
            if (page instanceof BlogPost) {
                notifications.addAll(this.notificationManager.getNotificationsBySpaceAndType(page.getSpace(), ContentTypeEnum.BLOG));
            }
        }
        if (updator != null) {
            notifications.addAll(this.notificationManager.findNotificationsByFollowing((User)updator));
        }
        HashSet<ConfluenceUser> watchers = new HashSet<ConfluenceUser>();
        for (Notification notification : notifications) {
            ConfluenceUser user = this.userAccessor.getUserByName(notification.getReceiver().getName());
            if (user == null || usersToExclude != null && usersToExclude.contains(user)) continue;
            watchers.add(user);
        }
        if (extraUsersToInclude != null) {
            extraUsersToInclude.stream().filter(Objects::nonNull).forEach(extraUser -> {
                if (usersToExclude == null || !usersToExclude.contains(extraUser)) {
                    watchers.add((ConfluenceUser)extraUser);
                }
            });
        }
        return watchers;
    }

    @Override
    public void sendEmail(AdHocEmail emailParams, Set<ConfluenceUser> users) {
        this.sendEmail(emailParams, users, Permission.VIEW);
    }

    @Override
    public void sendSimpleEmail(AdHocEmail emailParams, Set<ConfluenceUser> users, ConfluenceUser sender) {
        if (this.getMailServer() != null) {
            ConfluenceUser user = null;
            if (sender != null && !WorkflowsFeatureManagerImpl.isWorkflowsUser(sender.getName())) {
                user = sender;
            }
            TimeZone timeZone = TimeZone.getInstance((String)"");
            DateFormatter dateFormatter = new DateFormatter(timeZone, this.formatSettingsManager, null);
            Map velocityContext = MacroUtils.defaultVelocityContext();
            velocityContext.put("sender", user);
            velocityContext.put("dateFormatter", dateFormatter);
            velocityContext.put("mode", "email");
            velocityContext.put("user", user);
            String baseUrl = this.getBaseUrl();
            velocityContext.put("baseurl", baseUrl);
            velocityContext.put("body", emailParams.getBody());
            velocityContext.put("subject", emailParams.getSubject());
            velocityContext.putAll(emailParams.getContextProperties());
            for (ConfluenceUser recipient : users) {
                if (user != null && recipient.getName().equals(user.getName()) && !this.getUserNotifyOwnActions(user)) continue;
                String receivingUserEmail = recipient.getEmail();
                if (TextUtils.stringSet((String)receivingUserEmail)) {
                    velocityContext.put("receivingUser", recipient);
                    try {
                        this.sendMail(null, user, velocityContext, receivingUserEmail, emailParams);
                    }
                    catch (MailException | IOException | MessagingException e) {
                        log.error("Error sending email", e);
                    }
                    continue;
                }
                log.warn("user: " + recipient + " does not have an email address configured, could not send Comala Workflows email");
            }
        }
    }

    @Override
    public void sendEmail(AdHocEmail emailParams, Set<ConfluenceUser> users, Permission permission) {
        this.sendEmail(emailParams, users, permission, AuthenticatedUserThreadLocal.get());
    }

    @Override
    public void sendEmail(AdHocEmail emailParams, Set<ConfluenceUser> users, Permission permission, ConfluenceUser sender) {
        if (this.getMailServer() != null) {
            AbstractPage page = (AbstractPage)this.pageManager.getById(emailParams.getEntityId());
            ConfluenceUser user = null;
            if (sender != null && !WorkflowsFeatureManagerImpl.isWorkflowsUser(sender.getName())) {
                user = sender;
            }
            TimeZone timeZone = TimeZone.getInstance((String)"");
            DateFormatter dateFormatter = new DateFormatter(timeZone, this.formatSettingsManager, null);
            Map velocityContext = MacroUtils.defaultVelocityContext();
            velocityContext.put("sender", user);
            velocityContext.put("ceo", page);
            velocityContext.put("space", page.getSpace());
            velocityContext.put("dateFormatter", dateFormatter);
            velocityContext.put("mode", "email");
            velocityContext.put("user", user);
            String baseUrl = this.getBaseUrl();
            velocityContext.put("baseurl", baseUrl);
            velocityContext.put("tinyUrl", baseUrl + "/x/" + new TinyUrl(page.getId()).getIdentifier());
            velocityContext.put("body", emailParams.getBody());
            velocityContext.put("subject", emailParams.getSubject());
            velocityContext.putAll(emailParams.getContextProperties());
            for (ConfluenceUser recipient : users) {
                if (!permission.equals((Object)Permission.ADMINISTER) ? !this.permissionManager.hasPermission((User)recipient, permission, (Object)page) : !this.permissionManager.hasPermission((User)recipient, permission, (Object)page.getSpace())) continue;
                if (user != null && recipient.getName().equals(user.getName()) && !this.getUserNotifyOwnActions(user)) continue;
                String receivingUserEmail = recipient.getEmail();
                if (TextUtils.stringSet((String)receivingUserEmail)) {
                    velocityContext.put("receivingUser", recipient);
                    try {
                        this.sendMail((ContentEntityObject)page, user, velocityContext, receivingUserEmail, emailParams);
                    }
                    catch (MailException | IOException | MessagingException e) {
                        log.error("Error sending email", e);
                    }
                    continue;
                }
                log.warn("user: " + recipient + " does not have an email address configured, could not send Comala Workflows email");
            }
        }
    }

    @Override
    public SMTPMailServer getMailServer() {
        return MailFactory.getServerManager().getDefaultSMTPMailServer();
    }

    protected String getBaseUrl() {
        String domainName = GeneralUtil.getGlobalSettings().getBaseUrl();
        if (TextUtils.stringSet((String)domainName) && domainName.endsWith("/")) {
            domainName = domainName.substring(0, domainName.length() - 1);
        }
        return domainName;
    }

    private void sendMail(ContentEntityObject ceo, ConfluenceUser user, Map<String, Object> velocityContext, String receivingUserEmail, AdHocEmail emailParams) throws MessagingException, IOException, MailException {
        String body = VelocityUtils.getRenderedTemplate((String)emailParams.getTemplateLocation(), velocityContext);
        String subject = emailParams.getSubject();
        Email email = new Email(receivingUserEmail);
        email.setFrom(this.getMailServer().getDefaultFrom());
        email.setFromName(this.getServerFromName(user));
        email.setSubject(subject);
        email.setBody(body);
        email.setMimeType("text/html");
        MimeMultipart multipart = new MimeMultipart("related");
        if (user != null) {
            MimeBodyPart avatarBodyPart = new MimeBodyPart();
            avatarBodyPart.setDataHandler(this.createAvatarDataHandler(user));
            avatarBodyPart.setHeader("Content-ID", "<avatar>");
            multipart.addBodyPart((BodyPart)avatarBodyPart);
        }
        if (ceo != null) {
            if ("page".equals(ceo.getType())) {
                this.addClasspathImageToMultiPart(multipart, "page-icon", "/templates/adhocworkflows/images/docs_16.gif");
            }
            if ("blogpost".equals(ceo.getType())) {
                this.addClasspathImageToMultiPart(multipart, "blogpost-icon", "/templates/adhocworkflows/images/blogentry_16.gif");
            }
        }
        email.setMultipart((Multipart)multipart);
        if (log.isDebugEnabled()) {
            log.debug("sending email, subject: " + subject + " to: " + receivingUserEmail);
        }
        this.appfireQueueService.addTask("mail", () -> ((SingleMailQueueItem)new SingleMailQueueItem(email)).send());
    }

    @Override
    public String getServerFromName(ConfluenceUser sendingUser) {
        String from = "${fullname} (Confluence)";
        JmxSMTPMailServer server = (JmxSMTPMailServer)this.getMailServer();
        if (server != null) {
            from = server.getFromName();
        }
        String name = sendingUser != null ? sendingUser.getFullName() : (WorkflowAuthenticatedUserThreadLocal.get() != null ? WorkflowAuthenticatedUserThreadLocal.get().getFullName() : ConfluenceActionSupport.getTextStatic((String)"anonymous.name"));
        String emailAddress = sendingUser != null ? sendingUser.getEmail() : "";
        String hostname = sendingUser != null && StringUtils.isNotBlank((String)emailAddress) ? emailAddress.substring(emailAddress.indexOf("@") + 1) : "";
        from = StringUtils.replace((String)StringUtils.defaultString((String)from), (String)"${fullname}", (String)name);
        from = StringUtils.replace((String)from, (String)"${email}", (String)emailAddress);
        from = StringUtils.replace((String)from, (String)"${email.hostname}", (String)hostname);
        return from;
    }

    @Override
    public boolean getUserNotifyOwnActions(ConfluenceUser user) {
        if (user == null) {
            return false;
        }
        PropertySet props = this.userAccessor.getPropertySet(user);
        if (props == null) {
            return false;
        }
        boolean userOwnActionsPropertyExist = props.exists("confluence.prefs.notify.for.my.own.actions");
        if (!userOwnActionsPropertyExist) {
            log.error("Avoiding Runtime Exception: User [" + user.getName() + "] notify own actions property does not exist as key in the Confluence cache...");
            return false;
        }
        return this.userAccessor.getPropertySet(user).getBoolean("confluence.prefs.notify.for.my.own.actions");
    }

    private void addClasspathImageToMultiPart(MimeMultipart multipart, String contentId, String pathToImage) throws MessagingException {
        MimeBodyPart imagePart = new MimeBodyPart();
        imagePart.setDataHandler(new DataHandler(this.createClasspathDataSource(pathToImage)));
        imagePart.setHeader("Content-ID", "<" + contentId + ">");
        multipart.addBodyPart((BodyPart)imagePart);
    }

    private DataHandler createAvatarDataHandler(ConfluenceUser user) throws MessagingException, IOException {
        PropertySet propertySet = this.userAccessor.getPropertySet(user);
        if (propertySet == null) {
            return this.createServletContextDataHandler("/images/icons/profilepics/default.png");
        }
        String profilePicture = propertySet.getString("confluence.user.profile.picture");
        if (profilePicture == null) {
            return this.createServletContextDataHandler("/images/icons/profilepics/default.png");
        }
        if (profilePicture.startsWith("/images/icons/profilepics/")) {
            return this.createServletContextDataHandler(profilePicture);
        }
        PersonalInformation personalInformation = this.personalInformationManager.getOrCreatePersonalInformation((User)user);
        Attachment a = this.attachmentManager.getAttachment((ContentEntityObject)personalInformation, profilePicture);
        if (a != null) {
            return new DataHandler((DataSource)new ProfileImageDataSource((DataSource)new ByteArrayDataSource(this.attachmentManager.getAttachmentData(a), a.getMediaType())));
        }
        return null;
    }

    private DataHandler createServletContextDataHandler(String pathToImage) {
        DataSource fileDataSource = this.createServletContextDataSource(pathToImage);
        return new DataHandler((DataSource)new ProfileImageDataSource(fileDataSource));
    }

    private DataSource createServletContextDataSource(String pathToImage) {
        InputStream servletContextStream = ServletContextThreadLocal.getContext().getResourceAsStream(pathToImage);
        return this.createDataSource(pathToImage, servletContextStream);
    }

    private DataSource createClasspathDataSource(String pathToImage) {
        InputStream classLoaderStream = DefaultAdhocNotificationService.class.getResourceAsStream(pathToImage);
        return this.createDataSource(pathToImage, classLoaderStream);
    }

    private DataSource createDataSource(String imagePath, InputStream inputStream) {
        ByteArrayDataSource dataSource = null;
        String filename = StringUtils.substringAfterLast((String)imagePath, (String)"/");
        String mimeType = fileTypeMap.getContentType(filename);
        try {
            dataSource = new ByteArrayDataSource(inputStream, mimeType);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        return dataSource;
    }

    static {
        try {
            fileTypeMap.addMimeTypes(IOUtils.toString((InputStream)BootstrapManager.class.getResourceAsStream("/mime.types")));
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to load mime types");
        }
    }

    private static class ProfileImageDataSource
    implements DataSource {
        private final DataSource delegate;

        public ProfileImageDataSource(DataSource delegate) {
            this.delegate = delegate;
        }

        public InputStream getInputStream() throws IOException {
            return this.delegate.getInputStream();
        }

        public OutputStream getOutputStream() throws IOException {
            return this.delegate.getOutputStream();
        }

        public String getContentType() {
            return this.delegate.getContentType();
        }

        public String getName() {
            return "avatar";
        }
    }
}

