/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflowreports.action;

import com.atlassian.confluence.pages.AbstractPage;
import com.comalatech.confluence.workflowcontainer.model.WorkflowVisibilityInternal;
import com.comalatech.confluence.workflowreports.ActivityManager;
import com.comalatech.confluence.workflowreports.ReportDateFormatter;
import com.comalatech.confluence.workflowreports.action.PageReportCommand;
import com.comalatech.confluence.workflowreports.model.ActivityReportEntry;
import com.comalatech.confluence.workflowreports.model.ActivityReportOptions;
import java.util.List;

public class PageActivityCommand
extends PageReportCommand {
    private boolean ascending;
    private boolean hideEdits;
    private boolean hideComments;
    private boolean hideStates;
    private boolean hideTasks;
    private ActivityReportOptions options;
    private ReportDateFormatter dateFormatter;
    private ActivityManager activityManager;
    private List<ActivityReportEntry> activityReportEntries;
    private String workflowAuthor;
    private String workflowLogo;

    @Override
    public void doExecuteInternal(AbstractPage page) {
        this.options = new ActivityReportOptions(this.ascending, this.hideEdits, this.hideComments, this.hideStates, this.hideTasks, true, Integer.MAX_VALUE);
        this.activityReportEntries = this.activityManager.getActivityReport(this.getPage(), this.options);
        this.workflowAuthor = this.workflowConfigurationManager.getConfiguration().getWorkflowAuthor();
        this.workflowLogo = this.workflowConfigurationManager.getConfiguration().getWorkflowLogo();
    }

    public List<ActivityReportEntry> getActivityReportEntries() {
        return this.activityReportEntries;
    }

    public ReportDateFormatter getReportDateFormatter() {
        if (this.dateFormatter == null) {
            this.dateFormatter = new ReportDateFormatter(this.getLocaleManager());
        }
        return this.dateFormatter;
    }

    public ActivityReportOptions getOptions() {
        return this.options;
    }

    @Override
    public boolean requiresEditPermission() {
        WorkflowVisibilityInternal visibility = this.workflowConfigurationManager.getHistoryVisibility(this.getPage().getSpaceKey());
        return WorkflowVisibilityInternal.CONTRIBUTORS.equals((Object)visibility);
    }

    @Override
    public boolean requiresSpaceAdminPermission() {
        return false;
    }

    public void setActivityManager(ActivityManager activityManager) {
        this.activityManager = activityManager;
    }

    public void setAscending(boolean ascending) {
        this.ascending = ascending;
    }

    public void setDescending(boolean descending) {
        this.ascending = !descending;
    }

    public void setHideEdits(boolean hideEdits) {
        this.hideEdits = hideEdits;
    }

    public void setHideComments(boolean hideComments) {
        this.hideComments = hideComments;
    }

    public void setHideStates(boolean hideStates) {
        this.hideStates = hideStates;
    }

    public void setHideTasks(boolean hideTasks) {
        this.hideTasks = hideTasks;
    }

    public String getWorkflowAuthor() {
        return this.workflowAuthor;
    }

    public String getWorkflowLogo() {
        return this.workflowLogo;
    }
}

