/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.supportconsole.resources;

import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.crowd.exception.ApplicationPermissionException;
import com.atlassian.user.User;
import com.comalatech.confluence.adhocworkflows.rest.permissions.WorkflowsAppRequired;
import com.comalatech.confluence.adhocworkflows.rest.permissions.WorkflowsLiteAppRequired;
import com.comalatech.confluence.license.WorkflowsFeatureManager;
import com.comalatech.confluence.workflow.rest.model.PermissionRequired;
import java.lang.reflect.Method;
import javax.ws.rs.core.Response;
import org.apache.commons.text.StringEscapeUtils;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRestSupportConsoleResource {
    private static final Logger log = LoggerFactory.getLogger(AbstractRestSupportConsoleResource.class);
    protected static final String APPLICATION_PERMISSION_ERROR = "The application has no permission over ";
    protected final PermissionManager permissionManager;
    protected final WorkflowsFeatureManager workflowsFeatureManager;
    protected final SpaceManager spaceManager;

    public AbstractRestSupportConsoleResource(PermissionManager permissionManager, WorkflowsFeatureManager workflowsFeatureManager, SpaceManager spaceManager) {
        this.permissionManager = permissionManager;
        this.workflowsFeatureManager = workflowsFeatureManager;
        this.spaceManager = spaceManager;
    }

    public abstract class RestCommand {
        private String spaceKey = null;

        protected boolean hasAnnotation(Class clazz) {
            return null != this.getClass().getEnclosingClass().getAnnotation(clazz) || null != this.getClass().getEnclosingMethod().getAnnotation(clazz);
        }

        public RestCommand() {
        }

        public RestCommand(String spaceKey) {
            this.spaceKey = spaceKey;
        }

        protected PermissionRequired getAnnotationIfExists(Method method) {
            PermissionRequired annotation = method.getAnnotation(PermissionRequired.class);
            if (annotation != null) {
                return annotation;
            }
            return method.getDeclaringClass().getDeclaredAnnotation(PermissionRequired.class);
        }

        protected RestCommand validate() throws ApplicationPermissionException {
            Object target;
            boolean allowed = true;
            boolean skip = false;
            if (this.hasAnnotation(WorkflowsAppRequired.class)) {
                skip = allowed = AbstractRestSupportConsoleResource.this.workflowsFeatureManager.isWorkflowsApp();
            }
            if (!skip && this.hasAnnotation(WorkflowsLiteAppRequired.class)) {
                allowed = AbstractRestSupportConsoleResource.this.workflowsFeatureManager.isWorkflowsLiteApp();
            }
            if (!allowed) {
                throw new ApplicationPermissionException(AbstractRestSupportConsoleResource.APPLICATION_PERMISSION_ERROR + this.getClass().getEnclosingClass().getName() + ":" + this.getClass().getEnclosingMethod().getName());
            }
            PermissionRequired annotation = this.getAnnotationIfExists(this.getClass().getEnclosingMethod());
            ConfluenceUser user = AuthenticatedUserThreadLocal.get();
            Object object = target = this.spaceKey != null ? AbstractRestSupportConsoleResource.this.spaceManager.getSpace(this.spaceKey) : this.getValidationTarget();
            if (annotation != null) {
                for (String permission : annotation.value()) {
                    if (AbstractRestSupportConsoleResource.this.permissionManager.hasPermission((User)user, Permission.forName((String)permission), target)) continue;
                    throw new ApplicationPermissionException(user.getName() + " has no " + permission + " permission over " + target);
                }
            }
            return this;
        }

        public Object getValidationTarget() {
            return PermissionManager.TARGET_APPLICATION;
        }

        public final Response execute() {
            try {
                return this.validate().doExecute();
            }
            catch (ApplicationPermissionException e) {
                if (e.getMessage().contains(AbstractRestSupportConsoleResource.APPLICATION_PERMISSION_ERROR)) {
                    return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)StringEscapeUtils.escapeHtml4((String)e.getMessage())).build();
                }
                return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)StringEscapeUtils.escapeHtml4((String)e.getMessage())).build();
            }
            catch (Exception e) {
                log.warn("Cannot execute action", (Throwable)e);
                JSONObject error = new JSONObject();
                error.put("status", Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
                error.put("message", e.getMessage() != null ? e.getMessage() : "Internal server error");
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)error.toString()).type("application/json").build();
            }
        }

        public abstract Response doExecute();
    }
}

