/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.esignatures.listener;

import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.sal.api.user.UserKey;
import com.comalatech.confluence.adhoc.notification.AdhocNotificationService;
import com.comalatech.confluence.adhoc.notification.model.SigningTokenTemplateEmail;
import com.comalatech.confluence.util.WorkflowsListener;
import com.comalatech.confluence.workflow.esignatures.events.OneTimePasswordSigningConfigRequested;
import com.comalatech.confluence.workflow.esignatures.model.SigningToken;
import java.util.Collections;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EsignaturesEventListener
extends WorkflowsListener {
    private static final Logger log = LoggerFactory.getLogger(EsignaturesEventListener.class);
    private final AdhocNotificationService adhocNotificationService;
    private final UserAccessor userAccessor;

    public EsignaturesEventListener(EventPublisher eventPublisher, AdhocNotificationService adhocNotificationService, UserAccessor userAccessor) {
        super(eventPublisher);
        this.adhocNotificationService = adhocNotificationService;
        this.userAccessor = userAccessor;
    }

    @EventListener
    public void notifyOneTimePasswordSigningCreated(@NotNull OneTimePasswordSigningConfigRequested event) {
        SigningTokenTemplateEmail email = new SigningTokenTemplateEmail();
        SigningToken token = event.getToken();
        UserKey userKey = new UserKey(token.getUserKey());
        ConfluenceUser destinationUser = this.userAccessor.getUserByKey(userKey);
        if (destinationUser != null) {
            email.addContextProperty("signingActionPath", "/users/signing/validateToken.action?uuid=" + token.getUuid());
            this.adhocNotificationService.sendSimpleEmail(email, Collections.singleton(destinationUser), null);
        } else {
            log.warn("Cannot find user {}, OTP signature creation email not sent", (Object)userKey);
        }
    }
}

