/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.nextup.slack.service;

import com.comalatech.confluence.nextup.slack.service.PublishSlackPayload;
import com.comalatech.confluence.nextup.slack.service.WorkflowsEventPublisher;
import com.comalatech.confluence.workflow.UsersListResolver;
import com.comalatech.confluence.workflow.ValueStore;
import com.comalatech.confluence.workflow.WorkflowException;
import com.comalatech.confluence.workflow.WorkflowUserException;
import com.opensymphony.util.TextUtils;

public class UsersMacroService
implements PublishSlackPayload {
    private final UsersListResolver usersListResolver;
    private final WorkflowsEventPublisher workflowsEventPublisher;

    public UsersMacroService(UsersListResolver usersListResolver, WorkflowsEventPublisher workflowsEventPublisher) {
        this.usersListResolver = usersListResolver;
        this.workflowsEventPublisher = workflowsEventPublisher;
    }

    @Override
    public void notifyUsers(String subject, String body, String usernames, long pageId, ValueStore valueStore) throws WorkflowException {
        String replacedSubject = subject;
        if (TextUtils.stringSet((String)subject)) {
            replacedSubject = valueStore.replaceReferences(subject.trim());
        }
        String message = valueStore.replaceReferences(body.trim());
        CharSequence[] userKeys = this.usersListResolver.getValueAsUserKeys(valueStore, valueStore.getPage(), usernames);
        if (userKeys.length == 0) {
            throw new WorkflowUserException("There was a problem resolving the users or groups: [" + usernames + "].");
        }
        this.workflowsEventPublisher.publish(replacedSubject, message, String.join((CharSequence)",", userKeys), pageId);
    }
}

