/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.nextup.slack.infrastructure;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.PluginAccessor;
import com.comalatech.confluence.nextup.slack.service.WorkflowsEventPublisher;
import com.opensymphony.util.TextUtils;
import java.util.Properties;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlackEventPublisher
implements WorkflowsEventPublisher {
    private static final Logger log = LoggerFactory.getLogger(SlackEventPublisher.class);
    private static final String CDM_SLACK_USER_EVENT_EMITTER = "com.comalatech.confluence.SlackUserMessageRequested";
    public static final String NEXTUP_API_KEY = "slack.nextup.confluence";
    private static final String PAYLOAD_VERSION = "user_v1";
    private final EventPublisher eventPublisher;
    private final PluginAccessor pluginAccessor;

    public SlackEventPublisher(EventPublisher eventPublisher, PluginAccessor pluginAccessor) {
        this.eventPublisher = eventPublisher;
        this.pluginAccessor = pluginAccessor;
    }

    @Override
    public void publish(String subject, String message, String users, long pageId) {
        if (!this.pluginAccessor.isPluginEnabled(NEXTUP_API_KEY)) {
            log.warn("There was an attempt to send a slack message but it was not. The slack messages will not being sent until 'Docs+ Slack for Confluence' is enabled.");
            return;
        }
        Properties payload = new Properties();
        payload.setProperty("_emitter", CDM_SLACK_USER_EVENT_EMITTER);
        payload.setProperty("message", this.generateBlockKit(subject, message));
        payload.setProperty("users", users);
        payload.setProperty("page_id", String.valueOf(pageId));
        payload.setProperty("payload_version", PAYLOAD_VERSION);
        this.eventPublisher.publish((Object)payload);
    }

    private String generateBlockKit(String subject, String message) {
        JSONArray jsonBlockKit = new JSONArray();
        if (TextUtils.stringSet((String)subject)) {
            JSONObject subjectBlock = new JSONObject();
            subjectBlock.put("type", "header").put("text", new JSONObject().put("type", "plain_text").put("text", subject).put("emoji", true));
            jsonBlockKit.put(subjectBlock);
        }
        JSONObject messageBlock = new JSONObject();
        messageBlock.put("type", "section").put("block_id", "sectionBlockOnlyPlainText").put("text", new JSONObject().put("type", "plain_text").put("text", message).put("emoji", true));
        jsonBlockKit.put(messageBlock);
        return jsonBlockKit.toString();
    }
}

