/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.ipc;

import com.google.common.base.Preconditions;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.util.tracker.ServiceTracker;
import org.springframework.beans.factory.DisposableBean;

public abstract class OptionalService<T>
implements DisposableBean {
    private final Class<T> type;
    private ServiceTracker tracker;

    public OptionalService(Class<T> type) {
        this.type = (Class)Preconditions.checkNotNull(type, (Object)"type");
        BundleContext bundleContext = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
        this.tracker = new ServiceTracker(bundleContext, type.getName(), null);
        this.tracker.open();
    }

    protected final T getService() {
        return this.type.cast(this.tracker.getService());
    }

    public final void destroy() {
        this.tracker.close();
    }
}

