/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.documentActivity.statistics.accessor;

import com.comalatech.confluence.documentActivity.ao.entity.ActivityDetailsRecordEntity;
import com.comalatech.confluence.documentActivity.ao.entity.ActivityRecordEntity;
import com.comalatech.confluence.documentActivity.ao.entity.BaseActivityDetailsRecord;
import com.comalatech.confluence.documentActivity.statistics.accessor.WorkflowApprovalStatsRecordAccessor;
import com.comalatech.confluence.documentActivity.statistics.accessor.builder.states.ApprovalStatsFiltersProcessor;
import com.comalatech.confluence.documentActivity.statistics.accessor.criteria.WorkflowStatsSearchCriteria;
import com.comalatech.confluence.util.ActiveObjectsAccessor;
import com.google.common.base.Functions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.java.ao.Query;
import org.jetbrains.annotations.NotNull;

public class ApprovalStatsAccessor
extends ActiveObjectsAccessor
implements WorkflowApprovalStatsRecordAccessor {
    private final ApprovalStatsFiltersProcessor approvalStatsFiltersProcessor = new ApprovalStatsFiltersProcessor();

    @Override
    public List<BaseActivityDetailsRecord> getApprovalStatsRecords(WorkflowStatsSearchCriteria approvalActivitySearchCriteria) {
        Query query = this.buildQueryForApproval(approvalActivitySearchCriteria);
        if (Objects.isNull(query)) {
            return new ArrayList<BaseActivityDetailsRecord>();
        }
        return Arrays.asList((BaseActivityDetailsRecord[])this.getAo().find(ActivityDetailsRecordEntity.class, query));
    }

    private Query buildQueryForApproval(WorkflowStatsSearchCriteria criteria) {
        List<String> activityIds = this.getActivityIds(criteria.getApprovalName());
        criteria.setApprovalName(null);
        if (activityIds.isEmpty()) {
            return null;
        }
        String placeholderCommaList = activityIds.stream().map(Functions.constant((Object)"?")).collect(Collectors.joining(","));
        Query query = this.buildBasicQuery(criteria);
        String where = query.getWhereClause() + " AND " + "activity" + "." + "ID" + " IN (" + placeholderCommaList + ")";
        ArrayList<Object> params = new ArrayList<Object>(Arrays.asList(query.getWhereParams()));
        params.addAll(activityIds);
        query.where(where, params.toArray());
        return query;
    }

    private Query buildBasicQuery(WorkflowStatsSearchCriteria criteria) {
        Query query = Query.select().alias(ActivityDetailsRecordEntity.class, "detail").alias(ActivityRecordEntity.class, "activity").join(ActivityRecordEntity.class, "detail.ACTIVITY_ID = activity.ID");
        query = this.approvalStatsFiltersProcessor.addFiltersToQuery(query, criteria);
        return query;
    }

    @NotNull
    private List<String> getActivityIds(String approvalName) {
        Query query = Query.select().alias(ActivityDetailsRecordEntity.class, "detail");
        query = this.approvalStatsFiltersProcessor.addFiltersToQuery(query, (WorkflowStatsSearchCriteria)((WorkflowStatsSearchCriteria.WorkflowStatsSearchCriteriaBuilder)WorkflowStatsSearchCriteria.builder().approvalName(approvalName)).build());
        ActivityDetailsRecordEntity[] subQueryValue = (ActivityDetailsRecordEntity[])this.getAo().find(ActivityDetailsRecordEntity.class, query);
        return Arrays.stream(subQueryValue).map(activityDetailsRecordEntity -> activityDetailsRecordEntity.getActivity().getId()).collect(Collectors.toList());
    }
}

