/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.documentActivity.service.provider.confluence.filter;

import com.atlassian.confluence.core.VersionHistorySummary;
import com.comalatech.confluence.documentActivity.domain.entities.ActionType;
import com.comalatech.confluence.documentActivity.service.model.InternalDocumentActivityQuery;
import com.comalatech.confluence.documentActivity.service.model.InternalDocumentActivityQueryFilter;
import com.comalatech.confluence.documentActivity.service.provider.confluence.filter.contract.PageEditActivityFilter;
import com.comalatech.workflow.model.document.activity.DocumentActivityActionTypesFilter;
import java.util.List;

public class PageTypeFilter
implements PageEditActivityFilter {
    @Override
    public boolean filter(VersionHistorySummary version, InternalDocumentActivityQuery query) {
        return this.match(version.getVersion(), query);
    }

    private boolean match(int version, InternalDocumentActivityQuery query) {
        boolean hasPageUpdatedSubtype;
        List<String> subtypes = this.getType((InternalDocumentActivityQueryFilter)query.getFilters(), ActionType.Type.PAGE).getSubtypes();
        boolean hasPageCreatedSubtype = subtypes != null && subtypes.contains(ActionType.Subtype.PAGE_CREATED.getValue());
        boolean bl = hasPageUpdatedSubtype = subtypes != null && subtypes.contains(ActionType.Subtype.PAGE_UPDATED.getValue());
        if (hasPageUpdatedSubtype == hasPageCreatedSubtype) {
            return true;
        }
        return hasPageCreatedSubtype && version == 1 || hasPageUpdatedSubtype && version > 1;
    }

    private DocumentActivityActionTypesFilter getType(InternalDocumentActivityQueryFilter filters, ActionType.Type type) {
        if (filters.getTypes() == null) {
            return new DocumentActivityActionTypesFilter();
        }
        return filters.getTypes().stream().filter(elem -> elem.getType().equals(type.getValue())).findFirst().orElse(new DocumentActivityActionTypesFilter());
    }
}

