/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.dataextractor;

import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.pagination.SimplePageRequest;
import com.atlassian.confluence.api.service.accessmode.AccessModeService;
import com.atlassian.confluence.api.service.content.ContentService;
import com.atlassian.confluence.api.service.exceptions.BadRequestException;
import com.atlassian.confluence.api.service.search.CQLSearchService;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.ContentPermissionManager;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.rest.api.model.ExpansionsParser;
import com.atlassian.confluence.security.ContentPermissionSet;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.util.longrunning.LongRunningTaskId;
import com.atlassian.confluence.util.longrunning.LongRunningTaskManager;
import com.atlassian.core.bean.EntityObject;
import com.atlassian.core.task.longrunning.LongRunningTask;
import com.atlassian.querylang.exceptions.InvalidDynamicFieldQueryException;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.user.EntityException;
import com.atlassian.user.Group;
import com.atlassian.user.GroupManager;
import com.atlassian.user.User;
import com.comalatech.confluence.adhoc.AdhocWorkflowManager;
import com.comalatech.confluence.dataextractor.DataExtractorManager;
import com.comalatech.confluence.dataextractor.DataExtractorPopulationTask;
import com.comalatech.confluence.dataextractor.JsonContentPropertiesKeys;
import com.comalatech.confluence.dataextractor.JsonContentPropertyService;
import com.comalatech.confluence.dataextractor.extractor.WorkflowsPropertyExtractor;
import com.comalatech.confluence.dataextractor.model.FullWorklfowsContentPropertyModel;
import com.comalatech.confluence.dataextractor.model.version.GlobalContentPropertyModelVersion;
import com.comalatech.confluence.readack.dataextractor.ReadAckPropertyExtractor;
import com.comalatech.confluence.tasks.extractor.TaskPropertyExtractor;
import com.comalatech.confluence.workflow.WorkflowAdvancedConfigurationManager;
import com.comalatech.confluence.workflowcontainer.WorkflowContainerManager;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class DefaultDataExtractorManager
implements DataExtractorManager,
ApplicationContextAware,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(DefaultDataExtractorManager.class);
    private static final int CQL_PENDING_PAGES_BATCH = 200;
    private static final String CQL_PENDING_PAGES_QUERY = "awphasworkflow=true AND content.property[comalaworkflowsglobalmodelversion].version!=" + GlobalContentPropertyModelVersion.CONTENT_PROPERTY_MODEL_VERSION;
    private static final String CQL_PENDING_PAGES_EXPAND = "metadata.properties.comalaworkflows";
    private static final int CQL_PENDING_PAGES_POPULATOR_RETRIES = 5;
    private static final int CQL_PENDING_PAGES_POPULATOR_LAPSE = 10000;
    private ApplicationContext applicationContext;
    protected final AdhocWorkflowManager adhocWorkflowManager;
    protected final WorkflowContainerManager workflowContainerManager;
    protected final ContentService contentService;
    protected final WorkflowsPropertyExtractor workflowsPropertyExtractor;
    protected final PermissionManager permissionManager;
    protected final LongRunningTaskManager longRunningTaskManager;
    protected final CQLSearchService cqlSearchService;
    protected final PageManager pageManager;
    protected final TransactionTemplate transactionTemplate;
    protected final AccessModeService accessModeService;
    protected final WorkflowAdvancedConfigurationManager workflowAdvancedConfigurationManager;
    protected ReadAckPropertyExtractor readAckPropertyExtractor;
    protected TaskPropertyExtractor taskPropertyExtractor;
    protected JsonContentPropertyService jsonContentPropertyService;
    private final ContentPermissionManager contentPermissionManager;
    private final UserAccessor userAccessor;
    private final GroupManager groupManager;

    public DefaultDataExtractorManager(AdhocWorkflowManager adhocWorkflowManager, WorkflowContainerManager workflowContainerManager, ContentService contentService, WorkflowsPropertyExtractor workflowsPropertyExtractor, PermissionManager permissionManager, LongRunningTaskManager longRunningTaskManager, CQLSearchService cqlSearchService, PageManager pageManager, TransactionTemplate transactionTemplate, AccessModeService accessModeService, WorkflowAdvancedConfigurationManager workflowAdvancedConfigurationManager, JsonContentPropertyService jsonContentPropertyService, ContentPermissionManager contentPermissionManager, UserAccessor userAccessor, GroupManager groupManager) {
        this.adhocWorkflowManager = adhocWorkflowManager;
        this.workflowContainerManager = workflowContainerManager;
        this.contentService = contentService;
        this.workflowsPropertyExtractor = workflowsPropertyExtractor;
        this.permissionManager = permissionManager;
        this.longRunningTaskManager = longRunningTaskManager;
        this.cqlSearchService = cqlSearchService;
        this.pageManager = pageManager;
        this.transactionTemplate = transactionTemplate;
        this.accessModeService = accessModeService;
        this.workflowAdvancedConfigurationManager = workflowAdvancedConfigurationManager;
        this.jsonContentPropertyService = jsonContentPropertyService;
        this.contentPermissionManager = contentPermissionManager;
        this.userAccessor = userAccessor;
        this.groupManager = groupManager;
    }

    public void afterPropertiesSet() {
        this.readAckPropertyExtractor = (ReadAckPropertyExtractor)this.applicationContext.getBean("readAckPropertyExtractor", ReadAckPropertyExtractor.class);
        this.taskPropertyExtractor = (TaskPropertyExtractor)this.applicationContext.getBean("taskPropertyExtractor", TaskPropertyExtractor.class);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Override
    public boolean updateAllContentProperties(EntityObject entityObject, boolean isActionRequest) {
        return this.updateContentProperties(entityObject, JsonContentPropertiesKeys.getGroupsOfJsonCPs(), isActionRequest);
    }

    @Override
    public boolean updateWorkflowsContentProperties(EntityObject entityObject, boolean isActionRequest) {
        return this.updateContentProperties(entityObject, Collections.singletonList("workflows"), isActionRequest);
    }

    @Override
    public boolean updateReadAckContentProperties(EntityObject entityObject, boolean isActionRequest) {
        return this.updateContentProperties(entityObject, Collections.singletonList("readacks"), isActionRequest);
    }

    @Override
    public boolean updateTasksContentProperties(EntityObject entityObject, boolean isActionRequest) {
        return this.updateContentProperties(entityObject, Collections.singletonList("tasks"), isActionRequest);
    }

    @Override
    public boolean clearAllContentProperties(EntityObject entityObject) {
        if (!this.isPage(entityObject)) {
            return false;
        }
        AbstractPage abstractPage = (AbstractPage)entityObject;
        return this.impersonatedOperation(abstractPage, () -> this.clearAllContentPropertiesInternal(abstractPage));
    }

    protected boolean updateContentProperties(EntityObject entityObject, List<String> keys, boolean isActionRequest) {
        if (!this.isPage(entityObject)) {
            return false;
        }
        AbstractPage abstractPage = (AbstractPage)entityObject;
        if (!this.hasWorkflows(abstractPage)) {
            return this.clearAllContentProperties((EntityObject)abstractPage);
        }
        return this.impersonatedOperation(abstractPage, () -> this.createOrUpdateContentProperties(entityObject, keys, isActionRequest));
    }

    protected boolean clearAllContentPropertiesInternal(AbstractPage page) {
        boolean success = true;
        for (String cp : JsonContentPropertiesKeys.getAllJsonCPs()) {
            success = this.jsonContentPropertyService.delete(page, cp) && success;
        }
        return success;
    }

    private boolean isPage(EntityObject entityObject) {
        return entityObject instanceof AbstractPage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean impersonatedOperation(AbstractPage abstractPage, Callable<Boolean> callback) {
        ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
        boolean success = false;
        ConfluenceUser impersonator = this.getUserForImpersonationWithEditPermission(abstractPage);
        if (impersonator == null) {
            log.warn("Workflows Content Properties cannot be updated/created/deleted in " + abstractPage + " because no valid user was found with edit permissions over it.");
            return false;
        }
        boolean doImpersonation = !impersonator.equals(currentUser);
        try {
            if (doImpersonation) {
                AuthenticatedUserThreadLocal.set((ConfluenceUser)impersonator);
            }
            success = callback.call();
        }
        catch (Exception e) {
            log.error("Error during callback execution", (Throwable)e);
        }
        finally {
            if (doImpersonation) {
                AuthenticatedUserThreadLocal.set((ConfluenceUser)currentUser);
            }
        }
        return success;
    }

    private ConfluenceUser getUserForImpersonationWithEditPermission(AbstractPage abstractPage) {
        ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
        if (currentUser != null && this.isUserAllowedToImpersonate(currentUser, abstractPage, "current user")) {
            return currentUser;
        }
        if (this.isUserAllowedToImpersonate(abstractPage.getLastModifier(), abstractPage, "page's last modifier")) {
            return abstractPage.getLastModifier();
        }
        if (this.isUserAllowedToImpersonate(abstractPage.getCreator(), abstractPage, "page's creator")) {
            return abstractPage.getCreator();
        }
        ConfluenceUser restrictionsUser = this.getUserWithEditPermission(abstractPage);
        if (restrictionsUser != null) {
            return restrictionsUser;
        }
        String groupName = this.workflowAdvancedConfigurationManager.getAdminImpersonatorsGroup();
        if (groupName != null && !groupName.isEmpty()) {
            try {
                Group group = this.groupManager.getGroup(groupName);
                if (log.isDebugEnabled()) {
                    log.debug("Using group: '" + groupName + "' to obtain a valid user to impersonate the operation.");
                }
                for (String username : this.groupManager.getMemberNames(group)) {
                    ConfluenceUser user = this.userAccessor.getUserByName(username);
                    if (!this.isUserAllowedToImpersonate(user, abstractPage, "admin from config")) continue;
                    return user;
                }
            }
            catch (EntityException e) {
                log.error("There was an exception trying to resolve group: " + groupName, (Throwable)e);
            }
        } else {
            log.warn("This thread job has not user set. Some the content properties operations might fail. Use Comala Document Management advance setting for 'Workflow action impersonation user group' to set up a group of user/s with permissions");
        }
        return null;
    }

    private boolean isUserAllowedToImpersonate(ConfluenceUser user, AbstractPage abstractPage, String role) {
        boolean result = this.permissionManager.hasPermission((User)user, Permission.EDIT, (Object)abstractPage);
        if (log.isDebugEnabled()) {
            log.debug("User '" + user + "' as " + role + ", has " + (result ? "no " : "") + "edit permissions over '" + abstractPage + "'" + (result ? " and will be temporarily used for impersonation." : ""));
        }
        return result;
    }

    private ConfluenceUser getUserWithEditPermission(AbstractPage page) {
        List permissionSets = this.contentPermissionManager.getContentPermissionSets((ContentEntityObject)page, "Edit");
        if (log.isDebugEnabled()) {
            log.debug("The actual user '" + AuthenticatedUserThreadLocal.get() + "' and none of the contributors of the page " + page + " have edit permission. We will search for a user with edit permissions to be able to execute the update/create/delete of the Workflows Content Properties");
        }
        for (ContentPermissionSet permissionSet : permissionSets) {
            for (UserKey userKey : permissionSet.getUserKeys()) {
                ConfluenceUser user = this.userAccessor.getUserByKey(userKey);
                if (!this.permissionManager.hasPermission((User)user, Permission.EDIT, (Object)page)) continue;
                if (log.isDebugEnabled()) {
                    log.debug("'" + user + "' has edit permissions on the page " + page + ". Using it to impersonate the operation");
                }
                return user;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("No user found with edit permission.");
        }
        return null;
    }

    private boolean hasWorkflows(AbstractPage page) {
        return this.workflowContainerManager.hasProductionWorkflows(page) || this.adhocWorkflowManager.hasWorkflow(page);
    }

    protected boolean createOrUpdateContentProperties(EntityObject entityObject, List<String> keys, boolean isActionRequest) {
        AbstractPage page = (AbstractPage)entityObject;
        int index = 0;
        boolean success = true;
        String key = "";
        try {
            Content content = (Content)this.contentService.find(new Expansion[0]).withId(page.getContentId()).fetchOrNull();
            if (content == null) {
                log.warn("There is no content belonging to " + page + ". Is not possible to attach any workflows content property data.");
                return false;
            }
            while (success && index < keys.size()) {
                key = keys.get(index++);
                success = this.doUpdateMethodForKey(page, content, key, isActionRequest);
            }
            if (success) {
                success = this.updateGlobalModelVersion(page, content);
            }
            if (!success) {
                log.warn("properties creating / update failed when processing the key:" + key + ", of page:" + page);
            }
            return success;
        }
        catch (Exception e) {
            log.error("Problems saving " + key + " associated to " + page, (Throwable)e);
            return false;
        }
    }

    private boolean doUpdateMethodForKey(AbstractPage page, Content content, String key, boolean isActionRequest) {
        switch (key) {
            case "workflows": {
                return this.updateWorkflowsContentProperties(page, content, isActionRequest);
            }
            case "readacks": {
                return this.updateReadAckContentProperties(page, content);
            }
            case "tasks": {
                return this.updateTasksContentProperties(page, content);
            }
        }
        return false;
    }

    private boolean updateGlobalModelVersion(AbstractPage page, Content content) {
        String globalModelVersionJson = this.workflowsPropertyExtractor.getCurrentGlobalModelVersionJson();
        return this.jsonContentPropertyService.updateOrCreate(page, content, "comalaworkflowsglobalmodelversion", globalModelVersionJson);
    }

    private boolean updateReadAckContentProperties(AbstractPage page, Content content) {
        String jsonString = this.readAckPropertyExtractor.getJsonOf(page);
        return this.jsonContentPropertyService.updateOrCreate(page, content, "readack", jsonString);
    }

    private boolean updateTasksContentProperties(AbstractPage page, Content content) {
        String taskContentPropertyAsJson = this.taskPropertyExtractor.getJsonOf(page);
        boolean successfulPropertyUpdate = this.jsonContentPropertyService.updateOrCreate(page, content, "comalaworkflowstasks", taskContentPropertyAsJson);
        boolean successfulModelUpdate = this.jsonContentPropertyService.updateOrCreate(page, content, "comalaworkflowstaskscurrentmodelversion", this.taskPropertyExtractor.getCurrentTaskModelVersionJson());
        return successfulModelUpdate && successfulPropertyUpdate;
    }

    private boolean updateWorkflowsContentProperties(AbstractPage page, Content content, boolean isActionRequest) {
        FullWorklfowsContentPropertyModel fwcpModel = this.workflowsPropertyExtractor.getFullWorkflowsContentPropertyModel(page, isActionRequest);
        if (fwcpModel == null) {
            log.warn("Could not update workflows content properties because page " + page.getIdAsString() + " doesn't contain workflow with states");
            return false;
        }
        boolean successfulUpdate = this.jsonContentPropertyService.updateOrCreate(page, content, "comalaworkflows", this.workflowsPropertyExtractor.serialize(fwcpModel.workflowsContentPropertyModel));
        successfulUpdate = this.jsonContentPropertyService.updateOrCreate(page, content, "comalaworkflowsapprovals", this.workflowsPropertyExtractor.serialize(fwcpModel.approvals)) && successfulUpdate;
        successfulUpdate = this.jsonContentPropertyService.updateOrCreate(page, content, "comalaworkflowsapprovedapprovals", this.workflowsPropertyExtractor.serialize(fwcpModel.approvedApprovals)) && successfulUpdate;
        successfulUpdate = this.jsonContentPropertyService.updateOrCreate(page, content, "comalaworkflowspendingapprovals", this.workflowsPropertyExtractor.serialize(fwcpModel.pendingApprovals)) && successfulUpdate;
        successfulUpdate = this.jsonContentPropertyService.updateOrCreate(page, content, "comalaworkflowsrejectedapprovals", this.workflowsPropertyExtractor.serialize(fwcpModel.rejectedApprovals)) && successfulUpdate;
        successfulUpdate = this.jsonContentPropertyService.updateOrCreate(page, content, "comalaworkflowspendingapprovers", this.workflowsPropertyExtractor.serialize(fwcpModel.pendingApprovers)) && successfulUpdate;
        successfulUpdate = this.jsonContentPropertyService.updateOrCreate(page, content, "comalaworkflowsfinishedapprovers", this.workflowsPropertyExtractor.serialize(fwcpModel.finishedApprovers)) && successfulUpdate;
        successfulUpdate = this.jsonContentPropertyService.updateOrCreate(page, content, "comalaworkflowslastfinalversionapprovers", this.workflowsPropertyExtractor.serialize(fwcpModel.lastFinalVersionApprovers)) && successfulUpdate;
        successfulUpdate = this.jsonContentPropertyService.updateOrCreate(page, content, "comalaworflowscurrentmodelversion", this.workflowsPropertyExtractor.getCurrentWorkflowsModelVersionJson()) && successfulUpdate;
        return successfulUpdate;
    }

    @Override
    public LongRunningTaskId launchPopulatorTaskForSpace(Space space) {
        if (log.isDebugEnabled()) {
            log.debug("Pages and blog posts retrieval start");
        }
        HashSet<Long> pagesAndBlogsIds = new HashSet<Long>();
        if (space != null) {
            this.pageManager.getPages(space, true).forEach(page -> pagesAndBlogsIds.add(page.getId()));
            this.pageManager.getBlogPosts(space, true).forEach(blogPost -> pagesAndBlogsIds.add(blogPost.getId()));
        }
        if (log.isDebugEnabled()) {
            log.debug("Total number of pages and blog posts found in space " + (space != null ? space.getKey() : null) + ": " + pagesAndBlogsIds.size());
        }
        DataExtractorPopulationTask task = DataExtractorPopulationTask.fromDeps(this.transactionTemplate, this, this.pageManager, this.accessModeService, this.workflowAdvancedConfigurationManager).setPageIds(pagesAndBlogsIds);
        return this.longRunningTaskManager.startLongRunningTask((User)AuthenticatedUserThreadLocal.get(), (LongRunningTask)task);
    }

    private PageResponse<Content> cqlSearchContentWithRetries(int offset, int retries) {
        try {
            return this.cqlSearchService.searchContent(CQL_PENDING_PAGES_QUERY, (PageRequest)new SimplePageRequest(offset, 200), ExpansionsParser.parse((String)CQL_PENDING_PAGES_EXPAND));
        }
        catch (Exception ex) {
            if (retries > 0) {
                try {
                    Thread.sleep(10000L);
                    return this.cqlSearchContentWithRetries(offset, retries - 1);
                }
                catch (InterruptedException iex) {
                    log.error(iex.getMessage());
                }
            } else if (ex instanceof InvalidDynamicFieldQueryException || ex instanceof BadRequestException) {
                log.debug("After all retries, invalid query happened", (Throwable)ex);
            } else {
                log.error(ex.getMessage());
            }
            return null;
        }
    }

    private Set<Long> getPageIds() {
        PageResponse<Content> results;
        if (log.isDebugEnabled()) {
            log.debug("Starting getting pageIds");
        }
        int offset = 0;
        HashSet<Long> pageIds = new HashSet<Long>();
        do {
            if ((results = this.cqlSearchContentWithRetries(offset, 5)) != null) {
                for (Content content : results.getResults()) {
                    pageIds.add(content.getId().asLong());
                }
            }
            offset += 200;
        } while (results != null && results.hasMore());
        if (log.isDebugEnabled()) {
            log.debug("Finished getting pageIds, " + pageIds.size() + " ids have been gathered");
        }
        return pageIds;
    }

    @Override
    public LongRunningTaskId launchPopulatorTaskForNotPopulatedPages() {
        if (log.isDebugEnabled()) {
            log.debug("Launching population task");
        }
        DataExtractorPopulationTask task = DataExtractorPopulationTask.fromDeps(this.transactionTemplate, this, this.pageManager, this.accessModeService, this.workflowAdvancedConfigurationManager).setPageIdSupplier(this::getPageIds);
        return this.longRunningTaskManager.startLongRunningTask((User)AuthenticatedUserThreadLocal.get(), (LongRunningTask)task);
    }

    @Override
    public boolean updateWorkflowsContentProperties(EntityObject entityObject) {
        return this.updateWorkflowsContentProperties(entityObject, true);
    }

    @Override
    public boolean updateReadAckContentProperties(EntityObject entityObject) {
        return this.updateReadAckContentProperties(entityObject, true);
    }

    @Override
    public boolean updateTasksContentProperties(EntityObject entityObject) {
        return this.updateTasksContentProperties(entityObject, true);
    }

    @Override
    public boolean updateAllContentProperties(EntityObject entityObject) {
        return this.updateAllContentProperties(entityObject, true);
    }
}

