/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoc.notification.model;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.comalatech.confluence.adhoc.notification.model.AdHocEmail;
import org.springframework.web.util.HtmlUtils;

public class TaskEventEmail
extends AdHocEmail {
    protected static final String DEFAULT_TASK_TEMPLATE = "task-event";
    public static final String TASKNAME_KEY = "taskName";
    public static final String TASKID_KEY = "taskId";
    public static final String NOTE_KEY = "assignmentNoteHtml";
    public static final String ASSIGNEE_KEY = "assignee";
    public static final String COMPLETER_KEY = "completer";
    public static final String ACTIVITY_DESCRIPTION_I18N = "activityDescription";
    public static final String DUE_DATE_KEY = "dueDate";
    protected String subjectI18n;

    public TaskEventEmail(String subjectI18n) {
        this.subjectI18n = subjectI18n;
    }

    @Override
    public String getSubject() {
        return HtmlUtils.htmlEscape((String)ConfluenceActionSupport.getTextStatic((String)this.subjectI18n, (Object[])new String[]{(String)this.getContextProperties().get(TASKNAME_KEY), (String)this.getContextProperties().get(ASSIGNEE_KEY), (String)this.getContextProperties().get(COMPLETER_KEY)}));
    }

    @Override
    public String getTemplateName() {
        return DEFAULT_TASK_TEMPLATE;
    }

    @Override
    public String getBody() {
        long pageId = this.getEntityId();
        String taskId = (String)this.getContextProperties().get(TASKID_KEY);
        String taskName = (String)this.getContextProperties().get(TASKNAME_KEY);
        String description = (String)this.getContextProperties().get(ACTIVITY_DESCRIPTION_I18N);
        String assignee = (String)this.getContextProperties().get(ASSIGNEE_KEY);
        String dueDate = (String)this.getContextProperties().get(DUE_DATE_KEY);
        String path = this.getBaseUrl() + "/pages/viewpage.action?pageId=" + pageId + "&task=" + taskId;
        return HtmlUtils.htmlEscape((String)ConfluenceActionSupport.getTextStatic((String)description, (Object[])new String[]{taskName, path, assignee, dueDate}));
    }
}

