/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoc.notification.listener;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.sal.api.features.DarkFeatureManager;
import com.atlassian.sal.api.user.UserKey;
import com.comalatech.confluence.adhoc.notification.AdhocNotificationService;
import com.comalatech.confluence.adhoc.notification.WorkflowNotificationConfigManager;
import com.comalatech.confluence.adhoc.notification.model.NotificationType;
import com.comalatech.confluence.adhoc.notification.model.StateExpiredEventEmail;
import com.comalatech.confluence.nextup.slack.service.WorkflowsEventPublisher;
import com.comalatech.confluence.util.WorkflowsListener;
import com.comalatech.confluence.workflow.PageWorkflows;
import com.comalatech.confluence.workflow.WorkflowAccessor;
import com.comalatech.confluence.workflow.WorkflowConfigurationManager;
import com.comalatech.confluence.workflowcontainer.model.WorkflowVisibilityInternal;
import com.comalatech.workflow.event.StateExpireEvent;
import com.comalatech.workflow.model.State;
import java.util.Set;
import java.util.stream.Collectors;

public class StateNotificationListener
extends WorkflowsListener {
    protected final WorkflowNotificationConfigManager workflowNotificationConfigManager;
    protected final AdhocNotificationService adhocNotificationService;
    protected final UserAccessor userAccessor;
    protected final WorkflowAccessor workflowAccessor;
    protected final WorkflowConfigurationManager workflowConfigurationManager;
    protected final WorkflowsEventPublisher workflowsEventPublisher;
    private final DarkFeatureManager darkFeatureManager;

    public StateNotificationListener(EventPublisher eventPublisher, WorkflowNotificationConfigManager workflowNotificationConfigManager, AdhocNotificationService adhocNotificationService, UserAccessor userAccessor, WorkflowAccessor workflowAccessor, WorkflowConfigurationManager workflowConfigurationManager, WorkflowsEventPublisher workflowsEventPublisher, DarkFeatureManager darkFeatureManager) {
        super(eventPublisher);
        this.workflowNotificationConfigManager = workflowNotificationConfigManager;
        this.adhocNotificationService = adhocNotificationService;
        this.userAccessor = userAccessor;
        this.workflowAccessor = workflowAccessor;
        this.workflowConfigurationManager = workflowConfigurationManager;
        this.workflowsEventPublisher = workflowsEventPublisher;
        this.darkFeatureManager = darkFeatureManager;
    }

    @EventListener
    public void stateExpiredEvent(StateExpireEvent event) {
        AbstractPage page = (AbstractPage)event.getContent();
        if (this.workflowNotificationConfigManager.isNotificationEnabled(NotificationType.STATE_EXPIRED, page.getSpaceKey())) {
            State state = event.getState();
            Permission requiredPermission = this.getConfluencePermissionRequired(page, state);
            StateExpiredEventEmail email = new StateExpiredEventEmail();
            email.setEntityId(event.getContent().getId());
            email.addContextProperty("stateName", state.getName());
            email.addContextProperty("pageTitle", page.getTitle());
            email.addContextProperty("pagePath", page.getUrlPath());
            Set<ConfluenceUser> watchers = this.adhocNotificationService.getContentWatchers(page, null, true, null, null);
            if (this.darkFeatureManager.isEnabledForAllUsers("comalatech.workflows.slack.docs.enabled").orElse(Boolean.FALSE).booleanValue() && this.workflowNotificationConfigManager.isNotificationEnabled(NotificationType.SLACK_NOTIFICATION, page.getSpaceKey())) {
                this.workflowsEventPublisher.publish(email.getSubject(), email.getBody(), watchers.stream().map(ConfluenceUser::getKey).map(UserKey::getStringValue).collect(Collectors.joining(",")), page.getId());
            }
            this.adhocNotificationService.sendEmail(email, watchers, requiredPermission, null);
        }
    }

    protected Permission getConfluencePermissionRequired(AbstractPage page, State state) {
        WorkflowVisibilityInternal visibility;
        PageWorkflows pageWorkflows = this.workflowAccessor.getPageWorkflows(page);
        if (pageWorkflows != null && pageWorkflows.isRequiresFinalApproval() && !state.isPublished() && WorkflowVisibilityInternal.CONTRIBUTORS == (visibility = this.workflowConfigurationManager.getHistoryVisibility(page.getSpaceKey()))) {
            return Permission.EDIT;
        }
        return Permission.VIEW;
    }
}

