/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoc.notification;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.event.api.EventPublisher;
import com.comalatech.confluence.adhoc.notification.WorkflowNotificationConfigManager;
import com.comalatech.confluence.adhoc.notification.events.SpaceWorkflowNotificationConfigurationUpdatedEventImpl;
import com.comalatech.confluence.adhoc.notification.events.WorkflowNotificationConfigurationUpdatedEventImpl;
import com.comalatech.confluence.adhoc.notification.model.NotificationType;
import com.comalatech.confluence.adhoc.notification.model.SpaceNotifications;
import com.opensymphony.util.TextUtils;
import javax.annotation.Nullable;

public class DefaultWorkflowNotificationConfigManager
implements WorkflowNotificationConfigManager {
    protected static final String BANDANA_KEY_PREFIX = "com.comalatech.notification.config.";
    protected final BandanaManager bandanaManager;
    protected final EventPublisher eventPublisher;
    protected final SpaceManager spaceManager;

    public DefaultWorkflowNotificationConfigManager(BandanaManager bandanaManager, EventPublisher eventPublisher, SpaceManager spaceManager) {
        this.bandanaManager = bandanaManager;
        this.eventPublisher = eventPublisher;
        this.spaceManager = spaceManager;
    }

    @Override
    public void setNotificationConfig(NotificationType notificationType, boolean enabled) {
        boolean existingValue = this.isNotificationEnabled(notificationType);
        if (existingValue != enabled) {
            this.bandanaManager.setValue((BandanaContext)ConfluenceBandanaContext.GLOBAL_CONTEXT, this.bandanaKey(notificationType), (Object)enabled);
            WorkflowNotificationConfigurationUpdatedEventImpl event = new WorkflowNotificationConfigurationUpdatedEventImpl(notificationType.getName(), Boolean.toString(enabled));
            this.eventPublisher.publish((Object)event);
        }
    }

    @Override
    public boolean isNotificationEnabled(NotificationType notificationType) {
        Object bandanaObject = this.bandanaManager.getValue((BandanaContext)ConfluenceBandanaContext.GLOBAL_CONTEXT, this.bandanaKey(notificationType));
        if (bandanaObject instanceof Boolean) {
            return (Boolean)bandanaObject;
        }
        return !notificationType.equals((Object)NotificationType.SLACK_NOTIFICATION);
    }

    @Override
    public boolean isNotificationEnabled(NotificationType notificationType, @Nullable String spaceKey) {
        if (!TextUtils.stringSet((String)spaceKey)) {
            return this.isNotificationEnabled(notificationType);
        }
        switch (this.getSpaceNotificationsMode(spaceKey, notificationType)) {
            case ENABLED: {
                return true;
            }
            case DISABLED: {
                return false;
            }
        }
        return this.isNotificationEnabled(notificationType);
    }

    @Override
    public SpaceNotifications.Mode getSpaceNotificationsMode(String spaceKey, NotificationType type) {
        String mode = (String)this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(spaceKey), this.bandanaKey(type), false);
        if (TextUtils.stringSet((String)mode)) {
            return SpaceNotifications.Mode.valueOf(mode);
        }
        return SpaceNotifications.Mode.DEFAULT;
    }

    @Override
    public void setSpaceNotificationsMode(SpaceNotifications spaceNotifications, String spaceKey) {
        if (spaceKey != null) {
            Space space = this.spaceManager.getSpace(spaceKey);
            SpaceNotifications.Mode currentValue = this.getSpaceNotificationsMode(spaceKey, spaceNotifications.getNotificationType());
            if (currentValue != spaceNotifications.getMode()) {
                if (spaceNotifications.getMode() == SpaceNotifications.Mode.DEFAULT) {
                    this.bandanaManager.removeValue((BandanaContext)new ConfluenceBandanaContext(spaceKey), this.bandanaKey(spaceNotifications.getNotificationType()));
                } else {
                    this.bandanaManager.setValue((BandanaContext)new ConfluenceBandanaContext(spaceKey), this.bandanaKey(spaceNotifications.getNotificationType()), (Object)spaceNotifications.getMode().name());
                }
                SpaceWorkflowNotificationConfigurationUpdatedEventImpl event = new SpaceWorkflowNotificationConfigurationUpdatedEventImpl(space, spaceNotifications.getNotificationType().getName(), spaceNotifications.getMode().name());
                this.eventPublisher.publish((Object)event);
            }
        }
    }

    protected String bandanaKey(NotificationType notificationType) {
        return BANDANA_KEY_PREFIX + notificationType.getName();
    }
}

