/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflowreports;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.TimeZone;
import com.atlassian.confluence.core.VersionHistorySummary;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.ConfluenceUserPreferences;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.user.User;
import com.comalatech.confluence.dataextractor.ComalaPropertiesSetManager;
import com.comalatech.confluence.ipc.api.DefaultStateService;
import com.comalatech.confluence.readack.activity.ReadAckActivityManager;
import com.comalatech.confluence.readack.activity.ReadAckActivityModel;
import com.comalatech.confluence.states.model.Activity;
import com.comalatech.confluence.states.model.Assignment;
import com.comalatech.confluence.states.model.DueDateRecord;
import com.comalatech.confluence.states.model.PageState;
import com.comalatech.confluence.states.model.TaskCompletion;
import com.comalatech.confluence.tasks.model.PageTask;
import com.comalatech.confluence.tasks.model.PageTasks;
import com.comalatech.confluence.workflow.ApprovalAccessor;
import com.comalatech.confluence.workflow.PageWorkflows;
import com.comalatech.confluence.workflow.WorkflowAccessor;
import com.comalatech.confluence.workflow.model.ApprovalCheck;
import com.comalatech.confluence.workflow.model.Approver;
import com.comalatech.confluence.workflow.model.DueDateRecordAware;
import com.comalatech.confluence.workflow.user.WorkflowUserAccessor;
import com.comalatech.confluence.workflowreports.ActivityManager;
import com.comalatech.confluence.workflowreports.model.ActivityEntry;
import com.comalatech.confluence.workflowreports.model.ActivityReportEntry;
import com.comalatech.confluence.workflowreports.model.ActivityReportOptions;
import com.comalatech.confluence.workflowreports.model.DueDateRecordExpiredActivity;
import com.comalatech.confluence.workflowreports.model.ModificationActivity;
import com.comalatech.confluence.workflowreports.model.ReadAckActivity;
import com.comalatech.workflow.StateService;
import com.comalatech.workflow.model.State;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.iterators.ReverseListIterator;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultActivityManager
implements ActivityManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultActivityManager.class);
    private final ApprovalAccessor approvalAccessor;
    private final StateService stateService;
    private final PageManager pageManager;
    private final UserAccessor userAccessor;
    private final WorkflowAccessor workflowAccessor;
    private final WorkflowUserAccessor workflowUserAccessor;
    private final ComalaPropertiesSetManager contentPropertyManager;
    private final ReadAckActivityManager readAckActivityManager;
    public static final String LAST_ACTIVITY_DATE_KEY = "com.comalatech.workflow.lastactivitydate";

    public DefaultActivityManager(ApprovalAccessor approvalAccessor, StateService stateService, PageManager pageManager, UserAccessor userAccessor, WorkflowAccessor workflowAccessor, WorkflowUserAccessor workflowUserAccessor, ComalaPropertiesSetManager contentPropertyManager, ReadAckActivityManager readAckActivityManager) {
        this.approvalAccessor = approvalAccessor;
        this.stateService = stateService;
        this.pageManager = pageManager;
        this.userAccessor = userAccessor;
        this.workflowAccessor = workflowAccessor;
        this.workflowUserAccessor = workflowUserAccessor;
        this.contentPropertyManager = contentPropertyManager;
        this.readAckActivityManager = readAckActivityManager;
    }

    @Override
    public void setRecentActivityDateCache(ContentEntityObject page, Date date) {
        if (log.isDebugEnabled()) {
            log.debug("setting most recent activity on page: " + page + "  to: " + date);
        }
        this.contentPropertyManager.setStringProperty(page, LAST_ACTIVITY_DATE_KEY, date.getTime() + "");
    }

    @Override
    public void clearRecentActivityDateCache(ContentEntityObject page) {
        this.contentPropertyManager.removeProperty(page, LAST_ACTIVITY_DATE_KEY);
    }

    @Override
    public Date getCachedRecentActivityDate(AbstractPage page) {
        String lastActivityString = this.contentPropertyManager.getStringProperty((ContentEntityObject)page, LAST_ACTIVITY_DATE_KEY);
        if (TextUtils.stringSet((String)lastActivityString)) {
            try {
                long lastActivityTime = Long.parseLong(lastActivityString);
                return new Date(lastActivityTime);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public List<ActivityReportEntry> getActivityReport(AbstractPage page, ActivityReportOptions options) {
        List<ActivityEntry> activities = this.createActivityList(page, options);
        List<ActivityReportEntry> entries = this.createReportEntries(activities = this.optimize(activities), options);
        if (entries.size() > options.getMaxEntries()) {
            entries = entries.subList(0, options.getMaxEntries());
        }
        return entries;
    }

    @Override
    public List<ActivityReportEntry> getActivityReportForMigration(AbstractPage page, ActivityReportOptions options) {
        List<ActivityReportEntry> entries;
        List<ActivityEntry> activities = this.createMigrationActivityList(page, options);
        if (options.isPublishView()) {
            PageState pageState;
            ActivityEntry activity;
            ListIterator<ActivityEntry> iterator = activities.listIterator(activities.size());
            while (!(!iterator.hasPrevious() || (activity = iterator.previous()).getActivity() instanceof PageState && (pageState = (PageState)activity.getActivity()).isPublished())) {
                iterator.remove();
            }
        }
        if ((entries = this.createReportEntries(activities = this.optimize(activities), options)).size() > options.getMaxEntries()) {
            entries = entries.subList(0, options.getMaxEntries());
        }
        return entries;
    }

    private List<ActivityReportEntry> createReportEntries(List<ActivityEntry> activities, ActivityReportOptions options) {
        ArrayList<ActivityReportEntry> entries = new ArrayList<ActivityReportEntry>(activities.size());
        ActivityReportEntry entry = null;
        TimeZone timeZone = this.getTimeZone();
        for (ActivityEntry activity : activities) {
            if (entry == null || !entry.getActivityEntries().get(0).isSimilar(activity, timeZone)) {
                entry = new ActivityReportEntry(activity, this.workflowUserAccessor.getUser(activity.getActivity().getPerformer()));
                entries.add(entry);
                continue;
            }
            entry.addActivityEntry(activity);
        }
        if (options.isDescending()) {
            Collections.reverse(entries);
            for (ActivityReportEntry reportEntry : entries) {
                Collections.reverse(reportEntry.getActivityEntries());
            }
            if (entries.size() > 0) {
                ((ActivityReportEntry)entries.get(0)).setPrintHeader(true);
                ((ActivityReportEntry)entries.get(0)).setPrintState(true);
            }
        }
        DateTime headingDate = null;
        String previousStateName = "";
        for (ActivityReportEntry reportEntry : entries) {
            reportEntry.setPrintHeader(headingDate == null || !this.getDateStartOfDay(reportEntry.getFrom()).equals(headingDate));
            headingDate = this.getDateStartOfDay(reportEntry.getFrom());
            if (reportEntry.getPageState() == null || reportEntry.getPageState().getState().equals(previousStateName)) continue;
            reportEntry.setPrintState(true);
            previousStateName = reportEntry.getPageState().getState();
        }
        return entries;
    }

    public DateTime getDateStartOfDay(Date date) {
        if (date == null) {
            return null;
        }
        DateTime dateTime = new DateTime(date);
        dateTime = dateTime.withZone(DateTimeZone.forTimeZone(this.getTimeZone().getWrappedTimeZone()));
        dateTime = dateTime.withTimeAtStartOfDay();
        return dateTime;
    }

    private TimeZone getTimeZone() {
        ConfluenceUserPreferences preferences = this.userAccessor.getConfluenceUserPreferences((User)AuthenticatedUserThreadLocal.get());
        return preferences.getTimeZone();
    }

    private List<ActivityEntry> optimize(List<ActivityEntry> activities) {
        ArrayList<ActivityEntry> result = new ArrayList<ActivityEntry>();
        PageState currentState = null;
        PageState firstState = null;
        ListIterator<ActivityEntry> activityEntryIterator = activities.listIterator();
        block0: while (activityEntryIterator.hasNext()) {
            ActivityEntry activityEntry = activityEntryIterator.next();
            if (activityEntry.getActivity() instanceof PageState) {
                currentState = (PageState)activityEntry.getActivity();
                if (firstState == null) {
                    firstState = currentState;
                }
            }
            if (activityEntry.getPageState() == null) {
                activityEntry.setPageState(currentState);
            }
            if (activityEntry.getActivity() instanceof ModificationActivity) {
                ModificationActivity modificationActivity = (ModificationActivity)activityEntry.getActivity();
                if (modificationActivity.isCreation()) continue;
                while (activityEntryIterator.hasNext()) {
                    ActivityEntry nextActivityEntry = activityEntryIterator.next();
                    if (nextActivityEntry.getActivity() instanceof ModificationActivity) {
                        activityEntry.addActivity(nextActivityEntry.getActivity());
                        activityEntryIterator.remove();
                        continue;
                    }
                    activityEntryIterator.previous();
                    continue block0;
                }
                continue;
            }
            if (!(activityEntry.getActivity() instanceof PageTask) || !activityEntryIterator.hasNext()) continue;
            PageTask task = (PageTask)activityEntry.getActivity();
            ActivityEntry nextActivity = activityEntryIterator.next();
            if (nextActivity.getActivity() instanceof Assignment && task.equals(nextActivity.getPageTask()) && task.getPerformer() != null && task.getPerformer().equals(nextActivity.getActivity().getPerformer())) {
                activityEntry.addActivity(nextActivity.getActivity());
                activityEntryIterator.remove();
                continue;
            }
            activityEntryIterator.previous();
        }
        this.setStateForReadConfirmationEntries(activities, firstState);
        LinkedHashMap groupByState = activities.stream().collect(Collectors.groupingBy(act -> Optional.ofNullable(act.getPageState() == null ? null : Integer.valueOf(act.getPageState().getId())), LinkedHashMap::new, Collectors.toList()));
        List nullableState = (List)groupByState.get(Optional.empty());
        if (nullableState != null && !nullableState.isEmpty()) {
            result.addAll(nullableState);
        }
        result.addAll(groupByState.entrySet().stream().filter(group -> !Optional.empty().equals(group.getKey())).flatMap(elem -> ((List)elem.getValue()).stream()).collect(Collectors.toList()));
        return result;
    }

    private List<ActivityEntry> createMigrationActivityList(AbstractPage page, ActivityReportOptions options) {
        PageState publishedState = (PageState)this.stateService.getPublishedState((ContentEntityObject)page);
        PageWorkflows pageWorkflows = this.workflowAccessor.getPageWorkflows(page);
        ArrayList<ActivityEntry> activities = new ArrayList<ActivityEntry>();
        List<PageState> states = ((DefaultStateService)this.stateService).getStates((ContentEntityObject)page);
        ApprovalCheck[] approvalChecks = this.approvalAccessor.getApprovalChecks(page);
        if (options.isViewStates() || options.isViewTasks()) {
            boolean hideStates;
            boolean bl = hideStates = !options.isViewStates();
            if (pageWorkflows != null) {
                hideStates = pageWorkflows.isHidStates() || hideStates;
            }
            for (int i = 0; i < states.size(); ++i) {
                PageState state = states.get(i);
                if (!hideStates) {
                    if (pageWorkflows != null) {
                        pageWorkflows.setStateModel(state);
                    }
                    if (publishedState != null && publishedState.getId() == state.getId()) {
                        state.setPublished(true);
                    }
                    if (!this.nextStateHasChangeReason(i, states)) {
                        activities.add(ActivityEntry.create(state));
                    }
                }
                HashSet<Integer> approvalCheckIds = new HashSet<Integer>();
                List<ApprovalCheck> approvalChecksForState = this.approvalAccessor.getAllApprovalChecksForState(approvalChecks, state);
                for (ApprovalCheck approvalCheck : approvalChecksForState) {
                    if (approvalCheckIds.contains(approvalCheck.getId())) continue;
                    approvalCheckIds.add(approvalCheck.getId());
                    for (Approver approver : approvalCheck.getApprovers()) {
                        activities.add(ActivityEntry.create(approver, state, approvalCheck));
                    }
                }
            }
        }
        if (states.size() == 0) {
            for (ApprovalCheck approvalCheck : approvalChecks) {
                for (Approver approver : approvalCheck.getApprovers()) {
                    activities.add(ActivityEntry.create(approver, null, approvalCheck));
                }
            }
        }
        Collections.sort(activities);
        return activities;
    }

    private List<ActivityEntry> createActivityList(AbstractPage page, ActivityReportOptions options) {
        ArrayList<ActivityEntry> activities = new ArrayList<ActivityEntry>();
        List<PageState> states = this.getStatesForReport(page, options);
        Map<Integer, List<ApprovalCheck>> stateApprovalChecks = this.getStatesApprovalChecksForReport(page, states);
        this.addVersionHistoryActivities(page, options, activities);
        this.addCommentsActivities(page, options, activities);
        this.addReadAckActivities(page, options, activities);
        this.addStateRelatedActivities(page, options, states, stateApprovalChecks, activities);
        this.addNonStateApprovalsActivities(page, activities, states);
        Collections.sort(activities);
        return activities;
    }

    private List<PageState> getStatesForReport(AbstractPage page, ActivityReportOptions options) {
        PageState publishedState = (PageState)this.stateService.getPublishedState((ContentEntityObject)page);
        List<? extends State> states = this.stateService.getStates((ContentEntityObject)page);
        if (options.isPublishView()) {
            ReverseListIterator reverseIterator = new ReverseListIterator(states);
            while (reverseIterator.hasNext()) {
                PageState state = (PageState)reverseIterator.next();
                if (publishedState != null && publishedState.getId() == state.getId()) break;
                reverseIterator.remove();
            }
        }
        return states;
    }

    private Map<Integer, List<ApprovalCheck>> getStatesApprovalChecksForReport(AbstractPage page, List<PageState> states) {
        List statesIds = states.stream().mapToInt(PageState::getId).mapToObj(Integer::valueOf).collect(Collectors.toList());
        if (statesIds.isEmpty()) {
            return Collections.emptyMap();
        }
        Map<Integer, List<ApprovalCheck>> stateApprovals = Arrays.stream(this.approvalAccessor.getApprovalChecks(page)).filter(approvalCheck -> statesIds.contains(approvalCheck.getStateId())).collect(Collectors.groupingBy(ApprovalCheck::getStateId));
        return stateApprovals;
    }

    private void addVersionHistoryActivities(AbstractPage page, ActivityReportOptions options, List<ActivityEntry> activities) {
        if (options.isViewEdits()) {
            List history = this.pageManager.getVersionHistorySummaries((ContentEntityObject)page);
            for (VersionHistorySummary historySummary : history) {
                ArrayList<ConfluenceUser> pageContributors = new ArrayList<ConfluenceUser>(historySummary.getContributorSet());
                activities.add(ActivityEntry.create(historySummary, pageContributors));
            }
        }
    }

    private void addCommentsActivities(AbstractPage page, ActivityReportOptions options, List<ActivityEntry> activities) {
        if (options.isViewComments()) {
            List comments = page.getComments();
            for (Comment comment : comments) {
                activities.add(ActivityEntry.create(comment));
            }
        }
    }

    private void addReadAckActivities(AbstractPage page, ActivityReportOptions options, List<ActivityEntry> activities) {
        if (options.isViewStates() || options.isViewTasks()) {
            List<ReadAckActivityModel> readAckActivities = this.readAckActivityManager.getReadAckActivities(page);
            for (ReadAckActivityModel act : readAckActivities) {
                activities.add(ActivityEntry.create(act, this.workflowUserAccessor.getAddonUser().getName()));
            }
        }
    }

    private void addStateRelatedActivities(AbstractPage page, ActivityReportOptions options, List<PageState> states, Map<Integer, List<ApprovalCheck>> stateApprovalChecks, List<ActivityEntry> activities) {
        PageWorkflows pageWorkflows = this.workflowAccessor.getPageWorkflows(page);
        PageState publishedState = (PageState)this.stateService.getPublishedState((ContentEntityObject)page);
        if (options.isViewStates() || options.isViewTasks()) {
            boolean hideStates = !options.isViewStates() || pageWorkflows != null && pageWorkflows.isHidStates();
            int lastStateId = -1;
            if (!states.isEmpty()) {
                lastStateId = states.get(states.size() - 1).getId();
            }
            for (int i = 0; i < states.size(); ++i) {
                PageState state = states.get(i);
                if (!hideStates) {
                    if (pageWorkflows != null) {
                        pageWorkflows.setStateModel(state);
                    }
                    if (publishedState != null && publishedState.getId() == state.getId()) {
                        state.setPublished(true);
                    }
                    if (!this.nextStateHasChangeReason(i, states)) {
                        activities.add(ActivityEntry.create(state));
                    }
                    this.addStateDueDateActivities(state, activities);
                }
                boolean currentState = state.getId() == lastStateId;
                HashSet<Integer> approvalCheckIds = new HashSet<Integer>();
                if (options.isViewTasks()) {
                    PageTasks pageTasks = state.getPageTasks();
                    List<PageTask> allPageTasks = pageTasks.get();
                    allPageTasks.addAll(pageTasks.getDeletedTasks());
                    for (PageTask pageTask : allPageTasks) {
                        activities.add(ActivityEntry.create((Activity)pageTask, state, currentState));
                        for (Assignment assignment : pageTask.getAssignments()) {
                            activities.add(ActivityEntry.create((Activity)assignment, state, pageTask));
                        }
                        for (TaskCompletion completion : pageTask.getCompletions()) {
                            if (completion.getApprovalCheckId() > 0) {
                                approvalCheckIds.add(completion.getApprovalCheckId());
                            }
                            activities.add(ActivityEntry.create((Activity)completion, state, pageTask));
                        }
                        this.addDueDateActivities(pageTask, activities, state, pageTask, null);
                    }
                    for (PageTask pageTask : pageTasks.getDeletedTasks()) {
                        activities.add(ActivityEntry.create((Activity)pageTask.getDeletion(), state, pageTask));
                    }
                }
                for (ApprovalCheck approvalCheck : stateApprovalChecks.getOrDefault(state.getId(), Collections.emptyList())) {
                    if (approvalCheckIds.contains(approvalCheck.getId())) continue;
                    approvalCheckIds.add(approvalCheck.getId());
                    List<? extends Assignment> approvalAssignments = approvalCheck.getAssignmentHistory();
                    for (Assignment assignment : approvalAssignments) {
                        activities.add(ActivityEntry.create((Activity)assignment, state, approvalCheck));
                    }
                    for (Approver approver : approvalCheck.getApprovers()) {
                        activities.add(ActivityEntry.create(approver, state, approvalCheck));
                    }
                }
            }
        }
    }

    private void addNonStateApprovalsActivities(AbstractPage page, List<ActivityEntry> activities, List<PageState> states) {
        if (states.isEmpty()) {
            for (ApprovalCheck approvalCheck : this.approvalAccessor.getApprovalChecks(page)) {
                for (Approver approver : approvalCheck.getApprovers()) {
                    activities.add(ActivityEntry.create(approver, null, approvalCheck));
                }
            }
        }
    }

    private boolean nextStateHasChangeReason(int index, List<PageState> states) {
        if (index == states.size() - 1) {
            return false;
        }
        PageState state = states.get(index);
        PageState next = states.get(index + 1);
        return next.getStateChangeReason() != null && state.equalsIgnoreChangeReason(next);
    }

    private void addStateDueDateActivities(PageState state, List<ActivityEntry> activities) {
        for (DueDateRecord dueDateHistory : state.getDueDateHistory()) {
            activities.add(ActivityEntry.create(dueDateHistory, state));
            if (!dueDateHistory.isExpiryTriggered()) continue;
            activities.add(ActivityEntry.create(new DueDateRecordExpiredActivity(dueDateHistory, this.workflowUserAccessor.getAddonUser().getName()), state));
        }
    }

    private void addDueDateActivities(DueDateRecordAware activity, List<ActivityEntry> activities, PageState state, PageTask pageTask, ApprovalCheck approvalCheck) {
        if (activity.getCurrentDueDate() != null) {
            activities.add(ActivityEntry.create(activity.getCurrentDueDate(), state, pageTask, approvalCheck));
            if (activity.getCurrentDueDate().isExpiryTriggered()) {
                activities.add(ActivityEntry.create(new DueDateRecordExpiredActivity(activity.getCurrentDueDate(), this.workflowUserAccessor.getAddonUser().getName()), state, pageTask, approvalCheck));
            }
        }
        for (DueDateRecord dueDateHistory : activity.getDueDateHistory()) {
            activities.add(ActivityEntry.create(dueDateHistory, state, pageTask, approvalCheck));
            if (!dueDateHistory.isExpiryTriggered()) continue;
            activities.add(ActivityEntry.create(new DueDateRecordExpiredActivity(dueDateHistory, this.workflowUserAccessor.getAddonUser().getName()), state, pageTask, approvalCheck));
        }
    }

    private void setStateForReadConfirmationEntries(List<ActivityEntry> activityEntries, PageState firstState) {
        activityEntries.stream().filter(act -> act.getActivity() instanceof ReadAckActivity).forEach(act -> {
            if (act.getPageState() == null) {
                act.setPageState(firstState);
            }
        });
    }
}

