/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.macros.parser;

import com.comalatech.confluence.workflow.macros.parser.Macro;
import com.comalatech.confluence.workflow.macros.parser.MacroElement;
import com.comalatech.confluence.workflow.macros.parser.MacroText;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class MacroParser {
    private Options options;

    public MacroParser() {
        this(new Options());
    }

    public MacroParser(Options options) {
        this.options = options;
    }

    public String toMacro(List<MacroElement> elements) {
        StringBuilder builder = new StringBuilder();
        elements.stream().forEach(elem -> builder.append(elem.toMacro()));
        return builder.toString();
    }

    public List<MacroElement> parse(String markup) {
        int init = 0;
        int length = markup.length();
        ArrayList<MacroElement> elements = new ArrayList<MacroElement>();
        block4: for (int i = 0; i < length; ++i) {
            switch (markup.charAt(i)) {
                case '{': {
                    if (MacroParser.isEscaped(markup, i)) continue block4;
                    if (init < i) {
                        elements.add(new MacroText(markup.substring(init, i)));
                    }
                    init = i;
                    continue block4;
                }
                case '}': {
                    if (MacroParser.isEscaped(markup, i)) continue block4;
                    Macro macroOpening = this.parseMacroOpening(markup.substring(init, i));
                    String closeTag = '{' + macroOpening.name + '}';
                    int closeTagIndex = markup.indexOf(closeTag, i);
                    if (closeTagIndex != -1) {
                        String body = markup.substring(i + 1, closeTagIndex);
                        macroOpening.body = StringUtils.isEmpty((CharSequence)body) ? Collections.EMPTY_LIST : (this.options.recursive ? this.parse(body) : Arrays.asList(new MacroText(body)));
                        init = i = closeTagIndex + closeTag.length();
                    } else {
                        init = i + 1;
                    }
                    elements.add(macroOpening);
                }
            }
        }
        if (init < length) {
            elements.add(new MacroText(markup.substring(init, length)));
        }
        return elements;
    }

    private Macro parseMacroOpening(String markup) {
        Macro macro = new Macro();
        int attributeSeparator = markup.indexOf(58);
        if (attributeSeparator != -1 && !MacroParser.isEscaped(markup, attributeSeparator)) {
            macro.name = markup.substring(1, attributeSeparator);
            String attributes = markup.substring(attributeSeparator + 1, markup.length());
            Object[] attrs = MacroParser.splitUnescaped(attributes, '|');
            if (attrs.length > 0) {
                macro.attributes = new LinkedHashMap<String, String>(attrs.length);
                if (attrs[0].indexOf(61) == -1) {
                    macro.attributes.put("name", attrs[0]);
                    attrs = (String[])ArrayUtils.remove((Object[])attrs, (int)0);
                }
                for (int i = 0; i < attrs.length; ++i) {
                    String[] attr = MacroParser.splitUnescaped(attrs[i], '=');
                    if (attr.length != 2) continue;
                    macro.attributes.put(attr[0], attr[1]);
                }
            }
        } else {
            macro.name = markup.substring(1, markup.length());
        }
        return macro;
    }

    private static boolean isEscaped(String markup, int position) {
        int prevPosition = position - 1;
        return prevPosition >= 0 && prevPosition < markup.length() && markup.charAt(prevPosition) == '\\';
    }

    private static String[] splitUnescaped(String str, char separator) {
        return str.split("(?<!\\\\)[" + separator + "]");
    }

    private static String indent(int n) {
        return String.join((CharSequence)"", Collections.nCopies(n, " "));
    }

    public static class Options {
        public boolean recursive = false;

        public Options recursive(boolean recursive) {
            this.recursive = recursive;
            return this;
        }
    }
}

