/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.listeners.triggers.content;

import com.atlassian.confluence.compat.struts2.servletactioncontext.ServletActionContextCompatManager;
import com.atlassian.confluence.event.events.ConfluenceEvent;
import com.atlassian.confluence.event.events.content.ContentEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostCreateEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostMovedEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostRemoveEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostUpdateEvent;
import com.atlassian.confluence.event.events.content.page.PageCreateEvent;
import com.atlassian.confluence.event.events.content.page.PageMoveEvent;
import com.atlassian.confluence.event.events.content.page.PageRemoveEvent;
import com.atlassian.confluence.event.events.content.page.PageUpdateEvent;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.sal.api.features.DarkFeatureManager;
import com.comalatech.confluence.documentActivity.manager.EventHistoryManager;
import com.comalatech.confluence.workflow.PageWorkflows;
import com.comalatech.confluence.workflow.WorkflowAccessor;
import com.comalatech.confluence.workflow.WorkflowActionManager;
import com.comalatech.confluence.workflow.actions.ViewPageCookieUtils;
import com.comalatech.confluence.workflow.listeners.ApprovalPersistanceHandler;
import com.comalatech.confluence.workflow.listeners.StateHandler;
import com.comalatech.confluence.workflow.listeners.triggers.TriggersListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;

public class ContentTriggersListener
extends TriggersListener {
    private static final Logger log = LoggerFactory.getLogger(ContentTriggersListener.class);
    private final StateHandler stateHandler;
    private final ApprovalPersistanceHandler approvalPersistanceHandler;
    private DarkFeatureManager darkFeatureManager;
    private ServletActionContextCompatManager servletActionContextCompatManager;

    public ContentTriggersListener(WorkflowAccessor workflowAccessor, WorkflowActionManager workflowActionManager, EventPublisher eventPublisher, StateHandler stateHandler, ApprovalPersistanceHandler approvalPersistanceHandler, EventHistoryManager eventHistoryManager, DarkFeatureManager darkFeatureManager, @Qualifier(value="servletActionContextCompat") ServletActionContextCompatManager servletActionContextCompatManager) {
        super(workflowAccessor, workflowActionManager, eventHistoryManager, darkFeatureManager, eventPublisher);
        this.stateHandler = stateHandler;
        this.approvalPersistanceHandler = approvalPersistanceHandler;
        this.darkFeatureManager = darkFeatureManager;
        this.servletActionContextCompatManager = servletActionContextCompatManager;
    }

    @EventListener
    public void onPageCreateEvent(PageCreateEvent event) {
        this.onCreateEvent((ContentEvent)event);
    }

    @EventListener
    public void onBlogPostCreateEvent(BlogPostCreateEvent event) {
        this.onCreateEvent((ContentEvent)event);
    }

    private void onCreateEvent(ContentEvent event) {
        try {
            this.logEventSource((ConfluenceEvent)event);
            PageWorkflows pageWorkflows = this.getPageWorkflows((ConfluenceEvent)event);
            if (pageWorkflows == null) {
                return;
            }
            this.stateHandler.handle(pageWorkflows);
            this.evaluateTriggers(pageWorkflows, (ConfluenceEvent)event);
        }
        catch (Exception e) {
            log.error("There has been an exception handling the event.", (Throwable)e);
        }
        catch (Error e) {
            log.error("There has been an error handling the event.", (Throwable)e);
        }
    }

    @EventListener
    public void onPageUpdateEvent(PageUpdateEvent event) {
        try {
            this.logEventSource((ConfluenceEvent)event);
            PageWorkflows pageWorkflows = this.getPageWorkflows((ConfluenceEvent)event);
            if (pageWorkflows == null) {
                return;
            }
            Page newPage = event.getPage();
            AbstractPage oldPage = event.getOriginalPage();
            if (oldPage == null) {
                if (this.darkFeatureManager.isFeatureEnabledForAllUsers("comalatech.workflows.page.update.triggers.state.storage")) {
                    this.stateHandler.handle(event, pageWorkflows);
                }
                return;
            }
            if (newPage.getId() == oldPage.getId() && newPage.getVersion() == oldPage.getVersion()) {
                return;
            }
            this.evaluateTriggers(pageWorkflows, (ConfluenceEvent)event);
            this.approvalPersistanceHandler.handle(event);
        }
        catch (Exception e) {
            log.error("There has been an exception handling the event.", (Throwable)e);
        }
        catch (Error e) {
            log.error("There has been an error handling the event.", (Throwable)e);
        }
    }

    @EventListener
    public void onBlogPostUpdateEvent(BlogPostUpdateEvent event) {
        try {
            this.logEventSource((ConfluenceEvent)event);
            PageWorkflows pageWorkflows = this.getPageWorkflows((ConfluenceEvent)event);
            if (pageWorkflows == null) {
                return;
            }
            ViewPageCookieUtils.setViewDraft((AbstractPage)event.getBlogPost(), this.servletActionContextCompatManager);
            this.evaluateTriggers(pageWorkflows, (ConfluenceEvent)event);
        }
        catch (Exception e) {
            log.error("There has been an exception handling the event.", (Throwable)e);
        }
        catch (Error e) {
            log.error("There has been an error handling the event.", (Throwable)e);
        }
    }

    @EventListener
    public void onPageMoveEvent(PageMoveEvent event) {
        this.onMoveEvent((ContentEvent)event);
    }

    @EventListener
    public void onBlogPostMovedEvent(BlogPostMovedEvent event) {
        this.onMoveEvent((ContentEvent)event);
    }

    private void onMoveEvent(ContentEvent event) {
        try {
            this.logEventSource((ConfluenceEvent)event);
            PageWorkflows pageWorkflows = this.getPageWorkflows((ConfluenceEvent)event);
            if (pageWorkflows == null) {
                return;
            }
            ViewPageCookieUtils.setViewDraft((AbstractPage)event.getContent(), this.servletActionContextCompatManager);
            this.evaluateTriggers(pageWorkflows, (ConfluenceEvent)event);
            this.processHistoryEvent(event);
        }
        catch (Exception e) {
            log.error("There has been an exception handling the event.", (Throwable)e);
        }
        catch (Error e) {
            log.error("There has been an error handling the event.", (Throwable)e);
        }
    }

    @EventListener
    public void onPageRemoveEvent(PageRemoveEvent event) {
        this.onRemoveEvent((ContentEvent)event);
    }

    @EventListener
    public void onBlogPostRemoveEvent(BlogPostRemoveEvent event) {
        this.onRemoveEvent((ContentEvent)event);
    }

    private void onRemoveEvent(ContentEvent event) {
        try {
            this.logEventSource((ConfluenceEvent)event);
            this.processHistoryEvent(event);
        }
        catch (Exception e) {
            log.error("There has been an exception handling the event.", (Throwable)e);
        }
        catch (Error e) {
            log.error("There has been an error handling the event.", (Throwable)e);
        }
    }
}

