/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.translator.infrastructure;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.comalatech.confluence.adhocworkflows.rest.permissions.WorkflowsAppRequired;
import com.comalatech.confluence.translator.application.ServerWorkflowCommand;
import com.comalatech.confluence.translator.domain.CloudTranslation;
import com.comalatech.confluence.translator.domain.WorkflowTranslator;
import com.comalatech.confluence.workflow.Workflow;
import com.comalatech.confluence.workflow.restv2.accessor.WorkflowMarkupManager;
import com.webcohesion.enunciate.metadata.rs.ResponseCode;
import com.webcohesion.enunciate.metadata.rs.StatusCodes;
import com.webcohesion.enunciate.metadata.rs.TypeHint;
import java.text.MessageFormat;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/translator/translate")
public class TranslateResource {
    private static final Logger log = LoggerFactory.getLogger(TranslateResource.class);
    private final WorkflowMarkupManager workflowMarkupManager;
    private final WorkflowTranslator workflowTranslator;

    public TranslateResource(WorkflowMarkupManager workflowMarkupManager, WorkflowTranslator workflowTranslator) {
        this.workflowMarkupManager = workflowMarkupManager;
        this.workflowTranslator = workflowTranslator;
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @WorkflowsAppRequired
    @StatusCodes(value={@ResponseCode(code=200, condition="Workflow translated successfully"), @ResponseCode(code=400, condition="Workflow is not valid"), @ResponseCode(code=500, condition="There was an error translating the workflow")})
    @TypeHint(value=TranslateResponse.class)
    public Response translate(TranslateRequest request) {
        try {
            Workflow workflow = this.workflowMarkupManager.parseFromWikiMarkup(request.markup());
            if (StringUtils.isNotBlank((CharSequence)workflow.getErrorMessage())) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)workflow.getErrorMessage()).build();
            }
            String jsonWorkflowString = this.workflowMarkupManager.convertToJson(workflow);
            CloudTranslation cloudTranslation = this.workflowTranslator.handle(ServerWorkflowCommand.builder().workflow(new JSONObject(jsonWorkflowString).toMap()).build());
            Optional<String> validationException = this.workflowMarkupManager.validateJsonMarkup(new JSONObject(cloudTranslation.getWorkflow()).toString(), "/workflows/cloud-schema-workflow.json");
            if (validationException.isPresent()) {
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.parseValidation(validationException.get())).build();
            }
            return Response.ok((Object)new TranslateResponse(CloudTranslationDto.builder().workflow(cloudTranslation.getWorkflow()).messages(cloudTranslation.getMessages()).build())).build();
        }
        catch (Exception e) {
            log.error(MessageFormat.format("There was an error translating the workflow: {0}", request), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)StringEscapeUtils.escapeHtml4((String)e.getMessage())).build();
        }
    }

    private String parseValidation(String validationException) {
        if (validationException.contains("#/states: expected minimum item count: 1, found: 0")) {
            return ConfluenceActionSupport.getTextStatic((String)"workflows.translator.cloud.validation.states.error");
        }
        return ConfluenceActionSupport.getTextStatic((String)"workflows.translator.cloud.validation.error");
    }

    @XmlAccessorType(value=XmlAccessType.PROPERTY)
    public static class CloudTranslationDto {
        private Map<String, Object> workflow;
        private Map<String, Set<Object>> messages;

        public static CloudTranslationDtoBuilder builder() {
            return new CloudTranslationDtoBuilder();
        }

        public Map<String, Object> getWorkflow() {
            return this.workflow;
        }

        public Map<String, Set<Object>> getMessages() {
            return this.messages;
        }

        public void setWorkflow(Map<String, Object> workflow) {
            this.workflow = workflow;
        }

        public void setMessages(Map<String, Set<Object>> messages) {
            this.messages = messages;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CloudTranslationDto)) {
                return false;
            }
            CloudTranslationDto other = (CloudTranslationDto)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Map<String, Object> this$workflow = this.getWorkflow();
            Map<String, Object> other$workflow = other.getWorkflow();
            if (this$workflow == null ? other$workflow != null : !((Object)this$workflow).equals(other$workflow)) {
                return false;
            }
            Map<String, Set<Object>> this$messages = this.getMessages();
            Map<String, Set<Object>> other$messages = other.getMessages();
            return !(this$messages == null ? other$messages != null : !((Object)this$messages).equals(other$messages));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CloudTranslationDto;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Map<String, Object> $workflow = this.getWorkflow();
            result = result * 59 + ($workflow == null ? 43 : ((Object)$workflow).hashCode());
            Map<String, Set<Object>> $messages = this.getMessages();
            result = result * 59 + ($messages == null ? 43 : ((Object)$messages).hashCode());
            return result;
        }

        public String toString() {
            return "TranslateResource.CloudTranslationDto(workflow=" + this.getWorkflow() + ", messages=" + this.getMessages() + ")";
        }

        public CloudTranslationDto() {
        }

        public CloudTranslationDto(Map<String, Object> workflow, Map<String, Set<Object>> messages) {
            this.workflow = workflow;
            this.messages = messages;
        }

        public static class CloudTranslationDtoBuilder {
            private Map<String, Object> workflow;
            private Map<String, Set<Object>> messages;

            CloudTranslationDtoBuilder() {
            }

            public CloudTranslationDtoBuilder workflow(Map<String, Object> workflow) {
                this.workflow = workflow;
                return this;
            }

            public CloudTranslationDtoBuilder messages(Map<String, Set<Object>> messages) {
                this.messages = messages;
                return this;
            }

            public CloudTranslationDto build() {
                return new CloudTranslationDto(this.workflow, this.messages);
            }

            public String toString() {
                return "TranslateResource.CloudTranslationDto.CloudTranslationDtoBuilder(workflow=" + this.workflow + ", messages=" + this.messages + ")";
            }
        }
    }

    @XmlAccessorType(value=XmlAccessType.PROPERTY)
    public static final class TranslateResponse {
        private CloudTranslationDto cloudTranslation;

        public static TranslateResponseBuilder builder() {
            return new TranslateResponseBuilder();
        }

        public CloudTranslationDto getCloudTranslation() {
            return this.cloudTranslation;
        }

        public void setCloudTranslation(CloudTranslationDto cloudTranslation) {
            this.cloudTranslation = cloudTranslation;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TranslateResponse)) {
                return false;
            }
            TranslateResponse other = (TranslateResponse)o;
            CloudTranslationDto this$cloudTranslation = this.getCloudTranslation();
            CloudTranslationDto other$cloudTranslation = other.getCloudTranslation();
            return !(this$cloudTranslation == null ? other$cloudTranslation != null : !((Object)this$cloudTranslation).equals(other$cloudTranslation));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            CloudTranslationDto $cloudTranslation = this.getCloudTranslation();
            result = result * 59 + ($cloudTranslation == null ? 43 : ((Object)$cloudTranslation).hashCode());
            return result;
        }

        public String toString() {
            return "TranslateResource.TranslateResponse(cloudTranslation=" + this.getCloudTranslation() + ")";
        }

        public TranslateResponse() {
        }

        public TranslateResponse(CloudTranslationDto cloudTranslation) {
            this.cloudTranslation = cloudTranslation;
        }

        public static class TranslateResponseBuilder {
            private CloudTranslationDto cloudTranslation;

            TranslateResponseBuilder() {
            }

            public TranslateResponseBuilder cloudTranslation(CloudTranslationDto cloudTranslation) {
                this.cloudTranslation = cloudTranslation;
                return this;
            }

            public TranslateResponse build() {
                return new TranslateResponse(this.cloudTranslation);
            }

            public String toString() {
                return "TranslateResource.TranslateResponse.TranslateResponseBuilder(cloudTranslation=" + this.cloudTranslation + ")";
            }
        }
    }

    @XmlAccessorType(value=XmlAccessType.PROPERTY)
    public static final class TranslateRequest {
        private String markup;

        public String markup() {
            return this.markup;
        }

        public static TranslateRequestBuilder builder() {
            return new TranslateRequestBuilder();
        }

        public String getMarkup() {
            return this.markup;
        }

        public void setMarkup(String markup) {
            this.markup = markup;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TranslateRequest)) {
                return false;
            }
            TranslateRequest other = (TranslateRequest)o;
            String this$markup = this.getMarkup();
            String other$markup = other.getMarkup();
            return !(this$markup == null ? other$markup != null : !this$markup.equals(other$markup));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $markup = this.getMarkup();
            result = result * 59 + ($markup == null ? 43 : $markup.hashCode());
            return result;
        }

        public String toString() {
            return "TranslateResource.TranslateRequest(markup=" + this.getMarkup() + ")";
        }

        public TranslateRequest() {
        }

        public TranslateRequest(String markup) {
            this.markup = markup;
        }

        public static class TranslateRequestBuilder {
            private String markup;

            TranslateRequestBuilder() {
            }

            public TranslateRequestBuilder markup(String markup) {
                this.markup = markup;
                return this;
            }

            public TranslateRequest build() {
                return new TranslateRequest(this.markup);
            }

            public String toString() {
                return "TranslateResource.TranslateRequest.TranslateRequestBuilder(markup=" + this.markup + ")";
            }
        }
    }
}

