/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.tasks.extractor;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.core.task.MultiQueueTaskManager;
import com.atlassian.core.task.Task;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.comalatech.confluence.dataextractor.model.QueueTasksContentPropertyItem;
import com.comalatech.confluence.states.model.PageState;
import com.comalatech.confluence.tasks.event.TaskAssignEvent;
import com.comalatech.confluence.tasks.event.TaskCompleteEvent;
import com.comalatech.confluence.tasks.event.TaskCreateEvent;
import com.comalatech.confluence.tasks.event.TaskDeletedEvent;
import com.comalatech.confluence.tasks.event.TasksClearedEvent;
import com.comalatech.confluence.tasks.event.blogpost.BlogPostTaskUpdatedEvent;
import com.comalatech.confluence.tasks.event.page.PageTaskUpdatedEvent;
import com.comalatech.confluence.util.WorkflowsListener;

public class TaskExtractorListener
extends WorkflowsListener {
    private final MultiQueueTaskManager multiQueueTaskManager;

    public TaskExtractorListener(EventPublisher eventPublisher, MultiQueueTaskManager multiQueueTaskManager) {
        super(eventPublisher);
        this.multiQueueTaskManager = multiQueueTaskManager;
    }

    @EventListener
    public void onTaskCreated(TaskCreateEvent event) {
        AbstractPage content = (AbstractPage)event.getContent();
        this.updateTasks(content);
    }

    @EventListener
    public void onTaskUpdated(PageTaskUpdatedEvent event) {
        AbstractPage content = (AbstractPage)event.getContent();
        this.updateTasks(content);
    }

    @EventListener
    public void onBlogTaskUpdated(BlogPostTaskUpdatedEvent event) {
        AbstractPage content = (AbstractPage)event.getContent();
        this.updateTasks(content);
    }

    @EventListener
    public void onTaskAssigned(TaskAssignEvent event) {
        AbstractPage content = (AbstractPage)event.getContent();
        this.updateTasks(content);
    }

    @EventListener
    public void onTasksCompleted(TaskCompleteEvent event) {
        AbstractPage content = (AbstractPage)event.getContent();
        this.updateTasks(content);
    }

    @EventListener
    public void onTasksCleared(TasksClearedEvent event) {
        AbstractPage content = (AbstractPage)event.getContent();
        this.updateTasks(content);
    }

    @EventListener
    public void onTaskDelete(TaskDeletedEvent event) {
        PageState state = event.getState();
        AbstractPage content = state.getPage();
        this.updateTasks(content);
    }

    private void updateTasks(AbstractPage content) {
        if (content != null) {
            QueueTasksContentPropertyItem queueContentPropertyItem = new QueueTasksContentPropertyItem(content.getId());
            this.multiQueueTaskManager.addTask("content_queue", (Task)queueContentPropertyItem);
        }
    }
}

