/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.states.dao;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.sal.api.features.DarkFeatureManager;
import com.comalatech.confluence.dataextractor.ComalaPropertiesSetManager;
import com.comalatech.confluence.states.dao.PageStateDao;
import com.comalatech.confluence.states.dao.sax.PageStateConverter;
import com.comalatech.confluence.states.model.PageState;
import com.comalatech.confluence.util.ReadWriteTransactionService;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.SAXParserFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaxPageStateDao
implements PageStateDao {
    private static final Logger log = LoggerFactory.getLogger(SaxPageStateDao.class);
    public static final String LATEST_STATE_KEY = "com.comalatech.states.latest";
    public static final String LATEST_FINAL_STATE_KEY = "com.comalatech.states.final";
    public static final String STATES_KEY = "com.comalatech.states";
    private final UserAccessor userAccessor;
    private final SAXParserFactory saxParserFactory;
    private final ReadWriteTransactionService transactionService;
    private final ComalaPropertiesSetManager contentPropertyManager;
    private final DarkFeatureManager darkFeatureManager;

    public SaxPageStateDao(UserAccessor userAccessor, ComalaPropertiesSetManager contentPropertyManager, ReadWriteTransactionService transactionService, DarkFeatureManager darkFeatureManager) {
        this.userAccessor = userAccessor;
        this.contentPropertyManager = contentPropertyManager;
        this.transactionService = transactionService;
        this.darkFeatureManager = darkFeatureManager;
        this.saxParserFactory = SAXParserFactory.newInstance();
        this.saxParserFactory.setValidating(false);
        this.saxParserFactory.setNamespaceAware(false);
    }

    @Override
    public void setPageStates(AbstractPage abstractPage, List<PageState> pageStates) {
        PageState latest = null;
        if (pageStates != null && pageStates.size() > 0) {
            latest = pageStates.get(pageStates.size() - 1);
        }
        this.contentPropertyManager.setTextProperty((ContentEntityObject)abstractPage, STATES_KEY, PageStateConverter.convertToXml(pageStates));
        if (latest != null) {
            this.setLatestPageState(abstractPage, latest);
            if ("final".equals(latest.getFinalStatus()) && !this.darkFeatureManager.isEnabledForAllUsers("comalatech.workflows.newactivity.listener.disabled").orElse(true).booleanValue()) {
                this.setLatestFinalPageState(abstractPage, latest);
            }
        }
    }

    @Override
    public void removePageStates(AbstractPage abstractPage) {
        this.contentPropertyManager.removeProperty((ContentEntityObject)abstractPage, LATEST_STATE_KEY);
        this.contentPropertyManager.removeProperty((ContentEntityObject)abstractPage, LATEST_FINAL_STATE_KEY);
        this.contentPropertyManager.removeProperty((ContentEntityObject)abstractPage, STATES_KEY);
    }

    @Override
    public void setLatestPageState(AbstractPage abstractPage, PageState pageState) {
        this.contentPropertyManager.setTextProperty((ContentEntityObject)abstractPage, LATEST_STATE_KEY, PageStateConverter.convertToXml(pageState));
    }

    @Override
    public PageState getLatestFinalPageState(AbstractPage abstractPage) {
        PageState latestFinal = null;
        String latestFinalXml = this.contentPropertyManager.getTextProperty((ContentEntityObject)abstractPage, LATEST_FINAL_STATE_KEY);
        if (TextUtils.stringSet((String)latestFinalXml) && (latestFinal = this.deserializePageState(latestFinalXml)) != null) {
            latestFinal.setPage(abstractPage);
        }
        return latestFinal;
    }

    @Override
    public void setLatestFinalPageState(AbstractPage abstractPage, PageState pageState) {
        this.contentPropertyManager.setTextProperty((ContentEntityObject)abstractPage, LATEST_FINAL_STATE_KEY, PageStateConverter.convertToXml(pageState));
    }

    @Override
    public PageState getLatestPageState(AbstractPage abstractPage) {
        PageState latest = null;
        String latestXml = this.contentPropertyManager.getTextProperty((ContentEntityObject)abstractPage, LATEST_STATE_KEY);
        if (TextUtils.stringSet((String)latestXml)) {
            latest = this.deserializePageState(latestXml);
        }
        if (latest == null) {
            List<PageState> allStates = this.getPageStates(abstractPage);
            if (allStates != null && allStates.size() > 0) {
                PageState finalLatest = latest = allStates.get(allStates.size() - 1);
                return this.transactionService.executeInReadWriteTransaction(() -> {
                    this.setLatestPageState(abstractPage, finalLatest);
                    return finalLatest;
                });
            }
            return null;
        }
        latest.setPage(abstractPage);
        return latest;
    }

    @Override
    public List<PageState> getPageStates(AbstractPage abstractPage) {
        List<PageState> pageStates;
        String statesXml = this.contentPropertyManager.getTextProperty((ContentEntityObject)abstractPage, STATES_KEY);
        ArrayList<PageState> list = new ArrayList<PageState>();
        if (TextUtils.stringSet((String)statesXml) && (pageStates = this.deserializePageStates(statesXml)) != null) {
            for (PageState pageState : pageStates) {
                pageState.setPage(abstractPage);
                list.add(pageState);
            }
        }
        return list;
    }

    private PageState deserializePageState(String xml) {
        PageStateConverter converter = new PageStateConverter(this.userAccessor);
        converter.extractFromXml(xml);
        return converter.getPageState();
    }

    private List<PageState> deserializePageStates(String xml) {
        PageStateConverter converter = new PageStateConverter(this.userAccessor);
        converter.extractFromXml(xml);
        List<PageState> pageStates = converter.getPageStates();
        return pageStates != null && !pageStates.isEmpty() ? pageStates : null;
    }
}

