/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.messaging;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;

public class Message {
    public static final String VALID_STYLES_ERRORMSG = "" + (Object)((Object)MacroParamStyle.INFO) + ", " + (Object)((Object)MacroParamStyle.HINT) + ", " + (Object)((Object)MacroParamStyle.ERROR) + ", " + (Object)((Object)MacroParamStyle.WARNING) + ", " + (Object)((Object)MacroParamStyle.SUCCESS);
    public static final String VALID_VIEW_MODES_ERRORMSG = "" + (Object)((Object)MessageView.DRAFT) + ", " + (Object)((Object)MessageView.PUBLISHED) + ", " + (Object)((Object)MessageView.BOTH);
    private long expiration;
    private String message;
    private String title;
    private String style;
    private String viewType;
    private boolean shown;
    private transient String renderedMessage;

    public Message() {
    }

    public Message(String title, String message, String style, long ttlInSeconds, String view) {
        this.expiration = ttlInSeconds < Long.MAX_VALUE ? (ttlInSeconds > 0L ? System.currentTimeMillis() + ttlInSeconds * 1000L : 0L) : ttlInSeconds;
        this.title = title;
        this.message = message;
        this.style = style;
        this.shown = false;
        this.viewType = StringUtils.isEmpty((String)view) ? MessageView.BOTH.name : view;
    }

    public boolean isShowOnce() {
        return this.expiration == 0L;
    }

    public boolean isExpired() {
        return System.currentTimeMillis() > this.expiration;
    }

    public long getExpirationTime() {
        return this.expiration;
    }

    public void setExpiration(long expiration) {
        this.expiration = expiration;
    }

    public String getRenderedMessage() {
        if (this.renderedMessage == null) {
            this.renderedMessage = this.message;
        }
        return this.renderedMessage;
    }

    public boolean isCaption() {
        return this.style.equals(MacroParamStyle.CAPTION.param);
    }

    public void setRenderedMessage(String renderedMessage) {
        this.renderedMessage = renderedMessage;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getStyle() {
        return this.style;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public boolean isShown() {
        return this.shown;
    }

    public void setShown(boolean shown) {
        this.shown = shown;
    }

    public boolean isViewInDraftOnly() {
        return this.viewType.equals(MessageView.DRAFT.name);
    }

    public boolean isViewInPublicOnly() {
        return this.viewType.equals(MessageView.PUBLISHED.name);
    }

    public boolean isViewEverywhere() {
        return this.viewType.equals(MessageView.BOTH.name);
    }

    public static boolean isValidStyle(String style) {
        for (MacroParamStyle paramStyle : MacroParamStyle.values()) {
            if (!paramStyle.param.equals(style)) continue;
            return true;
        }
        return false;
    }

    public static boolean isValidMessageView(String inputView) {
        for (MessageView viewType : MessageView.values()) {
            if (!viewType.name.equals(inputView)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public String getTitle() {
        return this.title;
    }

    public static enum MessageView {
        DRAFT("draft"),
        PUBLISHED("published"),
        BOTH("both");

        public String name;

        private MessageView(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum MacroParamStyle {
        GENERIC("generic"),
        ERROR("error"),
        HINT("hint"),
        WARNING("warning"),
        SUCCESS("success"),
        INFO("info"),
        TIP("tip"),
        NOTE("note"),
        CAPTION("caption");

        public String param;

        private MacroParamStyle(String param) {
            this.param = param;
        }

        public String toString() {
            return this.param;
        }
    }
}

