/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.documentActivity.ao.accesor;

import com.atlassian.confluence.spaces.SpaceManager;
import com.comalatech.confluence.documentActivity.ao.ActivityDeleteCriteria;
import com.comalatech.confluence.documentActivity.ao.ActivitySearchCriteria;
import com.comalatech.confluence.documentActivity.ao.ActivityUpdateCriteria;
import com.comalatech.confluence.documentActivity.ao.ApprovalActivitySearchCriteria;
import com.comalatech.confluence.documentActivity.ao.accesor.ActivityRecordAccessor;
import com.comalatech.confluence.documentActivity.ao.accesor.builder.ApprovalsFiltersProcessor;
import com.comalatech.confluence.documentActivity.ao.accesor.builder.FiltersProcessor;
import com.comalatech.confluence.documentActivity.ao.entity.ActivityDetailsRecordEntity;
import com.comalatech.confluence.documentActivity.ao.entity.ActivityRecordEntity;
import com.comalatech.confluence.documentActivity.ao.entity.BaseActivityRecord;
import com.comalatech.confluence.documentActivity.service.model.InternalDocumentActivityQuery;
import com.comalatech.confluence.util.ActiveObjectsAccessor;
import com.google.common.base.Functions;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.java.ao.DBParam;
import net.java.ao.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActivityRecordAccessorImpl
extends ActiveObjectsAccessor
implements ActivityRecordAccessor {
    private static final Logger log = LoggerFactory.getLogger(ActivityRecordAccessorImpl.class);
    private final FiltersProcessor filterProcessor;
    private final ApprovalsFiltersProcessor approvalsFiltersProcessor;

    public ActivityRecordAccessorImpl(SpaceManager spaceManager) {
        this.filterProcessor = new FiltersProcessor(spaceManager);
        this.approvalsFiltersProcessor = new ApprovalsFiltersProcessor();
    }

    @Override
    public ActivityRecordEntity create(BaseActivityRecord record) {
        ActivityRecordEntity entity = (ActivityRecordEntity)this.getAo().create(ActivityRecordEntity.class, new DBParam[]{new DBParam("ACTION_SUBTYPE", (Object)record.getActionSubtype()), new DBParam("ACTION_TYPE", (Object)record.getActionType()), new DBParam("ACTOR_ID", (Object)record.getActorId()), new DBParam("SPACE_ID", (Object)record.getSpaceId()), new DBParam("FINAL_VERSION", (Object)record.isFinalVersion()), new DBParam("MOMENT", (Object)record.getMoment()), new DBParam("PAGE_ID", (Object)record.getPageId()), new DBParam("PAGE_VERSION", (Object)record.getPageVersion()), new DBParam("STATE_ID", (Object)record.getStateId()), new DBParam("STATE_NAME", (Object)record.getStateName()), new DBParam("TARGET_ATTACHMENTS", (Object)record.getTargetAttachments()), new DBParam("APP_VERSION", (Object)record.getAppVersion()), new DBParam("ORIGIN", (Object)record.getOrigin())});
        entity.save();
        if (log.isDebugEnabled()) {
            log.debug("Activity record has been created: \n" + record);
        }
        return entity;
    }

    @Override
    public List<BaseActivityRecord> search(InternalDocumentActivityQuery criteria) {
        return (List)this.getAo().executeInTransaction(() -> {
            Query query = this.buildQuery(criteria);
            if (log.isDebugEnabled()) {
                log.debug(MessageFormat.format("Executing AO sql query with this where: {0} with this params: {1} with this join: {2}", query.getWhereClause(), query.getWhereParams(), query.getJoins()));
            }
            return query != null ? Arrays.asList((BaseActivityRecord[])this.getAo().find(ActivityRecordEntity.class, query)) : new ArrayList();
        });
    }

    @Override
    @Deprecated
    public List<BaseActivityRecord> search(ActivitySearchCriteria criteria) {
        return (List)this.getAo().executeInTransaction(() -> this._search(criteria));
    }

    private List<BaseActivityRecord> _search(ActivitySearchCriteria criteria) {
        Query query = this.buildQuery(criteria);
        return query != null ? Arrays.asList((BaseActivityRecord[])this.getAo().find(ActivityRecordEntity.class, query)) : new ArrayList<BaseActivityRecord>();
    }

    @Override
    public void delete(ActivityDeleteCriteria criteria) {
        this.getAo().deleteWithSQL(ActivityRecordEntity.class, this.buildDeleteQuery(criteria), new Object[0]);
    }

    private Query buildQuery(InternalDocumentActivityQuery criteria) {
        Query query = Query.select().limit(criteria.getLimit() + 5).order("MOMENT " + (Object)((Object)criteria.getOrder())).distinct();
        if (criteria.getOffset() > 0) {
            query.setOffset(criteria.getOffset());
        }
        if (this.filterProcessor.needsDetailQuery(criteria)) {
            query.alias(ActivityRecordEntity.class, "activity").alias(ActivityDetailsRecordEntity.class, "detail").join(ActivityDetailsRecordEntity.class, "detail.ACTIVITY_ID = activity.ID");
        }
        this.filterProcessor.addFiltersToQuery(query, criteria);
        return query;
    }

    private Query buildQuery(ActivitySearchCriteria searchCriteria) {
        ArrayList<Object> values = new ArrayList<Object>();
        String queryClause = "";
        if (searchCriteria.getContentId() != null) {
            queryClause = "PAGE_ID = ?";
            values.add(searchCriteria.getContentId());
        }
        if (searchCriteria.getStateId() != null) {
            if (!queryClause.isEmpty()) {
                queryClause = queryClause + " and ";
            }
            queryClause = queryClause + "STATE_ID= ? ";
            values.add(searchCriteria.getStateId());
        }
        if (searchCriteria.getStateName() != null) {
            if (!queryClause.isEmpty()) {
                queryClause = queryClause + " and ";
            }
            queryClause = queryClause + "STATE_NAME= ? ";
            values.add(searchCriteria.getStateName());
        }
        if (!queryClause.isEmpty()) {
            return Query.select().where(queryClause, values.toArray());
        }
        return null;
    }

    @Override
    public List<BaseActivityRecord> searchByApproval(ApprovalActivitySearchCriteria criteria) {
        Query query = this.buildQueryApprovals(criteria);
        return Objects.nonNull(query) ? Arrays.asList((BaseActivityRecord[])this.getAo().find(ActivityRecordEntity.class, query)) : Collections.emptyList();
    }

    private Query buildQueryApprovals(ApprovalActivitySearchCriteria searchCriteria) {
        Query subQuery = Query.select().alias(ActivityRecordEntity.class, "activity").alias(ActivityDetailsRecordEntity.class, "detail").join(ActivityDetailsRecordEntity.class, "detail.ACTIVITY_ID = activity.ID");
        this.approvalsFiltersProcessor.addFiltersToQuery(subQuery, searchCriteria);
        ActivityRecordEntity[] subQueryValue = (ActivityRecordEntity[])this.getAo().find(ActivityRecordEntity.class, subQuery);
        List activityIds = Arrays.stream(subQueryValue).map(BaseActivityRecord::getId).collect(Collectors.toList());
        if (activityIds.isEmpty()) {
            return null;
        }
        String placeholderCommaList = activityIds.stream().map(Functions.constant((Object)"?")).collect(Collectors.joining(","));
        return Query.select().alias(ActivityRecordEntity.class, "activity").where("ID IN (" + placeholderCommaList + ")", activityIds.toArray()).order("activity.MOMENT desc");
    }

    private String buildDeleteQuery(ActivityDeleteCriteria deleteCriteria) {
        String queryClause = "";
        if (deleteCriteria.getContentId() != null) {
            queryClause = "PAGE_ID = " + deleteCriteria.getContentId();
        }
        return queryClause;
    }

    @Override
    public List<BaseActivityRecord> update(ActivityUpdateCriteria criteria) {
        return (List)this.getAo().executeInTransaction(() -> {
            List<BaseActivityRecord> activityRecords = this._search(criteria.getSearch());
            return activityRecords.stream().map(record -> this.updateTargetSpaceId((BaseActivityRecord)record, criteria.getSpaceId())).collect(Collectors.toList());
        });
    }

    private ActivityRecordEntity updateTargetSpaceId(BaseActivityRecord record, Long spaceId) {
        if (spaceId != null && !spaceId.equals(record.getSpaceId())) {
            record.setSpaceId(spaceId);
        }
        return this.updateRecord(record);
    }

    private ActivityRecordEntity updateRecord(BaseActivityRecord record) {
        ActivityRecordEntity activityRecordEntity = (ActivityRecordEntity)this.getAo().get(ActivityRecordEntity.class, (Object)record.getId());
        if (!record.getSpaceId().equals(activityRecordEntity.getSpaceId())) {
            activityRecordEntity.setSpaceId(record.getSpaceId());
        }
        activityRecordEntity.save();
        if (log.isDebugEnabled()) {
            log.debug("Activity record has been updated: \n" + record);
        }
        return activityRecordEntity;
    }
}

