/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.rest.model;

import com.comalatech.confluence.states.model.StateSelection;
import com.comalatech.confluence.workflow.rest.model.Approval;
import com.comalatech.confluence.workflow.rest.model.Parameter;
import com.comalatech.workflow.model.PageWorkflowParameter;
import com.webcohesion.enunciate.metadata.DocumentationExample;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import org.codehaus.jackson.annotate.JsonProperty;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class State {
    @DocumentationExample(value="Draft", value2="Review")
    public String name;
    @DocumentationExample(value="Borrador", value2="Revision")
    public String nameTranslation;
    @DocumentationExample(value="State of pages under construction", value2="State of pages under review")
    public String description;
    public StateTransitions transitions;
    @DocumentationExample(value="false", value2="false")
    @XmlElement(name="final")
    @JsonProperty(value="final")
    public Boolean finalState;
    @DocumentationExample(value="true", value2="false")
    public Boolean taskable;
    @DocumentationExample(value="false", value2="true")
    public Boolean changeDueDate;
    @DocumentationExample(value="true", value2="false")
    public Boolean hideFromPath;
    @DocumentationExample(value="P2D", value2="2049-02-01 10:00")
    public String dueDate;
    @DocumentationExample(value="#FFAB00", value2="yellow")
    public String colour;
    public List<Approval> approvals;

    public State() {
    }

    public State(com.comalatech.confluence.states.model.State state) {
        this.name = state.getName();
        this.description = state.getDescription();
        this.transitions = new StateTransitions(state);
        if (state.isFinalState()) {
            this.finalState = true;
        }
        if (state.isTaskable()) {
            this.taskable = true;
        }
        if (state.isChangeDueDate()) {
            this.changeDueDate = state.isChangeDueDate();
        }
        if (state.isHideFromPath()) {
            this.hideFromPath = true;
        }
        this.dueDate = state.getDueDate();
        this.colour = state.getColour();
        if (state.getApprovals().size() > 0) {
            this.approvals = new ArrayList<Approval>();
            for (com.comalatech.confluence.workflow.model.Approval approval : state.getApprovals()) {
                this.approvals.add(new Approval(approval));
            }
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class StateTransition {
        public String state;
        public List<Parameter> parameters;

        public static StateTransition of(String stateName, Map<String, List<PageWorkflowParameter>> parameters) {
            return StateTransition.of(stateName, parameters != null ? parameters.get(stateName) : null);
        }

        public static StateTransition of(String stateName, List<PageWorkflowParameter> workflowParameters) {
            if (stateName != null) {
                StateTransition transition = new StateTransition();
                transition.state = stateName;
                transition.parameters = workflowParameters != null ? workflowParameters.stream().map(p -> Parameter.of(p)).collect(Collectors.toList()) : null;
                return transition;
            }
            return null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StateTransition that = (StateTransition)o;
            return Objects.equals(this.state, that.state);
        }

        public int hashCode() {
            return Objects.hash(this.state);
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class StateTransitions {
        public StateTransition approved;
        public StateTransition rejected;
        public StateTransition updated;
        public StateTransition expired;
        public StateTransition submit;
        public StateTransition completed;
        public Set<StateTransition> select;

        public StateTransitions() {
        }

        public StateTransitions(com.comalatech.confluence.states.model.State state) {
            this(state, null);
        }

        public StateTransitions(com.comalatech.confluence.states.model.State state, Map<String, List<PageWorkflowParameter>> parameters) {
            this.approved = StateTransition.of(state.getApprovedStateName(), parameters);
            this.rejected = StateTransition.of(state.getRejectedStateName(), parameters);
            this.updated = StateTransition.of(state.getUpdatedStateName(), parameters);
            this.expired = StateTransition.of(state.getExpiredStateName(), parameters);
            if (state.getSubmitState() != null) {
                this.submit = StateTransition.of(state.getSubmitState().getName(), parameters);
            }
            this.completed = StateTransition.of(state.getCompletedStateName(), parameters);
            this.select = new HashSet<StateTransition>();
            if (state.getStateSelections() != null && state.getStateSelections().size() > 0) {
                for (StateSelection stateSelection : state.getStateSelections()) {
                    for (com.comalatech.confluence.states.model.State option : stateSelection.getAllowedStates()) {
                        StateTransition transition = StateTransition.of(option.getName(), parameters);
                        if (transition == null) continue;
                        this.select.add(transition);
                    }
                }
            }
        }
    }
}

