/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.macros;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.SubRenderer;
import com.atlassian.renderer.v2.macro.BaseMacro;
import com.atlassian.renderer.v2.macro.MacroException;
import com.comalatech.confluence.workflow.Workflow;
import com.comalatech.confluence.workflow.WorkflowException;
import com.comalatech.confluence.workflow.macros.DescriptionMacro;
import com.comalatech.confluence.workflow.macros.InstructionsMacro;
import com.comalatech.confluence.workflow.macros.WorkflowParameters;
import com.comalatech.confluence.workflowcontainer.WorkflowContainer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowMacro
extends BaseMacro {
    private static final Logger log = LoggerFactory.getLogger(WorkflowMacro.class);
    public static final String WORKFLOW_ELEMENTS = "workflow";
    public static final String LOAD_CONTEXT_ELEMENTS = "loadContextElements";
    private static final String WORKFLOW_CONTAINER_KEY = "com.comalatech.confluence.workflow.dao";
    private SubRenderer subRenderer;
    private SpaceManager spaceManager;

    public boolean hasBody() {
        return true;
    }

    public RenderMode getBodyRenderMode() {
        return RenderMode.NO_RENDER;
    }

    public String execute(Map parameters, String body, RenderContext renderContext) throws MacroException {
        Workflow workflow;
        WorkflowParameters workflowParameters;
        AbstractPage page = (AbstractPage)((PageContext)renderContext).getEntity();
        boolean latestVersion = page.isLatestVersion();
        if (!latestVersion && log.isInfoEnabled()) {
            log.info("Rendering a historic version of workflow" + page + ". It won't be saved");
        }
        if (!(workflowParameters = new WorkflowParameters(parameters, renderContext, this.spaceManager)).isAdhoc() && page instanceof BlogPost) {
            throw new MacroException("Comala Workflows cannot be defined on a blog post");
        }
        RenderContext workflowContext = this.createDummyRenderContext(page);
        List workflowElements = new ArrayList();
        if (renderContext.getParam((Object)LOAD_CONTEXT_ELEMENTS) != null && ((Boolean)renderContext.getParam((Object)LOAD_CONTEXT_ELEMENTS)).booleanValue() && renderContext.getParam((Object)WORKFLOW_ELEMENTS) != null && renderContext.getParam((Object)WORKFLOW_ELEMENTS) instanceof List) {
            workflowElements = (List)renderContext.getParam((Object)WORKFLOW_ELEMENTS);
        }
        workflowContext.addParam((Object)WORKFLOW_ELEMENTS, workflowElements);
        String workflowBody = this.subRenderer.render(body, workflowContext, RenderMode.ALL);
        if (workflowElements.isEmpty()) {
            throw new MacroException("there is not any workflow element (i.e. {trigger}, {state} or {approval})");
        }
        Map properties = this.getWorkflowProperties(workflowContext);
        try {
            workflow = new Workflow(workflowParameters, workflowElements, properties);
            workflow.setDescription(DescriptionMacro.getDescription(workflowContext));
            workflow.setCreateInstructions(InstructionsMacro.getInstructions(workflowContext));
        }
        catch (WorkflowException e) {
            throw new MacroException(e.getMessage());
        }
        if (latestVersion) {
            try {
                WorkflowContainer workflowContainer = this.getWorkflowContainer(renderContext);
                if (workflowContainer == null) {
                    return "<div class='error'>" + ConfluenceActionSupport.getTextStatic((String)"comalatech.awp.container.legacy.error") + "</div>";
                }
                workflowContainer.saveWorkflow(workflow);
            }
            catch (WorkflowException e) {
                throw new MacroException(e.getMessage());
            }
        }
        return workflowBody.trim();
    }

    private WorkflowContainer getWorkflowContainer(RenderContext renderContext) {
        WorkflowContainer workflowContainer = (WorkflowContainer)renderContext.getParam((Object)WORKFLOW_CONTAINER_KEY);
        if (workflowContainer != null) {
            return workflowContainer;
        }
        return null;
    }

    public static void setWorkflowContainer(RenderContext renderContext, WorkflowContainer workflowContainer) {
        renderContext.addParam((Object)WORKFLOW_CONTAINER_KEY, (Object)workflowContainer);
    }

    private RenderContext createDummyRenderContext(AbstractPage page) throws MacroException {
        AbstractPage dummy;
        try {
            dummy = (AbstractPage)page.clone();
        }
        catch (Exception e) {
            throw new MacroException("Error cloning page");
        }
        dummy.setBodyAsString("");
        return dummy.toPageContext();
    }

    public Map getWorkflowProperties(RenderContext renderContext) {
        HashMap properties = new HashMap();
        for (Object key : renderContext.getParams().keySet()) {
            if (!key.toString().startsWith("com.comalatech.workflow.properties")) continue;
            properties.put(key, renderContext.getParam(key));
        }
        return properties;
    }

    public void setSubRenderer(SubRenderer subRenderer) {
        this.subRenderer = subRenderer;
    }

    public void setSpaceManager(SpaceManager spaceManager) {
        this.spaceManager = spaceManager;
    }
}

