/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.audit.listener;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.event.events.content.page.PageEvent;
import com.atlassian.confluence.event.events.content.page.PageRemoveEvent;
import com.atlassian.confluence.event.events.content.page.PageTrashedEvent;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.comalatech.confluence.adhoc.notification.events.WorkflowNotificationConfigurationUpdatedEventImpl;
import com.comalatech.confluence.util.WorkflowsListener;
import com.comalatech.confluence.workflow.audit.AuditRecordImpl;
import com.comalatech.confluence.workflow.audit.events.SpaceAuditHistoryClearedImpl;
import com.comalatech.confluence.workflow.events.AbstractPageWorkflowEvent;
import com.comalatech.confluence.workflow.events.AbstractPageWorkflowHistoryClearedEvent;
import com.comalatech.confluence.workflow.events.admin.SpaceWorkflowConfigurationUpdatedEventImpl;
import com.comalatech.confluence.workflow.events.admin.SpaceWorkflowParameterEventImpl;
import com.comalatech.confluence.workflow.events.admin.SpaceWorkflowParameterUpdatedEventImpl;
import com.comalatech.confluence.workflow.events.admin.SpaceWorkflowPropertiesPopulatedEventImpl;
import com.comalatech.confluence.workflow.events.admin.SpaceWorkflowStatesInitializationEventImpl;
import com.comalatech.workflow.WorkflowService;
import com.comalatech.workflow.audit.AuditRecord;
import com.comalatech.workflow.audit.WorkflowAuditService;
import com.comalatech.workflow.event.WorkflowSpaceEvent;
import com.comalatech.workflow.event.admin.GlobalAuditHistoryClearedEvent;
import com.comalatech.workflow.event.admin.SpaceWorkflowHistoryClearedEvent;
import com.comalatech.workflow.event.admin.SpaceWorkflowNotificationConfigurationUpdatedEvent;
import com.comalatech.workflow.event.admin.WorkflowAdvancedConfigurationUpdatedEvent;
import com.comalatech.workflow.event.admin.WorkflowChangeEvent;
import com.comalatech.workflow.event.admin.WorkflowConfigurationUpdatedEvent;
import com.comalatech.workflow.model.Workflow;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class AuditEventListener
extends WorkflowsListener {
    protected final WorkflowAuditService workflowAuditService;
    protected final PageManager pageManager;
    protected final WorkflowService workflowService;

    public AuditEventListener(EventPublisher eventPublisher, WorkflowAuditService workflowAuditService, PageManager pageManager, WorkflowService workflowService) {
        super(eventPublisher);
        this.workflowAuditService = workflowAuditService;
        this.pageManager = pageManager;
        this.workflowService = workflowService;
    }

    @EventListener
    public void onConfigUpdated(WorkflowConfigurationUpdatedEvent event) {
        this.workflowAuditService.addRecord(this.createGlobalChangeAuditRecord(event, event.getOldConfig(), event.getConfig()));
    }

    @EventListener
    public void onSpaceConfigUpdated(SpaceWorkflowConfigurationUpdatedEventImpl event) {
        this.workflowAuditService.addRecord(this.createSpaceChangeAuditRecord(event, event.getSpace().getKey(), event.getOldSpaceConfig(), event.getSpaceConfig()));
    }

    @EventListener
    public void onSpaceWorkflowStatesInitializationEvent(SpaceWorkflowStatesInitializationEventImpl event) {
        this.workflowAuditService.addRecord(this.createSpaceChangeAuditRecord(event, event.getSpace().getKey(), null, event.getParamsMap()));
    }

    @EventListener
    public void onSpaceParameterEvent(SpaceWorkflowParameterEventImpl event) {
        if (event instanceof SpaceWorkflowParameterUpdatedEventImpl) {
            this.workflowAuditService.addRecord(this.createSpaceChangeAuditRecord(event, event.getSpace().getKey(), ((SpaceWorkflowParameterUpdatedEventImpl)event).getOldParameterConfig(), event.getParameterConfig()));
        } else {
            this.workflowAuditService.addRecord(this.createSpaceChangeAuditRecord(event, event.getSpace().getKey(), null, event.getParameterConfig()));
        }
    }

    @EventListener
    public void onGlobalAuditHistoryClearedEvent(GlobalAuditHistoryClearedEvent event) {
        this.workflowAuditService.addRecord(this.createGlobalAuditRecord(event, ""));
    }

    @EventListener
    public void onSpaceAuditHistoryClearedEvent(SpaceAuditHistoryClearedImpl event) {
        this.workflowAuditService.addRecord(this.createSpaceAuditRecord(event, ""));
    }

    @EventListener
    public void onNotificationConfigEvent(WorkflowNotificationConfigurationUpdatedEventImpl event) {
        if (event instanceof SpaceWorkflowNotificationConfigurationUpdatedEvent) {
            this.workflowAuditService.addRecord(this.createSpaceChangeAuditRecord((SpaceWorkflowNotificationConfigurationUpdatedEvent)((Object)event), ((SpaceWorkflowNotificationConfigurationUpdatedEvent)((Object)event)).getSpace().getKey(), null, event.getConfig()));
        } else {
            this.workflowAuditService.addRecord(this.createGlobalChangeAuditRecord(event, null, event.getConfig()));
        }
    }

    @EventListener
    public void onWorkflowChangedEvent(WorkflowChangeEvent event) {
        AuditRecord record = event instanceof WorkflowSpaceEvent ? this.createSpaceAuditRecord((WorkflowSpaceEvent)((Object)event), event.getWorkflow().getName()) : (event instanceof AbstractPageWorkflowEvent ? this.createPageAuditRecord((AbstractPageWorkflowEvent)((Object)event), event.getWorkflow().getName()) : this.createGlobalAuditRecord(event, event.getWorkflow().getName()));
        this.workflowAuditService.addRecord(record);
    }

    @EventListener
    public void onSpaceWorkflowHistoryClearedEvent(SpaceWorkflowHistoryClearedEvent event) {
        this.workflowAuditService.addRecord(this.createSpaceAuditRecord(event, ""));
    }

    @EventListener
    public void onPageWorkflowHistoryClearedEvent(AbstractPageWorkflowHistoryClearedEvent event) {
        this.workflowAuditService.addRecord(this.createPageAuditRecord(event, ""));
    }

    @EventListener
    public void onSpaceWorkflowPropertiesPopulatedEvent(SpaceWorkflowPropertiesPopulatedEventImpl event) {
        this.workflowAuditService.addRecord(this.createSpaceAuditRecord(event, ""));
    }

    @EventListener
    public void onPageTrashedDeprecated(PageTrashedEvent event) {
        if (this.pageHasWorkflow((AbstractPage)event.getPage())) {
            this.workflowAuditService.addRecord(this.createConfluencePageEventRecord((PageEvent)event, event.getPage().getTitle() + " v" + event.getPage().getVersion()));
        }
    }

    @EventListener
    public void onPageRemoved(PageRemoveEvent event) {
        if (this.pageHasWorkflow((AbstractPage)event.getPage())) {
            this.workflowAuditService.addRecord(this.createConfluencePageEventRecord((PageEvent)event, event.getPage().getTitle() + " v" + event.getPage().getVersion()));
        }
    }

    @EventListener
    public void onWorkflowAdvancedConfigUpdated(WorkflowAdvancedConfigurationUpdatedEvent event) {
        this.workflowAuditService.addRecord(this.createGlobalChangeAuditRecord(event, event.getOldConfig(), event.getConfig()));
    }

    protected boolean pageHasWorkflow(AbstractPage page) {
        List<Workflow> workflows = this.workflowService.getActiveWorkflows((ContentEntityObject)page);
        return workflows != null && workflows.size() > 0;
    }

    protected AuditRecord createGlobalChangeAuditRecord(Object event, Map<String, String> oldValues, Map<String, String> newValues) {
        return new AuditRecordImpl(new Date(), "", AuthenticatedUserThreadLocal.get().getKey().getStringValue(), event.getClass().getSimpleName(), oldValues, newValues);
    }

    protected AuditRecord createSpaceChangeAuditRecord(Object event, String spaceKey, Map<String, String> oldValues, Map<String, String> newValues) {
        return new AuditRecordImpl(new Date(), spaceKey, AuthenticatedUserThreadLocal.get().getKey().getStringValue(), event.getClass().getSimpleName(), oldValues, newValues);
    }

    protected AuditRecord createGlobalAuditRecord(Object event, String description) {
        return new AuditRecordImpl(new Date(), "", AuthenticatedUserThreadLocal.get().getKey().getStringValue(), event.getClass().getSimpleName(), description);
    }

    protected AuditRecord createConfluencePageEventRecord(PageEvent event, String description) {
        return new AuditRecordImpl(new Date(), event.getPage().getSpaceKey(), AuthenticatedUserThreadLocal.get().getKey().getStringValue(), event.getClass().getSimpleName(), description);
    }

    protected AuditRecord createSpaceAuditRecord(WorkflowSpaceEvent event, String description) {
        return new AuditRecordImpl(new Date(), event.getSpace().getKey(), AuthenticatedUserThreadLocal.get().getKey().getStringValue(), event.getClass().getSimpleName(), description);
    }

    protected AuditRecord createPageAuditRecord(AbstractPageWorkflowEvent event, String description) {
        return new AuditRecordImpl(new Date(), event.getContent().getSpaceKey(), event.getContent().getTitle(), AuthenticatedUserThreadLocal.get().getKey().getStringValue(), event.getClass().getSimpleName(), description);
    }
}

