/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.tasks.event.page;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.comalatech.confluence.states.model.Assignment;
import com.comalatech.confluence.states.model.PageState;
import com.comalatech.confluence.tasks.event.TaskAssignEvent;
import com.comalatech.confluence.tasks.event.page.PageTaskUpdatedEvent;
import com.comalatech.confluence.tasks.model.Assignable;
import com.comalatech.confluence.tasks.model.PageTask;
import com.comalatech.confluence.timers.TimerUtils;

public class PageTaskUnassignEvent
extends PageTaskUpdatedEvent
implements TaskAssignEvent {
    private Assignment assignment;

    public PageTaskUnassignEvent(Object src, Page page, PageState state, PageTask task, Assignment assignment) {
        super(src, page, state, task, null, assignment.getPerformer());
        this.assignment = assignment;
    }

    @Override
    public Assignable getAssignable() {
        return this.getTask();
    }

    @Override
    public Assignment getAssignment() {
        return this.assignment;
    }

    @Override
    public AbstractPage getAbstractPage() {
        return this.getPage();
    }

    public String toString() {
        if (this.getContent() == null || this.getTask() == null || this.assignment == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer(TimerUtils.logDate(this.assignment.getDate())).append(" ").append(this.getContent());
        sb.append(" got task '").append(((PageTask)this.getTask()).getName()).append("' ").append(this.assignment);
        return sb.toString();
    }

    @Override
    public boolean isAtTaskCreation() {
        return false;
    }
}

