/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.tasks.event.blogpost;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.BlogPost;
import com.comalatech.confluence.states.model.PageState;
import com.comalatech.confluence.states.model.TaskCompletion;
import com.comalatech.confluence.tasks.event.TaskCompleteEvent;
import com.comalatech.confluence.tasks.event.blogpost.BlogPostTaskEvent;
import com.comalatech.confluence.tasks.model.PageTask;
import com.comalatech.confluence.timers.TimerUtils;

public class BlogPostTaskCompleteEvent
extends BlogPostTaskEvent
implements TaskCompleteEvent {
    private TaskCompletion completion;

    public BlogPostTaskCompleteEvent(Object src, BlogPost blogPost, PageState state, PageTask task, TaskCompletion completion) {
        super(src, blogPost, state, task);
        this.completion = completion;
    }

    @Override
    public AbstractPage getAbstractPage() {
        return this.getBlogPost();
    }

    @Override
    public TaskCompletion getCompletion() {
        return this.completion;
    }

    public String toString() {
        if (this.getContent() == null || this.getTask() == null || this.completion == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer(TimerUtils.logDate(this.completion.getDate())).append(" ").append(this.getContent()).append(" ");
        sb.append("got task ").append(((PageTask)this.getTask()).getName()).append(" ").append(this.completion.toString());
        return sb.toString();
    }
}

