/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.states.model;

import com.atlassian.confluence.event.events.ConfluenceEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostUpdateEvent;
import com.atlassian.confluence.event.events.content.page.PageUpdateEvent;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageUpdateTrigger;
import com.comalatech.confluence.states.StateException;
import com.comalatech.confluence.states.event.DummyStateSelectEvent;
import com.comalatech.confluence.states.event.StateExpireEvent;
import com.comalatech.confluence.states.model.DefaultStateSelection;
import com.comalatech.confluence.states.model.PageState;
import com.comalatech.confluence.states.model.State;
import com.comalatech.confluence.states.model.StateSelection;
import com.comalatech.confluence.states.model.Transition;
import com.comalatech.confluence.tasks.event.blogpost.AllBlogPostTasksCompleteEvent;
import com.comalatech.confluence.tasks.event.page.AllPageTasksCompleteEvent;
import com.comalatech.confluence.workflow.events.AbstractPageAllApproveEvent;
import com.comalatech.confluence.workflow.events.AbstractPageAllRejectEvent;
import com.comalatech.confluence.workflow.model.Approval;
import com.comalatech.confluence.workflow.model.PageInInvalidStateCondition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class StatesContainer {
    public static final StatesContainer EMPTY = new StatesContainer();
    private Map<String, State> states = new HashMap<String, State>();
    private List<State> statesList = new ArrayList<State>();
    private State initialState;
    private State finalState;
    private State versionsCompletedState;

    public void addState(State currentState, State state) throws StateException {
        int ix;
        if (this.states.get(state.getName()) != null) {
            throw new StateException("Duplicate state name " + state.getName());
        }
        if (this.states.size() == 0) {
            this.initialState = state;
        }
        if ((ix = this.statesList.indexOf(currentState)) < 0 || ix == this.statesList.size() - 1) {
            this.statesList.add(state);
        } else {
            this.statesList.add(ix + 1, state);
        }
        this.states.put(state.getName(), state);
    }

    public void setFinalState(State finalState) {
        this.finalState = finalState;
    }

    public State renameState(String oldName, String newName) {
        State state = this.states.remove(oldName);
        this.states.put(newName, state);
        for (State state1 : this.statesList) {
            state1.renameReferredStateName(state.getName(), newName);
        }
        state.setName(newName);
        return state;
    }

    public void moveState(String name, boolean up) {
        int l = this.statesList.size();
        if (l <= 1) {
            return;
        }
        int i = 0;
        ListIterator<State> iterator = this.statesList.listIterator();
        while (iterator.hasNext()) {
            State state = iterator.next();
            if (state.getName().equals(name)) {
                if (up) {
                    if (i <= 0) break;
                    iterator.remove();
                    iterator.previous();
                    iterator.add(state);
                    break;
                }
                if (i >= l - 1) break;
                iterator.remove();
                iterator.next();
                iterator.add(state);
                break;
            }
            ++i;
        }
        this.setInitialState();
    }

    private void setInitialState() {
        this.initialState = this.statesList.size() > 0 ? this.statesList.get(0) : null;
    }

    public void removeState(String name) {
        State removedState = this.getState(name);
        if (removedState == null) {
            return;
        }
        ListIterator<State> iterator = this.statesList.listIterator();
        while (iterator.hasNext()) {
            State state = iterator.next();
            if (state.equals(removedState)) {
                iterator.remove();
                this.states.remove(state.getName());
            } else {
                state.removeStateReference(removedState);
            }
            if (removedState.equals(this.finalState)) {
                this.finalState = null;
            }
            if (!removedState.equals(this.versionsCompletedState)) continue;
            this.versionsCompletedState = null;
        }
        this.setInitialState();
    }

    public void initialize(boolean adhoc) throws StateException {
        HashSet<State> allStates = new HashSet<State>();
        this.finalState = null;
        allStates.addAll(this.states.values());
        for (State state : allStates) {
            boolean eventTransition = false;
            if (state.getApprovedStateName() != null) {
                State approvedState = this.getReferredState(state.getApprovedStateName());
                state.addTransition(new Transition(new AbstractPageAllApproveEvent(this), null, state, approvedState, true));
                state.addSucceedingState(approvedState);
                approvedState.addPreceedingState(state);
            }
            if (state.getRejectedStateName() != null) {
                State rejectedState = this.getReferredState(state.getRejectedStateName());
                state.addTransition(new Transition(new AbstractPageAllRejectEvent(this), null, state, rejectedState, true));
                state.addSucceedingState(rejectedState);
                rejectedState.addPreceedingState(state);
            }
            if (state.getUpdatedStateName() != null) {
                eventTransition = true;
                State updatedState = this.getReferredState(state.getUpdatedStateName());
                state.addTransition(new Transition((ConfluenceEvent)new PageUpdateEvent((Object)this, new Page(), null, false, PageUpdateTrigger.UNKNOWN), null, state, updatedState, true));
                state.addTransition(new Transition((ConfluenceEvent)new BlogPostUpdateEvent((Object)this, new BlogPost(), null), null, state, updatedState, true));
            }
            if (state.getExpiredStateName() != null) {
                eventTransition = true;
                State expiredState = this.getReferredState(state.getExpiredStateName());
                state.addTransition(new Transition((ConfluenceEvent)new StateExpireEvent(this, null, new PageState(state.getName()), null), null, state, expiredState, true));
            }
            if (state.getCompletedStateName() != null) {
                eventTransition = true;
                State completedState = this.getReferredState(state.getCompletedStateName());
                state.addTransition(new Transition((ConfluenceEvent)new AllPageTasksCompleteEvent(this, new Page(), new PageState(state.getName())), null, state, completedState, true));
                state.addTransition(new Transition((ConfluenceEvent)new AllBlogPostTasksCompleteEvent(this, new BlogPost(), new PageState(state.getName())), null, state, completedState, true));
            }
            if (state.isFinalState()) {
                if (this.finalState != null) {
                    throw new StateException("State " + state.getName() + " cannot be final because " + this.finalState + " is already marked as final");
                }
                this.finalState = state;
            }
            if (state.isVersionsCompleted()) {
                if (this.versionsCompletedState != null) {
                    throw new StateException("State " + state.getName() + " cannot be marked as versionscompleted because " + this.versionsCompletedState + " is already marked as versionscompleted");
                }
                this.versionsCompletedState = state;
            }
            if (!state.isEndState() && !state.isHideSelection() && (state.getStateSelections().size() == 0 && eventTransition || state.getTransitions().size() == 0 && state.getStateSelections().size() == 0)) {
                DefaultStateSelection selection = new DefaultStateSelection(this.getAllStatesButThisOne(state));
                ArrayList<StateSelection> selectionsList = new ArrayList<StateSelection>();
                selectionsList.add(selection);
                state.setStateSelections(selectionsList);
            }
            if (state.equals(this.initialState)) {
                state.addTransition(new Transition(new DummyStateSelectEvent(this), Collections.singletonList(new PageInInvalidStateCondition()), null, null, true));
            }
            state.setAdhocSelections(adhoc);
            List<StateSelection> transitions = state.getStateSelections();
            for (StateSelection transition : transitions) {
                transition.validateAllowedStateNames(this);
            }
        }
    }

    private State getReferredState(String stateName) throws StateException {
        State approvedState = this.getState(stateName);
        if (approvedState == null) {
            throw new StateException("State " + stateName + " does not exist");
        }
        return approvedState;
    }

    private List<State> getAllStatesButThisOne(State exludedState) {
        ArrayList<State> states = new ArrayList<State>(this.statesList.size() - 1);
        for (State state : this.statesList) {
            if (state.getName().equals(exludedState.getName())) continue;
            states.add(state);
        }
        return states;
    }

    public State getState(String stateName) {
        return this.states.get(stateName);
    }

    public State getState(PageState pageState) {
        if (pageState == null) {
            return this.initialState;
        }
        return this.getState(pageState.getState());
    }

    public State getInitialState() {
        return this.initialState;
    }

    public State getFinalState() {
        return this.finalState;
    }

    public State getVersionsCompletedState() {
        return this.versionsCompletedState;
    }

    public List<State> getStates() {
        return this.statesList;
    }

    public List<State> getVisibleStates() {
        ArrayList<State> visible = new ArrayList<State>(this.statesList.size());
        for (State state : this.statesList) {
            if (state.isHideFromPath()) continue;
            visible.add(state);
        }
        return visible;
    }

    public List<Approval> getAllApprovals() {
        ArrayList<Approval> approvals = new ArrayList<Approval>();
        HashSet<String> names = new HashSet<String>();
        for (State state : this.statesList) {
            for (Approval approval : state.getApprovals()) {
                if (names.contains(approval.getName())) continue;
                approvals.add(approval);
                names.add(approval.getName());
            }
        }
        return approvals;
    }

    public int size() {
        return this.states.size();
    }

    public boolean isRequiresFinalApproval() {
        return this.finalState != null && this.finalState.isFinalState();
    }

    public boolean hasVersionsCompletedState() {
        return this.versionsCompletedState != null && this.versionsCompletedState.isVersionsCompleted();
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("initialState", (Object)this.initialState).append("finalState", (Object)this.finalState).append("states", this.states.values()).toString();
    }
}

