/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.documentActivity.upgrade.manager;

import com.atlassian.confluence.api.model.longtasks.LongTaskId;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.util.longrunning.LongRunningTaskId;
import com.atlassian.confluence.util.longrunning.LongRunningTaskManager;
import com.atlassian.core.task.longrunning.LongRunningTask;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.user.User;
import com.comalatech.confluence.documentActivity.service.DocumentActivityService;
import com.comalatech.confluence.documentActivity.upgrade.entity.domain.ContentUpgrade;
import com.comalatech.confluence.documentActivity.upgrade.entity.domain.Status;
import com.comalatech.confluence.documentActivity.upgrade.entity.domain.UpgradeTask;
import com.comalatech.confluence.documentActivity.upgrade.manager.SpaceUpgradeManager;
import com.comalatech.confluence.documentActivity.upgrade.service.DocumentActivityUpgradeService;
import com.comalatech.confluence.documentActivity.upgrade.tasks.AbstractPageUpgradeTask;
import com.comalatech.confluence.documentActivity.upgrade.tasks.SpaceUpgradeTask;
import com.comalatech.confluence.documentActivity.usecases.contracts.GenerateDocumentActivity;
import com.comalatech.confluence.documentActivity.usecases.contracts.ValidateDocumentActivity;
import com.comalatech.confluence.states.StateAccessor;
import com.comalatech.confluence.util.ReadWriteTransactionService;
import com.comalatech.confluence.workflow.ApprovalAccessor;
import com.comalatech.confluence.workflow.accesor.WorkflowsActivityRecordAccessor;
import com.comalatech.confluence.workflow.accesor.entity.PageActivityRecord;
import com.comalatech.confluence.workflow.supportconsole.infrastructure.contract.SupportPresenter;
import com.comalatech.confluence.workflow.user.WorkflowAuthenticatedUserThreadLocal;
import com.comalatech.workflow.StateService;
import java.util.List;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpaceUpgradeManagerImpl
implements SpaceUpgradeManager {
    private static final Logger log = LoggerFactory.getLogger(SpaceUpgradeManagerImpl.class);
    private final DocumentActivityUpgradeService documentActivityUpgradeService;
    private final LongRunningTaskManager longRunningTaskManager;
    private final WorkflowsActivityRecordAccessor workflowsActivityAccessor;
    private final ValidateDocumentActivity validateDocumentActivity;
    private final GenerateDocumentActivity generateDocumentActivity;
    private final PageManager pageManager;
    private final ReadWriteTransactionService readWriteTransactionService;
    private final SupportPresenter templateFileLayoutHelper;
    private final DocumentActivityService documentActivityService;
    private final EventPublisher eventPublisher;
    private final StateAccessor stateAccessor;
    private final ApprovalAccessor approvalAccessor;
    private final StateService stateService;

    public SpaceUpgradeManagerImpl(DocumentActivityUpgradeService documentActivityUpgradeService, LongRunningTaskManager longRunningTaskManager, WorkflowsActivityRecordAccessor workflowsActivityAccessor, ValidateDocumentActivity validateDocumentActivity, GenerateDocumentActivity generateDocumentActivity, PageManager pageManager, ReadWriteTransactionService readWriteTransactionService, SupportPresenter templateFileLayoutHelper, DocumentActivityService documentActivityService, EventPublisher eventPublisher, StateAccessor stateAccessor, ApprovalAccessor approvalAccessor, StateService stateService) {
        this.documentActivityUpgradeService = documentActivityUpgradeService;
        this.longRunningTaskManager = longRunningTaskManager;
        this.workflowsActivityAccessor = workflowsActivityAccessor;
        this.validateDocumentActivity = validateDocumentActivity;
        this.generateDocumentActivity = generateDocumentActivity;
        this.pageManager = pageManager;
        this.readWriteTransactionService = readWriteTransactionService;
        this.templateFileLayoutHelper = templateFileLayoutHelper;
        this.documentActivityService = documentActivityService;
        this.eventPublisher = eventPublisher;
        this.stateAccessor = stateAccessor;
        this.approvalAccessor = approvalAccessor;
        this.stateService = stateService;
    }

    @Override
    public UpgradeTask launchSpaceUpgradeTask(Space space, boolean isUpgrade) {
        UpgradeTask upgradeTask = this.documentActivityUpgradeService.getSpaceUpgrade(space);
        if (upgradeTask != null) {
            if (Status.getInProgressStatus(isUpgrade).equals((Object)upgradeTask.getStatus())) {
                String taskId = upgradeTask.getLongRunningTaskId();
                LongRunningTaskId longRunningTaskId = LongRunningTaskId.from((LongTaskId)LongTaskId.deserialise((String)taskId));
                LongRunningTask longRunningTask = this.longRunningTaskManager.getLongRunningTask((User)WorkflowAuthenticatedUserThreadLocal.get(), longRunningTaskId);
                if (longRunningTask == null) {
                    upgradeTask.setStatus(Status.getFailStatus(isUpgrade));
                    this.documentActivityUpgradeService.saveSpaceUpgrade(space, upgradeTask);
                    log.error("There is no long running task in progress for the space upgrade/pre-check:" + space.getKey());
                }
                return upgradeTask;
            }
            if (Status.UPGRADE_SUCCESS.equals((Object)upgradeTask.getStatus()) || Status.FAIL.equals((Object)upgradeTask.getStatus()) && isUpgrade) {
                return upgradeTask;
            }
        }
        List<PageActivityRecord> pageActivityRecords = this.workflowsActivityAccessor.findAllWorkflowActivityBySpace(space.getId());
        upgradeTask = this.initUpgradeTaskProperties(isUpgrade);
        SpaceUpgradeTask preCheckTask = new SpaceUpgradeTask(space, upgradeTask, pageActivityRecords, this.documentActivityUpgradeService, this.validateDocumentActivity, this.generateDocumentActivity, this.pageManager, this.readWriteTransactionService, this.templateFileLayoutHelper, this.documentActivityService, this.stateService, this.stateAccessor, this.approvalAccessor, this.eventPublisher, isUpgrade);
        LongRunningTaskId longRunningTaskId = this.longRunningTaskManager.startLongRunningTask((User)WorkflowAuthenticatedUserThreadLocal.get(), (LongRunningTask)preCheckTask);
        if (longRunningTaskId != null) {
            upgradeTask.setLongRunningTaskId(longRunningTaskId.asLongTaskId().serialise());
            this.documentActivityUpgradeService.saveSpaceUpgrade(space, upgradeTask);
        } else {
            log.debug("Space upgrade task did not start, no long running task id was identified for the space upgrade/pre-check:" + space.getKey());
        }
        return upgradeTask;
    }

    @Override
    public ContentUpgrade launchContentUpgradeTask(AbstractPage content, boolean isUpgrade) {
        AbstractPageUpgradeTask abstractPageUpgradeTask = new AbstractPageUpgradeTask(content, this.validateDocumentActivity, this.generateDocumentActivity, this.readWriteTransactionService, this.documentActivityService, this.documentActivityUpgradeService, this.templateFileLayoutHelper, this.stateService, this.stateAccessor, this.approvalAccessor, isUpgrade);
        return abstractPageUpgradeTask.run();
    }

    @Override
    public void cancelSpaceUpgradeTask(Space space, boolean upgrade) {
        this.documentActivityUpgradeService.saveSpaceUpgrade(space, this.stopUpgradeTaskProperties(upgrade));
    }

    private UpgradeTask initUpgradeTaskProperties(boolean upgrade) {
        return new UpgradeTask(Status.getInProgressStatus(upgrade), DateTime.now().getMillis(), null, null, 0, null, null, null);
    }

    private UpgradeTask stopUpgradeTaskProperties(boolean upgrade) {
        return new UpgradeTask(Status.getCancelStatus(upgrade), null, null, null, null, null, null, null);
    }
}

