/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.cloud.migration.tasks;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.util.longrunning.ConfluenceAbstractLongRunningTask;
import com.comalatech.confluence.cloud.migration.entity.AttachActivityTaskRecord;
import com.comalatech.confluence.cloud.migration.entity.AttachActivityTaskStatus;
import com.comalatech.confluence.cloud.migration.service.DefaultCloudMigrationContentService;
import com.comalatech.confluence.util.ReadWriteTransactionService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttachActivityTask
extends ConfluenceAbstractLongRunningTask {
    private static final Logger log = LoggerFactory.getLogger(AttachActivityTask.class);
    private final Space space;
    private final AttachActivityTaskRecord attachActivityTaskRecord;
    private final DefaultCloudMigrationContentService defaultCloudMigrationContentService;
    private final ReadWriteTransactionService readWriteTransactionService;
    public static final String NAME = ConfluenceActionSupport.getTextStatic((String)"awp.space.attachActivity.task.name");

    public AttachActivityTask(Space space, AttachActivityTaskRecord attachActivityTaskRecord, DefaultCloudMigrationContentService defaultCloudMigrationContentService, ReadWriteTransactionService readWriteTransactionService) {
        this.space = space;
        this.attachActivityTaskRecord = attachActivityTaskRecord;
        this.defaultCloudMigrationContentService = defaultCloudMigrationContentService;
        this.readWriteTransactionService = readWriteTransactionService;
    }

    protected void runInternal() {
        ArrayList<Long> pageIds = new ArrayList<Long>();
        try {
            this.readWriteTransactionService.executeInReadWriteTransaction(() -> {
                pageIds.addAll(this.defaultCloudMigrationContentService.getPagesWithWorkflow(this.space.getId()));
                if (log.isDebugEnabled()) {
                    log.debug("Starting long running task to attach activity csv to pages in space: {}", (Object)this.space.getKey());
                }
                this.attachActivityTaskRecord.setStartedTimestamp(new Date().getTime());
                if (!pageIds.isEmpty()) {
                    this.attachActivityTaskRecord.setStatus(AttachActivityTaskStatus.IN_PROGRESS);
                    this.defaultCloudMigrationContentService.setStatus(this.space.getKey(), this.attachActivityTaskRecord);
                    if (log.isDebugEnabled()) {
                        log.debug("Long running task set to IN PROGRESS for space: {}", (Object)this.space.getKey());
                    }
                    AtomicLong pagesProcessed = new AtomicLong(0L);
                    this.progress.setCurrentCount(0);
                    this.progress.setTotalObjects(pageIds.size());
                    this.generateFiles(pageIds, pagesProcessed);
                    this.saveActivityTaskStatus(AttachActivityTaskStatus.COMPLETED, new Date().getTime());
                    this.progress.setCompletedSuccessfully(true);
                    if (log.isDebugEnabled()) {
                        log.debug("Long running task set to COMPLETED for space: {}", (Object)this.space.getKey());
                    }
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug("No pages to process, setting long running task to COMPLETED for space: {}", (Object)this.space.getKey());
                    }
                    this.saveActivityTaskStatus(AttachActivityTaskStatus.COMPLETED, new Date().getTime());
                    this.progress.setCompletedSuccessfully(true);
                }
                return null;
            });
        }
        catch (Exception e) {
            this.saveActivityTaskStatus(AttachActivityTaskStatus.FAIL, new Date().getTime());
            this.progress.setCompletedSuccessfully(false);
            log.error("Error processing pages to attach activity as csv", (Throwable)e);
        }
        finally {
            this.finishProcess(pageIds);
        }
    }

    private void finishProcess(List<Long> pageIds) {
        this.progress.setPercentage(100);
        this.progress.setCurrentCount(pageIds.size());
    }

    private void saveActivityTaskStatus(AttachActivityTaskStatus attachActivityTaskStatus, long time) {
        this.attachActivityTaskRecord.setEndedTimestamp(time);
        this.attachActivityTaskRecord.setStatus(attachActivityTaskStatus);
        this.defaultCloudMigrationContentService.setStatus(this.space.getKey(), this.attachActivityTaskRecord);
    }

    private void generateFiles(List<Long> pageIds, AtomicLong pagesProcessed) {
        pageIds.forEach(pageId -> {
            try {
                if (log.isDebugEnabled()) {
                    log.debug("Attaching activity to page: {}", pageId);
                }
                this.progress.setStatus(ConfluenceActionSupport.getTextStatic((String)"awp.space.attachActivity.progress.status", (Object[])new Object[]{String.valueOf(pageId)}));
                this.defaultCloudMigrationContentService.attachCsvToPage((long)pageId);
            }
            catch (Exception e) {
                log.error("Error attaching the csv to the page: {}", pageId);
                throw e;
            }
            pagesProcessed.addAndGet(1L);
            this.progress.setPercentage(pagesProcessed.intValue(), pageIds.size());
        });
    }

    public String getName() {
        return NAME;
    }
}

