/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoc.action.condition;

import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.comalatech.confluence.adhoc.AdhocWorkflowManager;
import com.comalatech.confluence.adhoc.action.condition.AbstractPageWorkflowCondition;
import com.comalatech.confluence.onboard.OnboardingManager;
import com.comalatech.confluence.workflow.WorkflowConfigurationManager;
import com.comalatech.confluence.workflow.permissions.WorkflowPermissionManager;
import com.comalatech.confluence.workflow.rules.validation.VerificationRule;
import com.comalatech.confluence.workflowcontainer.WorkflowContainerManager;
import java.util.Map;

public class HasSeenOnboardingInTheLastSevenDays
extends AbstractPageWorkflowCondition {
    private VerificationRule<String> isInSevenDaysPeriod;
    private OnboardingManager onboardingManager;

    public HasSeenOnboardingInTheLastSevenDays(WorkflowContainerManager workflowContainerManager, AdhocWorkflowManager adhocWorkflowManager, WorkflowConfigurationManager workflowConfigurationManager, WorkflowPermissionManager workflowPermissionManager, VerificationRule<String> isInSevenDaysPeriod, OnboardingManager onboardingManager) {
        super(workflowContainerManager, adhocWorkflowManager, workflowConfigurationManager, workflowPermissionManager);
        this.isInSevenDaysPeriod = isInSevenDaysPeriod;
        this.onboardingManager = onboardingManager;
    }

    public boolean shouldDisplay(Map<String, Object> context) {
        boolean onboardEnabled = this.workflowConfigurationManager.isOnboardEnabled();
        if (onboardEnabled) {
            ConfluenceUser user = AuthenticatedUserThreadLocal.get();
            String seenDate = this.onboardingManager.getSeenDate(user);
            return this.isInSevenDaysPeriod.validate(seenDate);
        }
        return false;
    }
}

