/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.model;

import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.user.GroupManager;
import com.comalatech.confluence.documentActivity.upgrade.service.DocumentActivityUpgradeService;
import com.comalatech.confluence.license.WorkflowsFeatureManager;
import com.comalatech.confluence.util.PluginContainerManager;
import com.comalatech.confluence.workflow.ApprovalManager;
import com.comalatech.confluence.workflow.InternalWorkflowParameterManager;
import com.comalatech.confluence.workflow.UsersListResolver;
import com.comalatech.confluence.workflow.ValueStore;
import com.comalatech.confluence.workflow.WorkflowException;
import com.comalatech.confluence.workflowcontainer.model.SerializableMacro;
import java.io.Serializable;

public abstract class Condition
implements Serializable {
    protected boolean not;
    protected boolean allowInApprovalsOrLite;

    public Condition(boolean not) {
        this.not = not;
        this.allowInApprovalsOrLite = true;
    }

    public abstract void addMacroParameters(SerializableMacro var1);

    protected abstract boolean evaluateBinary(ValueStore var1) throws WorkflowException;

    public boolean evaluate(ValueStore valueStore) throws WorkflowException {
        boolean flag = this.evaluateBinary(valueStore);
        return this.not ? !flag : flag;
    }

    public static String[] makeValues(String valueList) {
        String[] values = valueList.split(",");
        for (int i = 0; i < values.length; ++i) {
            values[i] = values[i].trim();
        }
        return values;
    }

    public abstract String toString(ValueStore var1);

    protected GroupManager getGroupManager() {
        return PluginContainerManager.getComponent("groupManager", GroupManager.class);
    }

    protected UsersListResolver getUsersListResolver() {
        return PluginContainerManager.getComponent("usersListResolver", UsersListResolver.class);
    }

    protected ApprovalManager getApprovalManager() {
        return PluginContainerManager.getComponent("approvalManager", ApprovalManager.class);
    }

    protected DocumentActivityUpgradeService getDocumentActivityUpgradeService() {
        return PluginContainerManager.getComponent("documentActivityUpgradeService", DocumentActivityUpgradeService.class);
    }

    protected static InternalWorkflowParameterManager getWorkflowParameterManager() {
        return PluginContainerManager.getComponent("workflowParameterManager", InternalWorkflowParameterManager.class);
    }

    protected static WorkflowsFeatureManager getWorkflowsFeatureManager() {
        return PluginContainerManager.getComponent("workflowsFeatureManager", WorkflowsFeatureManager.class);
    }

    protected ConfluenceUser getUser() {
        return AuthenticatedUserThreadLocal.get();
    }

    public boolean isNot() {
        return this.not;
    }

    public boolean isApplicableToProduct() {
        return this.allowInApprovalsOrLite || Condition.getWorkflowsFeatureManager().isWorkflowsApp();
    }
}

