/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.macros.include.imported;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.DefaultConversionContext;
import com.atlassian.confluence.content.render.xhtml.DefaultXmlEventReaderFactory;
import com.atlassian.confluence.content.render.xhtml.Renderer;
import com.atlassian.confluence.content.render.xhtml.XmlEventReaderFactory;
import com.atlassian.confluence.content.render.xhtml.XmlOutputFactoryFactoryBean;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.service.NotAuthorizedException;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.renderer.ContentIncludeStack;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.confluence.util.HtmlUtil;
import com.atlassian.confluence.util.i18n.I18NBean;
import com.atlassian.confluence.util.i18n.I18NBeanFactory;
import com.atlassian.confluence.xhtml.api.Link;
import com.atlassian.confluence.xml.HTMLParagraphStripper;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.RenderUtils;
import com.atlassian.renderer.v2.macro.BaseMacro;
import com.atlassian.renderer.v2.macro.MacroException;
import com.comalatech.confluence.workflow.macros.include.imported.IncludeMacroUtils;
import com.comalatech.confluence.workflow.macros.include.imported.PageProviderAdvancedMacros;
import com.opensymphony.util.TextUtils;
import java.util.Map;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageIncludeMacro
extends BaseMacro
implements Macro {
    private static final Logger log = LoggerFactory.getLogger(PageIncludeMacro.class);
    protected PageProviderAdvancedMacros pageProvider;
    protected Renderer viewRenderer;
    protected I18NBeanFactory i18NBeanFactory;
    protected final String RENDER_ERROR_PREFIX = "confluence.macros.advanced.include.unable-to-render";
    protected final String NOT_FOUND_ERROR = "confluence.macros.advanced.include.error.content.not.found";
    protected final HTMLParagraphStripper htmlParagraphStripper;

    public PageIncludeMacro() {
        XMLOutputFactory xmlOutputFactory;
        try {
            xmlOutputFactory = new XmlOutputFactoryFactoryBean(true).getObject();
        }
        catch (Exception e) {
            throw new RuntimeException("Error occurred trying to construct a XML output factory", e);
        }
        this.htmlParagraphStripper = new HTMLParagraphStripper(xmlOutputFactory, (XmlEventReaderFactory)new DefaultXmlEventReaderFactory());
    }

    public RenderMode getBodyRenderMode() {
        return RenderMode.NO_RENDER;
    }

    public boolean hasBody() {
        return false;
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.NONE;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.BLOCK;
    }

    public String execute(Map<String, String> parameters, String body, ConversionContext conversionContext) throws MacroExecutionException {
        I18NBean i18NBean = this.i18NBeanFactory.getI18NBean();
        try {
            Link linkObj = IncludeMacroUtils.getLink(conversionContext);
            if (linkObj == null) {
                return this.execute(parameters, body, (RenderContext)conversionContext.getPageContext());
            }
            ContentEntityObject page = this.pageProvider.resolve(linkObj, conversionContext);
            return this.getIncludedContent(page, i18NBean, conversionContext);
        }
        catch (NotAuthorizedException e) {
            return RenderUtils.blockError((String)i18NBean.getText("confluence.macros.advanced.include.unable-to-render"), (String)i18NBean.getText("confluence.macros.advanced.include.error.content.not.found"));
        }
        catch (IllegalArgumentException e) {
            return RenderUtils.blockError((String)i18NBean.getText("confluence.macros.advanced.include.unable-to-render"), (String)i18NBean.getText("confluence.macros.advanced.include.error.content.not.found"));
        }
        catch (MacroException e) {
            throw new MacroExecutionException((Throwable)e);
        }
    }

    public String execute(Map parameters, String body, RenderContext renderContext) throws MacroException {
        I18NBean i18NBean = this.i18NBeanFactory.getI18NBean();
        if (!(renderContext instanceof PageContext)) {
            return RenderUtils.blockError((String)i18NBean.getText("confluence.macros.advanced.include.unable-to-render"), (String)i18NBean.getText("confluence.macros.advanced.include.error.can-only-be-used-in-confluence"));
        }
        this.validate(parameters);
        String location = this.getLocation(parameters);
        if (!TextUtils.stringSet((String)location)) {
            throw new MacroException(i18NBean.getText("confluence.macros.advanced.include.error.no.location"));
        }
        DefaultConversionContext conversionContext = new DefaultConversionContext(renderContext);
        return this.getIncludedContent(this.resolvePage(parameters, location, (ConversionContext)conversionContext), i18NBean, (ConversionContext)conversionContext);
    }

    protected ContentEntityObject resolvePage(Map parameters, String location, ConversionContext conversionContext) {
        return this.pageProvider.resolve(location, conversionContext);
    }

    protected String getIncludedContent(ContentEntityObject page, I18NBean i18NBean, ConversionContext conversionContext) {
        try {
            if (page == null) {
                return RenderUtils.blockError((String)i18NBean.getText("confluence.macros.advanced.include.unable-to-render"), (String)i18NBean.getText("confluence.macros.advanced.include.error.content.not.found"));
            }
            return this.fetchPageContent(page, conversionContext);
        }
        catch (NotAuthorizedException e) {
            return RenderUtils.blockError((String)i18NBean.getText("confluence.macros.advanced.include.unable-to-render"), (String)i18NBean.getText("confluence.macros.advanced.include.error.content.not.found"));
        }
        catch (IllegalArgumentException e) {
            return RenderUtils.blockError((String)i18NBean.getText("confluence.macros.advanced.include.unable-to-render"), (String)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String fetchPageContent(ContentEntityObject page, ConversionContext conversionContext) {
        I18NBean i18NBean = this.i18NBeanFactory.getI18NBean();
        if (ContentIncludeStack.contains((ContentEntityObject)page)) {
            return RenderUtils.blockError((String)i18NBean.getText("confluence.macros.advanced.include.unable-to-render"), (String)i18NBean.getText("confluence.macros.advanced.include.error.already.included", (Object[])new String[]{HtmlUtil.htmlEncode((String)page.getTitle())}));
        }
        ContentIncludeStack.push((ContentEntityObject)page);
        try {
            String strippedBody = page.getBodyAsString();
            try {
                strippedBody = this.htmlParagraphStripper.stripFirstParagraph(page.getBodyAsString());
            }
            catch (XMLStreamException e) {
                log.warn("Could not strip first paragraph, using unstripped body", (Throwable)e);
            }
            DefaultConversionContext context = new DefaultConversionContext((RenderContext)new PageContext(page, conversionContext.getPageContext()));
            String string = this.viewRenderer.render(strippedBody, (ConversionContext)context);
            return string;
        }
        finally {
            ContentIncludeStack.pop();
        }
    }

    protected String getLocation(Map parameters) {
        String spaceKey = TextUtils.noNull((String)((String)parameters.get("spaceKey"))).trim();
        String pageTitle = GeneralUtil.unescapeEntities((String)TextUtils.noNull((String)((String)parameters.get("pageTitle"))).trim());
        String location = GeneralUtil.unescapeEntities((String)TextUtils.noNull((String)((String)parameters.get("0"))).trim());
        if (StringUtils.isBlank((String)pageTitle)) {
            return location;
        }
        return this.toPageLink(spaceKey, pageTitle);
    }

    protected void validate(Map parameters) throws MacroException {
        I18NBean i18NBean = this.i18NBeanFactory.getI18NBean();
        String pageTitle = (String)parameters.get("pageTitle");
        String location = (String)parameters.get("0");
        if (StringUtils.isBlank((String)location) && StringUtils.isBlank((String)pageTitle)) {
            throw new MacroException(i18NBean.getText("confluence.macros.advanced.include.error.no.page-title"));
        }
    }

    protected String toPageLink(String space, String pageTitle) {
        return StringUtils.isBlank((String)space) ? pageTitle : space + ":" + pageTitle;
    }

    public void setViewRenderer(Renderer viewRenderer) {
        this.viewRenderer = viewRenderer;
    }

    public void setPageProvider(PageProviderAdvancedMacros pageProvider) {
        this.pageProvider = pageProvider;
    }

    public void setUserI18NBeanFactory(I18NBeanFactory i18NBeanFactory) {
        this.i18NBeanFactory = i18NBeanFactory;
    }
}

