/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.audit;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.sal.api.user.UserKey;
import com.comalatech.confluence.workflow.audit.model.WorkflowAffectedObject;
import com.comalatech.confluence.workflow.audit.model.WorkflowAuditRecord;
import com.comalatech.confluence.workflow.audit.model.WorkflowChangedValue;
import com.comalatech.workflow.audit.AuditRecord;
import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditLogRecordConverter {
    private static final Logger log = LoggerFactory.getLogger(AuditLogRecordConverter.class);

    public static WorkflowAuditRecord convertToWorkflowAuditRecord(AuditRecord auditRecord, UserAccessor userAccessor) {
        WorkflowAffectedObject affectedObject;
        String objectType;
        List<WorkflowChangedValue> changedValues;
        ConfluenceUser user = userAccessor.getUserByKey(new UserKey(auditRecord.getUserId()));
        String summary = ConfluenceActionSupport.getTextStatic((String)("awp.auditlog.event." + auditRecord.getEventType()));
        DateTime date = new DateTime((Object)auditRecord.getDate(), DateTimeZone.getDefault());
        WorkflowAuditRecord record = new WorkflowAuditRecord(date, user, summary);
        if (log.isDebugEnabled()) {
            log.debug("summary: " + summary + "  date: " + date + "  eventType: " + auditRecord.getEventType() + "  value: " + auditRecord.getValue());
        }
        if (!(changedValues = AuditLogRecordConverter.getChangedValues(auditRecord)).isEmpty()) {
            record.setChangedValues(changedValues);
        }
        if (StringUtils.isNotBlank((CharSequence)auditRecord.getSpaceKey())) {
            if (StringUtils.isNotBlank((CharSequence)auditRecord.getContentTitle())) {
                objectType = ConfluenceActionSupport.getTextStatic((String)"audit.logging.affected.object.page");
                affectedObject = new WorkflowAffectedObject(auditRecord.getSpaceKey() + ": " + auditRecord.getContentTitle(), objectType);
            } else {
                objectType = ConfluenceActionSupport.getTextStatic((String)"audit.logging.affected.object.space");
                affectedObject = new WorkflowAffectedObject(auditRecord.getSpaceKey(), objectType);
            }
            record.setAffectedObject(affectedObject);
        }
        if (record.getAssociatedObjects() == null && StringUtils.isNotBlank((CharSequence)auditRecord.getValue()) && (objectType = AuditLogRecordConverter.getAssociatedObjectType(auditRecord)) != null) {
            affectedObject = new WorkflowAffectedObject(AuditLogRecordConverter.ensureValueSize(auditRecord.getValue()), objectType);
            record.setAssociatedObjects(new HashSet<WorkflowAffectedObject>(Collections.singletonList(affectedObject)));
        }
        if (auditRecord.getEventType().contains("SpaceWorkflowParameter") && auditRecord.getNewValues() != null) {
            objectType = ConfluenceActionSupport.getTextStatic((String)"audit.logging.affected.object.workflow.parameter");
            affectedObject = new WorkflowAffectedObject(auditRecord.getNewValues().get("name"), objectType);
            record.setAssociatedObjects(new HashSet<WorkflowAffectedObject>(Collections.singletonList(affectedObject)));
        }
        return record;
    }

    private static String ensureValueSize(String value) {
        return value.length() < 256 ? value : value.substring(0, 252) + "...";
    }

    private static String getAssociatedObjectType(AuditRecord auditRecord) {
        String objectType = null;
        if (auditRecord.getEventType().equals("PageTrashedEvent") || auditRecord.getEventType().equals("PageRemoveEvent")) {
            objectType = ConfluenceActionSupport.getTextStatic((String)"audit.logging.affected.object.page");
        } else if (auditRecord.getEventType().contains("SpaceWorkflowParameter")) {
            objectType = ConfluenceActionSupport.getTextStatic((String)"audit.logging.affected.object.workflow.parameter");
        } else if (!(auditRecord.getEventType().contains("SpaceWorkflowStatesInitialization") || auditRecord.getEventType().contains("WorkflowConfigurationUpdated") || auditRecord.getEventType().contains("WorkflowNotificationConfigurationUpdated"))) {
            objectType = ConfluenceActionSupport.getTextStatic((String)"audit.logging.affected.object.workflow.template");
        }
        return objectType;
    }

    private static List<WorkflowChangedValue> getChangedValues(AuditRecord auditRecord) {
        Map<Object, Object> oldValues;
        MapDifference difference;
        ArrayList<WorkflowChangedValue> changedValues = new ArrayList<WorkflowChangedValue>();
        if (auditRecord != null && auditRecord.getNewValues() != null && (difference = Maps.difference(oldValues = auditRecord.getOldValues() == null ? new HashMap() : auditRecord.getOldValues(), auditRecord.getNewValues())) != null) {
            Map entriesDiffering = difference.entriesDiffering();
            for (Map.Entry entry : entriesDiffering.entrySet()) {
                String key = (String)entry.getKey();
                MapDifference.ValueDifference value = (MapDifference.ValueDifference)entry.getValue();
                if (value.leftValue() == null && value.rightValue() == null) continue;
                WorkflowChangedValue changedValue = new WorkflowChangedValue(key, AuditLogRecordConverter.ensureValueSize((String)value.leftValue()), AuditLogRecordConverter.ensureValueSize((String)value.rightValue()));
                changedValues.add(changedValue);
            }
            Map entriesOnlyOnRight = difference.entriesOnlyOnRight();
            for (Map.Entry entry : entriesOnlyOnRight.entrySet()) {
                if (entry.getValue() == null) continue;
                WorkflowChangedValue changedValue = new WorkflowChangedValue((String)entry.getKey(), null, AuditLogRecordConverter.ensureValueSize((String)entry.getValue()));
                changedValues.add(changedValue);
            }
        }
        return changedValues;
    }
}

