/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.pdfexport.k15t.scrollpdfexporter;

import com.comalatech.confluence.pdfexport.k15t.scrollpdfexporter.PdfExportServiceAccessor;
import com.comalatech.confluence.pdfexport.k15t.scrollpdfexporter.PdfExportServiceFactory;
import com.comalatech.confluence.pdfexport.k15t.scrollpdfexporter.PdfExportServiceHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class DefaultPdfExportServiceAccessor
implements PdfExportServiceAccessor {
    private static final Logger log = LoggerFactory.getLogger(DefaultPdfExportServiceAccessor.class);
    private final ApplicationContext applicationContext;
    private PdfExportServiceHolder pdfExportServiceHolder;

    public DefaultPdfExportServiceAccessor(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    private void initPdfExportServiceHolder() {
        try {
            Class<?> pdfExportServiceClass = this.getPdfExportServiceClass();
            if (pdfExportServiceClass != null) {
                this.pdfExportServiceHolder = ((PdfExportServiceFactory)this.applicationContext.getAutowireCapableBeanFactory().createBean(pdfExportServiceClass, 3, false)).get();
            }
        }
        catch (Exception e) {
            log.error("Could not create PdfExportServiceHolder", (Throwable)e);
        }
    }

    private Class<?> getPdfExportServiceClass() {
        try {
            this.getClass().getClassLoader().loadClass("com.k15t.scroll.exporter.api.pdf.PdfExportService");
            return this.getClass().getClassLoader().loadClass("com.comalatech.confluence.pdfexport.k15t.scrollpdfexporter.PdfExportServiceFactory");
        }
        catch (Exception e) {
            log.info("The necessary supplier class is unavailable.");
            return null;
        }
    }

    @Override
    public PdfExportServiceHolder getPdfExportServiceHolder() {
        if (this.pdfExportServiceHolder == null) {
            this.initPdfExportServiceHolder();
        }
        return this.pdfExportServiceHolder;
    }
}

