/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.metadata.communardo;

import com.comalatech.confluence.license.WorkflowsFeatureManager;
import com.comalatech.confluence.metadata.communardo.MetadataManagerAccessor;
import com.comalatech.confluence.metadata.communardo.MetadataManagerFactory;
import com.comalatech.confluence.metadata.communardo.MetadataManagerHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class MetadataManagerAccessorImpl
implements MetadataManagerAccessor {
    private static final Logger log = LoggerFactory.getLogger(MetadataManagerAccessorImpl.class);
    private final ApplicationContext applicationContext;
    private MetadataManagerHolder metadataManagerHolder;
    private WorkflowsFeatureManager workflowsFeatureManager;

    public MetadataManagerAccessorImpl(ApplicationContext applicationContext, WorkflowsFeatureManager workflowsFeatureManager) {
        this.applicationContext = applicationContext;
        this.workflowsFeatureManager = workflowsFeatureManager;
    }

    private void initMetadataManager() {
        try {
            Class<?> metadataManagerClass = this.getMetadataManagerClass();
            if (metadataManagerClass != null) {
                this.metadataManagerHolder = ((MetadataManagerFactory)this.applicationContext.getAutowireCapableBeanFactory().createBean(metadataManagerClass, 3, false)).get();
            }
        }
        catch (Exception e) {
            log.error("Could not create MetadataManagerHolder", (Throwable)e);
        }
    }

    private Class<?> getMetadataManagerClass() {
        try {
            this.getClass().getClassLoader().loadClass("com.communardo.confluence.metadata.service.MetadataManager");
            return this.getClass().getClassLoader().loadClass("com.comalatech.confluence.metadata.communardo.MetadataManagerFactory");
        }
        catch (Exception e) {
            log.info("The necessary supplier class is unavailable.");
            return null;
        }
    }

    @Override
    public synchronized MetadataManagerHolder getMetadataManager() {
        if (!this.workflowsFeatureManager.isWorkflowsApp()) {
            return null;
        }
        if (this.metadataManagerHolder == null) {
            this.initMetadataManager();
        }
        return this.metadataManagerHolder;
    }
}

