/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.documentActivity.mapper.state;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.event.events.ConfluenceEvent;
import com.atlassian.confluence.pages.AbstractPage;
import com.comalatech.confluence.documentActivity.domain.entities.Action;
import com.comalatech.confluence.documentActivity.domain.entities.ActionDetailType;
import com.comalatech.confluence.documentActivity.domain.entities.ActionDetails;
import com.comalatech.confluence.documentActivity.domain.entities.ActionType;
import com.comalatech.confluence.documentActivity.domain.entities.Activity;
import com.comalatech.confluence.documentActivity.domain.entities.Actor;
import com.comalatech.confluence.documentActivity.mapper.EventActivityMapper;
import com.comalatech.confluence.documentActivity.mapper.GenericEventActivityMapper;
import com.comalatech.confluence.documentActivity.util.ActorUtils;
import com.comalatech.confluence.states.event.blogpost.BlogPostStateClosedEvent;
import com.comalatech.confluence.states.event.page.PageStateClosedEvent;
import com.comalatech.confluence.states.model.PageState;

public class StateClosedMapper
extends GenericEventActivityMapper
implements EventActivityMapper {
    public StateClosedMapper(ActorUtils actorUtils) {
        super(actorUtils);
    }

    @Override
    public Activity map(ConfluenceEvent event) {
        if (event instanceof PageStateClosedEvent) {
            PageStateClosedEvent pageStateClosedEvent = (PageStateClosedEvent)event;
            return this.buildStateCloseActivity((AbstractPage)pageStateClosedEvent.getPage(), pageStateClosedEvent.getState(), pageStateClosedEvent.getPreviousEvent());
        }
        if (event instanceof BlogPostStateClosedEvent) {
            BlogPostStateClosedEvent blogPostStateClosedEvent = (BlogPostStateClosedEvent)event;
            return this.buildStateCloseActivity((AbstractPage)blogPostStateClosedEvent.getBlogPost(), blogPostStateClosedEvent.getState(), blogPostStateClosedEvent.getPreviousEvent());
        }
        return null;
    }

    protected Activity buildStateCloseActivity(AbstractPage abstractPage, PageState targetState, PageState sourceState) {
        Actor actor = this.actorUtils.buildActor(targetState.getPerformer());
        ActionDetails details = new ActionDetails();
        details.addAll(this.buildStateActionDetails(sourceState));
        if (sourceState != null) {
            details.addDetail(ActionDetailType.STATE_TIME_LAPSED, String.valueOf(targetState.getDate().getTime() - sourceState.getDate().getTime()));
        }
        Action action = new Action(new ActionType(ActionType.Type.STATE, ActionType.Subtype.STATE_CLOSED), actor, details);
        return new Activity(StateClosedMapper.buildTarget((ContentEntityObject)abstractPage), targetState.getDate().getTime(), action);
    }
}

