/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.documentActivity.ao.accesor.builder.report;

import com.comalatech.confluence.documentActivity.ao.accesor.builder.report.FilterBuilder;
import com.comalatech.confluence.documentActivity.service.model.InternalDocumentActivityQuery;
import com.comalatech.confluence.documentActivity.service.model.InternalDocumentActivityQueryFilter;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.java.ao.Query;

public class StateFilterBuilder
implements FilterBuilder {
    @Override
    public Query build(InternalDocumentActivityQuery query) {
        return this.getQuery(query, false);
    }

    @Override
    public Query build(InternalDocumentActivityQuery query, boolean aliasRequired) {
        return this.getQuery(query, aliasRequired);
    }

    private Query getQuery(InternalDocumentActivityQuery query, boolean aliasRequired) {
        InternalDocumentActivityQueryFilter filters = (InternalDocumentActivityQueryFilter)query.getFilters();
        if (Objects.isNull(filters)) {
            return null;
        }
        List<String> states = filters.getStateNames();
        if (Objects.isNull(states) || states.isEmpty()) {
            return null;
        }
        String placeHolder = states.stream().map(s -> "?").collect(Collectors.joining(","));
        String clause = (aliasRequired ? "activity." : "") + "STATE_NAME" + " IN (" + placeHolder + ")";
        return Query.select().where(clause, states.toArray());
    }

    @Override
    public boolean shouldApply(InternalDocumentActivityQuery query) {
        InternalDocumentActivityQueryFilter filters = (InternalDocumentActivityQueryFilter)query.getFilters();
        if (Objects.isNull(filters)) {
            return false;
        }
        List<String> states = filters.getStateNames();
        return states != null && !states.isEmpty();
    }
}

