/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.cloud.migration.service;

import com.comalatech.confluence.cloud.migration.accessor.assessment.DefaultMigrationAppAssessmentAccessor;
import com.comalatech.confluence.cloud.migration.accessor.events.DefaultMigrationAnalyticsEventAccessor;
import com.comalatech.confluence.cloud.migration.entity.assessment.AppAssessmentRecord;
import com.comalatech.confluence.cloud.migration.entity.events.AnalyticsEventRecord;
import com.comalatech.confluence.cloud.migration.mapper.assessment.MigrationAppAssessmentMapper;
import com.comalatech.confluence.cloud.migration.mapper.events.MigrationAnalyticsEventMapper;
import com.comalatech.confluence.cloud.migration.model.assessment.MigrationAppAssessmentInfo;
import com.comalatech.confluence.cloud.migration.model.events.MigrationAnalyticsEvent;
import com.comalatech.confluence.cloud.migration.service.CloudMigrationAnalyticsService;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCloudMigrationAnalyticsService
implements CloudMigrationAnalyticsService {
    private static final Logger log = LoggerFactory.getLogger(DefaultCloudMigrationAnalyticsService.class);
    private final DefaultMigrationAnalyticsEventAccessor defaultMigrationAnalyticsEventAccessor;
    private final DefaultMigrationAppAssessmentAccessor defaultMigrationAppAssessmentAccessor;

    public DefaultCloudMigrationAnalyticsService(DefaultMigrationAnalyticsEventAccessor defaultMigrationAnalyticsEventAccessor, DefaultMigrationAppAssessmentAccessor defaultMigrationAppAssessmentAccessor) {
        this.defaultMigrationAnalyticsEventAccessor = defaultMigrationAnalyticsEventAccessor;
        this.defaultMigrationAppAssessmentAccessor = defaultMigrationAppAssessmentAccessor;
    }

    @Override
    public MigrationAnalyticsEvent getLastScreenEventType() {
        MigrationAnalyticsEvent migrationAnalyticsEvent = null;
        try {
            AnalyticsEventRecord analyticsEventRecord = this.defaultMigrationAnalyticsEventAccessor.getLatestMigEventByEventType(MigrationAnalyticsEvent.CloudMigEvent.SCREEN.toString());
            if (analyticsEventRecord != null) {
                migrationAnalyticsEvent = MigrationAnalyticsEventMapper.fromRecordToModel(analyticsEventRecord);
            }
        }
        catch (Exception e) {
            log.error("There has been an error getting the screen analytic event", (Throwable)e);
        }
        return migrationAnalyticsEvent;
    }

    @Override
    public MigrationAppAssessmentInfo getAppAssessment(String appKey) {
        MigrationAppAssessmentInfo migrationAppAssessmentInfo = null;
        if (!StringUtils.isEmpty((CharSequence)appKey)) {
            try {
                AppAssessmentRecord appAssessmentRecord = this.defaultMigrationAppAssessmentAccessor.getAppAssessment(appKey);
                if (appAssessmentRecord != null) {
                    migrationAppAssessmentInfo = MigrationAppAssessmentMapper.fromRecordToModel(appAssessmentRecord);
                }
            }
            catch (Exception e) {
                log.error("There has been an error getting the app assessment", (Throwable)e);
            }
        }
        return migrationAppAssessmentInfo;
    }
}

