/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoc.notification.listener;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.util.PlainTextToHtmlConverter;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.comalatech.confluence.adhoc.notification.AdhocNotificationService;
import com.comalatech.confluence.adhoc.notification.WorkflowNotificationConfigManager;
import com.comalatech.confluence.adhoc.notification.model.ApprovalAssignedEventEmail;
import com.comalatech.confluence.adhoc.notification.model.NotificationType;
import com.comalatech.confluence.util.WorkflowsListener;
import com.comalatech.confluence.workflow.events.BlogPostApprovalAssignedEvent;
import com.comalatech.confluence.workflow.events.PageApprovalAssignedEvent;
import com.comalatech.workflow.event.approval.ApprovalAssignedEvent;
import com.opensymphony.util.TextUtils;
import java.util.HashSet;

public class ApprovalNotificationListener
extends WorkflowsListener {
    protected final WorkflowNotificationConfigManager workflowNotificationConfigManager;
    protected final AdhocNotificationService adhocNotificationService;
    protected final UserAccessor userAccessor;

    public ApprovalNotificationListener(EventPublisher eventPublisher, WorkflowNotificationConfigManager workflowNotificationConfigManager, AdhocNotificationService adhocNotificationService, UserAccessor userAccessor) {
        super(eventPublisher);
        this.workflowNotificationConfigManager = workflowNotificationConfigManager;
        this.adhocNotificationService = adhocNotificationService;
        this.userAccessor = userAccessor;
    }

    @EventListener
    public void pageApprovalAssignedEvent(PageApprovalAssignedEvent event) {
        this.processAssignedEvent(event);
    }

    @EventListener
    public void blogPostApprovalAssignedEvent(BlogPostApprovalAssignedEvent event) {
        this.processAssignedEvent(event);
    }

    protected void processAssignedEvent(ApprovalAssignedEvent event) {
        AbstractPage page = (AbstractPage)event.getContent();
        if (this.workflowNotificationConfigManager.isNotificationEnabled(NotificationType.APPROVAL_ASSIGNMENT, page.getSpaceKey())) {
            String assignee = event.getAssignment().getAssignee();
            ConfluenceUser assigneeUser = null;
            if (TextUtils.stringSet((String)assignee)) {
                assigneeUser = this.userAccessor.getUserByName(assignee);
            }
            ApprovalAssignedEventEmail email = new ApprovalAssignedEventEmail();
            email.setEntityId(page.getId());
            email.addContextProperty("approvalName", event.getApprovalName());
            email.addContextProperty("assignee", assigneeUser);
            email.addContextProperty("pageTitle", page.getTitle());
            String comment = event.getAssignment().getComment();
            email.addContextProperty("assignmentNoteHtml", TextUtils.stringSet((String)comment) ? PlainTextToHtmlConverter.toHtml((String)comment) : "");
            HashSet<ConfluenceUser> emailsTo = new HashSet<ConfluenceUser>();
            emailsTo.add(assigneeUser);
            this.adhocNotificationService.sendEmail(email, emailsTo);
        }
    }
}

