/*
 * Decompiled with CFR 0.152.
 */
package net.customware.confluence.reporting;

import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.WikiStyleRenderer;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.macro.Macro;
import com.atlassian.spring.container.ContainerManager;
import java.util.HashMap;
import java.util.Map;
import net.customware.confluence.reporting.ContextException;
import net.customware.confluence.reporting.Executor;
import net.customware.confluence.reporting.Report;
import net.customware.confluence.reporting.ReportContext;
import net.customware.confluence.reporting.ReportException;
import org.apache.commons.collections.Bag;
import org.apache.commons.collections.bag.HashBag;

public final class DefaultReportContext
implements ReportContext {
    private final ThreadLocal<RootContext> CONTEXT = new ThreadLocal();
    private WikiStyleRenderer wikiStyleRenderer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T executeRoot(PageContext pageContext, Executor<? extends T> executor) throws ReportException {
        RootContext ctx = this.CONTEXT.get();
        boolean isRoot = false;
        if (ctx == null) {
            ctx = new RootContext(pageContext);
            this.CONTEXT.set(ctx);
            isRoot = true;
        }
        try {
            T t = executor.execute();
            return t;
        }
        finally {
            if (isRoot) {
                this.CONTEXT.set(null);
            }
        }
    }

    @Override
    public boolean isReporting() {
        return this.CONTEXT.get() != null;
    }

    private RootContext getRootContext() throws ContextException {
        RootContext ctx = this.CONTEXT.get();
        if (ctx == null) {
            throw new ContextException("This is not currently in the context of a report.");
        }
        return ctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T executeContext(Object context, Executor<? extends T> executor) throws ReportException {
        RootContext ctx = this.getRootContext();
        Object prevContext = ctx.context;
        ctx.context = context;
        try {
            T t = executor.execute();
            return t;
        }
        finally {
            ctx.context = prevContext;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T executeReport(Report<?, ?> report, Executor<? extends T> executor) throws ReportException {
        RootContext ctx = this.getRootContext();
        Report<?, ?> prevReport = ctx.report;
        ctx.report = report;
        try {
            T t = executor.execute();
            return t;
        }
        finally {
            ctx.report = prevReport;
        }
    }

    @Override
    public Report<?, ?> getCurrentReport() throws ContextException {
        return this.getRootContext().report;
    }

    @Override
    public Object getCurrentReportItem() throws ReportException {
        Report<?, ?> report = this.getCurrentReport();
        if (report != null) {
            return report.getCurrentItem();
        }
        return null;
    }

    @Override
    public Object getCurrentContext() throws ContextException {
        return this.getRootContext().context;
    }

    @Override
    public <C> C getCurrentContext(Class<C> targetClass) throws ContextException {
        Object context = this.getCurrentContext();
        if (targetClass.isInstance(context)) {
            return (C)context;
        }
        return null;
    }

    @Override
    public PageContext getRootPageContext() throws ContextException {
        return this.getRootContext().pageContext;
    }

    @Override
    public PageContext getCurrentPageContext() throws ReportException {
        Report<?, ?> report = this.getCurrentReport();
        if (report != null) {
            return report.getPageContext();
        }
        return this.getRootPageContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String renderWiki(String wiki, RenderMode renderMode, Macro macro) throws ReportException {
        if (wiki != null) {
            String rendered;
            PageContext ctx = this.getCurrentPageContext();
            Object item = this.getCurrentReportItem();
            if (item == null) {
                item = ctx.getEntity();
            }
            if (item != null && this.checkItem(macro, item, 10)) {
                throw new ReportException("Item already rendered 10 times. Canceled to prevent infinite recursion: " + item);
            }
            if (item != null) {
                this.addItem(macro, item);
            }
            try {
                if (renderMode != null) {
                    ctx.pushRenderMode(renderMode);
                }
                try {
                    rendered = this.getWikiStyleRenderer().convertWikiToXHtml((RenderContext)ctx, wiki);
                }
                finally {
                    if (renderMode != null) {
                        ctx.popRenderMode();
                    }
                }
            }
            finally {
                if (item != null) {
                    this.removeItem(macro, item);
                }
            }
            return rendered;
        }
        return null;
    }

    private void removeItem(Macro macro, Object item) throws ContextException {
        Bag contents = this.getMacroContents(macro, false);
        if (contents != null) {
            contents.remove(item);
        }
    }

    private void addItem(Macro macro, Object item) throws ContextException {
        Bag contents = this.getMacroContents(macro, true);
        contents.add(item);
    }

    private boolean checkItem(Macro macro, Object item, int maxOccurrences) throws ContextException {
        Bag contents = this.getMacroContents(macro, false);
        if (contents != null) {
            return contents.getCount(item) >= maxOccurrences;
        }
        return false;
    }

    private Bag getMacroContents(Macro macro, boolean create) throws ContextException {
        RootContext root = this.getRootContext();
        Bag contents = root.macroContent.get(macro.getClass());
        if (contents == null && create) {
            contents = new HashBag();
            root.macroContent.put(macro.getClass(), contents);
        }
        return contents;
    }

    private WikiStyleRenderer getWikiStyleRenderer() {
        if (this.wikiStyleRenderer == null) {
            this.wikiStyleRenderer = (WikiStyleRenderer)ContainerManager.getComponent((String)"wikiStyleRenderer");
        }
        return this.wikiStyleRenderer;
    }

    private static class RootContext {
        PageContext pageContext;
        Object context;
        Report<?, ?> report;
        Map<Class<? extends Macro>, Bag> macroContent;

        RootContext(PageContext ctx) {
            this.pageContext = ctx;
            this.macroContent = new HashMap<Class<? extends Macro>, Bag>();
        }
    }
}

