/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.workflow.model;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.comalatech.confluence.adhoctasks.rest.model.Task;
import com.comalatech.confluence.workflow.rest.model.Message;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.util.HtmlUtils;

@XmlRootElement(name="status")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class PageStatus {
    private String stateName;
    private String stateComment;
    private String stateDescription;
    private String stateColour;
    private boolean finalState;
    private boolean versionsCompleted;
    private String assignee;
    private String publishedStateName;
    private String publishedStateDescription;
    private String publishedStateColour;
    private String alternateViewStateName;
    private String alternateViewUrl;
    private boolean hasFinalState;
    private boolean publishedView;
    private boolean admin;
    private List<Message> messages = new ArrayList<Message>();
    private int activeTasks;
    private int userSearchMinCharacters;
    private boolean taskable;
    private boolean pageAssignable;
    private boolean adhoc;
    private boolean activityVisible;
    private boolean actionable;
    private boolean hideStates;
    private boolean displayProgressTracker;
    private boolean updatePageStatus;
    private boolean showDocumentActivity;
    private String expirationDate;
    private String expirationDateValue;
    private boolean changeExpirationDate;
    private boolean expired;
    private List<String> orderedWorkflowStates;
    private List<Task> tasks;

    public PageStatus() {
    }

    public PageStatus(String stateName, boolean finalState, int userSearchMinCharacters, boolean showDocumentActivity) {
        this();
        this.stateName = stateName;
        this.finalState = finalState;
        this.userSearchMinCharacters = userSearchMinCharacters;
        this.showDocumentActivity = showDocumentActivity;
    }

    public void setStateName(String stateName) {
        this.stateName = stateName;
    }

    public String getStateName() {
        return this.stateName;
    }

    public boolean isFinalState() {
        return this.finalState;
    }

    public void setFinalState(boolean finalState) {
        this.finalState = finalState;
    }

    public boolean isVersionsCompleted() {
        return this.versionsCompleted;
    }

    public void setVersionsCompleted(boolean versionsCompleted) {
        this.versionsCompleted = versionsCompleted;
    }

    public String getAlternateViewStateName() {
        return this.alternateViewStateName;
    }

    public void setAlternateViewStateName(String alternateViewStateName) {
        this.alternateViewStateName = alternateViewStateName;
    }

    public String getAlternateViewUrl() {
        return this.alternateViewUrl;
    }

    public void setAlternateViewUrl(String alternateViewUrl) {
        this.alternateViewUrl = alternateViewUrl;
    }

    public void addMessage(Message message) {
        this.messages.add(message);
    }

    public void addMessages(List<Message> messages) {
        this.messages.addAll(messages);
    }

    public List<Message> getMessages() {
        return this.messages;
    }

    public int getActiveTasks() {
        return this.activeTasks;
    }

    public void setActiveTasks(int activeTasks) {
        this.activeTasks = activeTasks;
    }

    public String toAjsParams() {
        StringBuffer sb = new StringBuffer("<fieldset class=\"hidden parameters\">\n");
        this.append(sb, "stateName", this.htmlEscape(this.stateName));
        this.append(sb, "stateDescription", this.htmlEscape(this.stateDescription));
        this.append(sb, "hoverDescription", this.htmlEscape(this.getHoverDescription()));
        this.append(sb, "finalState", this.finalState);
        this.append(sb, "hasFinalState", this.hasFinalState);
        this.append(sb, "publishedView", this.publishedView);
        this.append(sb, "taskable", this.taskable);
        this.append(sb, "activeTasks", this.activeTasks);
        this.append(sb, "pageAssignable", this.pageAssignable);
        this.append(sb, "workflowAdmin", this.admin);
        this.append(sb, "anonymous", AuthenticatedUserThreadLocal.get() == null);
        this.append(sb, "alternateViewStateName", this.alternateViewStateName);
        this.append(sb, "alternateViewUrl", this.alternateViewUrl);
        this.append(sb, "activityVisible", this.activityVisible);
        this.append(sb, "approvalMinQuery", this.userSearchMinCharacters);
        this.append(sb, "showDocumentActivity", this.showDocumentActivity);
        if (this.finalState) {
            this.append(sb, "alternateViewTitle", ConfluenceActionSupport.getTextStatic((String)"adhocworkflows.alt-view.latest.button.title"));
        } else {
            this.append(sb, "alternateViewTitle", ConfluenceActionSupport.getTextStatic((String)"adhocworkflows.alt-view.published.button.title"));
        }
        return sb.append("</fieldset>").toString();
    }

    private StringBuffer append(StringBuffer sb, String field, Object value) {
        if (value != null) {
            sb.append("<input type=\"hidden\" id=\"" + field + "\" value=\"").append(value.toString()).append("\"/>");
        }
        return sb;
    }

    private String htmlEscape(String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return value;
        }
        return HtmlUtils.htmlEscape((String)value);
    }

    public boolean isHasFinalState() {
        return this.hasFinalState;
    }

    public void setHasFinalState(boolean hasFinalState) {
        this.hasFinalState = hasFinalState;
    }

    public boolean isPublishedView() {
        return this.publishedView;
    }

    public void setPublishedView(boolean publishedView) {
        this.publishedView = publishedView;
    }

    public boolean isAdhoc() {
        return this.adhoc;
    }

    public void setAdhoc(boolean adhoc) {
        this.adhoc = adhoc;
    }

    public void setAdmin(boolean admin) {
        this.admin = admin;
    }

    public boolean isActionable() {
        return this.actionable;
    }

    public void setActionable(boolean actionable) {
        this.actionable = actionable;
    }

    public boolean isUpdatePageStatus() {
        return this.updatePageStatus;
    }

    public void setUpdatePageStatus(boolean updatePageStatus) {
        this.updatePageStatus = updatePageStatus;
    }

    public boolean isTaskable() {
        return this.taskable;
    }

    public void setTaskable(boolean taskable) {
        this.taskable = taskable;
    }

    public String getAssignee() {
        return this.assignee;
    }

    public void setAssignee(String assignee) {
        this.assignee = assignee;
    }

    public boolean isPageAssignable() {
        return this.pageAssignable;
    }

    public void setPageAssignable(boolean pageAssignable) {
        this.pageAssignable = pageAssignable;
    }

    public void setExpirationDate(String expirationDate) {
        this.expirationDate = expirationDate;
    }

    public String getStateComment() {
        return this.stateComment;
    }

    public void setStateComment(String stateComment) {
        this.stateComment = stateComment;
    }

    public boolean isActivityVisible() {
        return this.activityVisible;
    }

    public void setActivityVisible(boolean activityVisible) {
        this.activityVisible = activityVisible;
    }

    public String getStateDescription() {
        return this.stateDescription;
    }

    public String getHoverDescription() {
        StringBuilder hoverDescription = new StringBuilder();
        if (TextUtils.stringSet((String)this.stateDescription)) {
            hoverDescription.append(this.stateDescription);
        }
        if (TextUtils.stringSet((String)this.expirationDate)) {
            String expiration = this.expired ? ConfluenceActionSupport.getTextStatic((String)"approvalsworkflow.approvals.info.expired", (Object[])new String[]{this.expirationDate}) : ConfluenceActionSupport.getTextStatic((String)"approvalsworkflow.approvals.info.expires", (Object[])new String[]{this.expirationDate});
            if (hoverDescription.length() > 0) {
                hoverDescription.append(" ");
            }
            hoverDescription.append(expiration);
        }
        if (hoverDescription.length() == 0) {
            hoverDescription.append(this.stateName);
        }
        return hoverDescription.toString();
    }

    public void setStateDescription(String stateDescription) {
        this.stateDescription = stateDescription;
    }

    public boolean isExpired() {
        return this.expired;
    }

    public void setExpired(boolean expired) {
        this.expired = expired;
    }

    public boolean isHideStates() {
        return this.hideStates;
    }

    public void setHideStates(boolean hideStates) {
        this.hideStates = hideStates;
    }

    public List<String> getOrderedWorkflowStates() {
        return this.orderedWorkflowStates;
    }

    public void setOrderedWorkflowStates(List<String> orderdWorkflowStates) {
        this.orderedWorkflowStates = orderdWorkflowStates;
    }

    public boolean isDisplayProgressTracker() {
        return this.displayProgressTracker;
    }

    public void setDisplayProgressTracker(boolean displayProgressTracker) {
        this.displayProgressTracker = displayProgressTracker;
    }

    public List<Task> getTasks() {
        return this.tasks;
    }

    public void setTasks(List<Task> tasks) {
        this.tasks = tasks;
    }

    public boolean isChangeExpirationDate() {
        return this.changeExpirationDate;
    }

    public void setChangeExpirationDate(boolean changeExpirationDate) {
        this.changeExpirationDate = changeExpirationDate;
    }

    public String getExpirationDateValue() {
        return this.expirationDateValue;
    }

    public void setExpirationDateValue(String expirationDateValue) {
        this.expirationDateValue = expirationDateValue;
    }

    public String getPublishedStateName() {
        return this.publishedStateName;
    }

    public void setPublishedStateName(String publishedStateName) {
        this.publishedStateName = publishedStateName;
    }

    public String getPublishedStateDescription() {
        return this.publishedStateDescription;
    }

    public void setPublishedStateDescription(String publishedStateDescription) {
        this.publishedStateDescription = publishedStateDescription;
    }

    public String getStateColour() {
        return this.stateColour;
    }

    public void setStateColour(String stateColour) {
        this.stateColour = stateColour;
    }

    public String getPublishedStateColour() {
        return this.publishedStateColour;
    }

    public void setPublishedStateColour(String publishedStateColour) {
        this.publishedStateColour = publishedStateColour;
    }

    public int getUserSearchMinCharacters() {
        return this.userSearchMinCharacters;
    }

    public boolean isShowDocumentActivity() {
        return this.showDocumentActivity;
    }
}

