/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflowreports.pageactivity;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.sal.api.message.I18nResolver;
import com.comalatech.confluence.documentActivity.domain.entities.ActionDetail;
import com.comalatech.confluence.documentActivity.domain.entities.ActionDetailType;
import com.comalatech.confluence.documentActivity.domain.entities.ActionDetails;
import com.comalatech.confluence.documentActivity.domain.entities.ActionType;
import com.comalatech.confluence.documentActivity.domain.entities.Activity;
import com.comalatech.confluence.documentActivity.domain.entities.Actor;
import com.comalatech.confluence.states.model.StateChangeReason;
import com.comalatech.confluence.workflow.esignatures.model.ESignatureCredentials;
import com.comalatech.confluence.workflowreports.ReportDateFormatter;
import com.comalatech.confluence.workflowreports.pageactivity.PageActivityCsvProcessor;
import com.comalatech.confluence.workflowreports.pageactivity.PageActivityEntryProcessor;
import com.comalatech.workflow.model.SignatureType;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.text.StringEscapeUtils;

public class PageActivityCsvEntryProcessorAO
extends PageActivityCsvProcessor {
    private final PageManager pageManager;
    private final ReportDateFormatter dateFormatter;

    public PageActivityCsvEntryProcessorAO(PageManager pageManager, ReportDateFormatter dateFormatter, I18nResolver i18nResolver) {
        super(i18nResolver);
        this.pageManager = pageManager;
        this.dateFormatter = dateFormatter;
    }

    @Override
    public <E> void processEntry(StringBuilder builder, AbstractPage page, E entry) {
        Activity activity = (Activity)entry;
        String formattedDate = this.cleanCSVValue(this.dateFormatter.formatServerDateTimePrecise(new Date(activity.getMoment())));
        List<Actor> actors = activity.getAction().getActors();
        List<String> usernames = actors.stream().anyMatch(actor -> "com.comalatech.anonymous".equals(actor.getName())) ? Collections.singletonList(this.getTextStatic("com.comalatech.activity.report.csvexport.anonymous")) : actors.stream().map(Actor::getName).collect(Collectors.toList());
        builder.append(formattedDate).append(",").append(this.cleanCSVValue(usernames.get(0))).append(",");
        if (ActionType.Type.PAGE.equals((Object)activity.getAction().getActionType().getType())) {
            builder.append(this.cleanCSVValue(String.join((CharSequence)",", usernames)));
        }
        builder.append(",");
        ActionType actionType = activity.getAction().getActionType();
        switch (actionType.getType()) {
            case PAGE: 
            case COMMENT: {
                this.addPageFileContent(builder, activity);
                break;
            }
            case APPROVAL: {
                this.addApprovalFileContent(builder, activity);
                break;
            }
            case STATE: {
                this.addStateFileContent(builder, activity);
                break;
            }
            case TASK: {
                this.addTaskFileContent(builder, activity);
                break;
            }
            case READ_CONFIRMATION: {
                this.addReadAckFileContent(builder, activity);
            }
        }
        if (activity.getTarget() != null) {
            long version = activity.getTarget().getTargetVersion();
            if (version != -1L) {
                ContentEntityObject oldPage;
                builder.append("v");
                builder.append(version);
                builder.append(",");
                if (!this.isSkipOtherVersion() && (oldPage = this.pageManager.getOtherVersion((ContentEntityObject)page, (int)version)) != null) {
                    builder.append(oldPage.getId());
                }
            } else {
                builder.append(",");
            }
        } else {
            builder.append(",");
        }
        builder.append(",");
        if (activity.getAction() != null && activity.getAction().getActionDetails() != null) {
            ActionDetails actionDetails = activity.getAction().getActionDetails();
            for (ActionDetail actionDetail : actionDetails) {
                switch (actionDetail.getType()) {
                    case STATE_COMMENT: 
                    case APPROVAL_COMMENT: 
                    case TASK_COMMENT: 
                    case TASK_DESCRIPTION: 
                    case PAGE_COMMENT: 
                    case PAGE_VERSION_COMMENT: {
                        builder.append(this.cleanCSVValue(PageActivityEntryProcessor.removeHtmlTags(actionDetail.getValue())));
                    }
                }
            }
        }
        builder.append(LINE_SEPARATOR);
    }

    private void addPageFileContent(StringBuilder builder, Activity activity) {
        ActionType actionType = activity.getAction().getActionType();
        if (actionType.getType() == ActionType.Type.COMMENT) {
            builder.append("comment").append(",");
            builder.append(this.cleanCSVValue(PageActivityEntryProcessor.removeHtmlTags(this.getTextStatic("com.comalatech.activity.report.task.commented", new String[]{this.getFormattedDate(activity)})))).append(",");
        } else {
            switch (actionType.getSubtype()) {
                case PAGE_CREATED: {
                    builder.append("modification").append(",");
                    builder.append(this.cleanCSVValue(PageActivityEntryProcessor.removeHtmlTags(this.getTextStatic("com.comalatech.activity.report.created", new String[]{this.getFormattedDate(activity)})))).append(",");
                    break;
                }
                case PAGE_UPDATED: {
                    builder.append("modification").append(",");
                    builder.append(this.cleanCSVValue(PageActivityEntryProcessor.removeHtmlTags(this.getTextStatic("com.comalatech.activity.report.modified", new String[]{this.getFormattedDate(activity)})))).append(",");
                }
            }
        }
    }

    private void addApprovalFileContent(StringBuilder builder, Activity activity) {
        ActionDetails details = activity.getAction().getActionDetails();
        String role = details.getDetail(ActionDetailType.APPROVAL_ROLE).getValue();
        ActionType actionType = activity.getAction().getActionType();
        switch (actionType.getSubtype()) {
            case APPROVAL_APPROVED: {
                builder.append("approval").append(",");
                if (role != null) {
                    builder.append(this.cleanCSVValue(PageActivityEntryProcessor.removeHtmlTags(this.getTextStatic("com.comalatech.activity.report.approval.approved.role", new String[]{details.getDetailValue(ActionDetailType.APPROVAL_NAME), this.getFormattedDate(activity), this.getSignatureMode(details), role})))).append(",");
                    break;
                }
                builder.append(this.cleanCSVValue(PageActivityEntryProcessor.removeHtmlTags(this.getTextStatic("com.comalatech.activity.report.approval.approved", new String[]{details.getDetailValue(ActionDetailType.APPROVAL_NAME), this.getFormattedDate(activity), this.getSignatureMode(details)})))).append(",");
                break;
            }
            case APPROVAL_REJECTED: {
                builder.append("approval").append(",");
                if (role != null) {
                    builder.append(this.cleanCSVValue(PageActivityEntryProcessor.removeHtmlTags(this.getTextStatic("com.comalatech.activity.report.approval.rejected.role", new String[]{details.getDetailValue(ActionDetailType.APPROVAL_NAME), this.getFormattedDate(activity), this.getSignatureMode(details), role})))).append(",");
                    break;
                }
                builder.append(this.cleanCSVValue(PageActivityEntryProcessor.removeHtmlTags(this.getTextStatic("com.comalatech.activity.report.approval.rejected", new String[]{details.getDetailValue(ActionDetailType.APPROVAL_NAME), this.getFormattedDate(activity), this.getSignatureMode(details)})))).append(",");
                break;
            }
            case APPROVAL_ASSIGNED: {
                List<Actor> assignees = details.getDetailParticipants(ActionDetailType.APPROVAL_USER_ASSIGNED);
                String assigneesNames = assignees.stream().map(Actor::getName).collect(Collectors.joining(","));
                if (assigneesNames.contains("com.comalatech.anonymous")) {
                    assigneesNames = assigneesNames.replace("com.comalatech.anonymous", this.getTextStatic("com.comalatech.activity.report.csvexport.anonymous"));
                }
                builder.append("approval-assignment").append(",");
                if (role != null) {
                    builder.append(this.cleanCSVValue(PageActivityEntryProcessor.removeHtmlTags(this.getTextStatic("com.comalatech.activity.report.approval.assigned.role", new String[]{details.getDetailValue(ActionDetailType.APPROVAL_NAME), assigneesNames, this.getFormattedDate(activity), role})))).append(",");
                    break;
                }
                builder.append(this.cleanCSVValue(PageActivityEntryProcessor.removeHtmlTags(this.getTextStatic("com.comalatech.activity.report.approval.assigned", new String[]{details.getDetailValue(ActionDetailType.APPROVAL_NAME), assigneesNames, this.getFormattedDate(activity)})))).append(",");
                break;
            }
            case APPROVAL_UNASSIGNED: {
                List<Actor> unassignees = details.getDetailParticipants(ActionDetailType.APPROVAL_USER_UNASSIGNED);
                String unassigneesNames = unassignees.stream().map(Actor::getName).collect(Collectors.joining(","));
                if (unassigneesNames.contains("com.comalatech.anonymous")) {
                    unassigneesNames = unassigneesNames.replace("com.comalatech.anonymous", this.getTextStatic("com.comalatech.activity.report.csvexport.anonymous"));
                }
                builder.append("approval-unassignment").append(",");
                builder.append(this.cleanCSVValue(PageActivityEntryProcessor.removeHtmlTags(this.getTextStatic("com.comalatech.activity.report.approval.unassigned", new String[]{details.getDetailValue(ActionDetailType.APPROVAL_NAME), unassigneesNames, this.getFormattedDate(activity)})))).append(",");
            }
        }
    }

    private void addStateFileContent(StringBuilder builder, Activity activity) {
        ActionDetails details = activity.getAction().getActionDetails();
        ActionType actionType = activity.getAction().getActionType();
        switch (actionType.getSubtype()) {
            case STATE_TRANSITION: {
                builder.append("state").append(",");
                builder.append(this.cleanCSVValue(PageActivityEntryProcessor.removeHtmlTags(this.getTextStatic("com.comalatech.activity.report.changed-state", new String[]{details.getDetailValue(ActionDetailType.STATE_NAME), this.getFormattedDate(activity)})))).append(",");
                break;
            }
            case STATE_OVERRIDE: {
                builder.append("state").append(",");
                builder.append(this.cleanCSVValue(PageActivityEntryProcessor.removeHtmlTags(this.getTextStatic("com.comalatech.activity.report.changed-state", new String[]{details.getDetailValue(ActionDetailType.STATE_NAME), this.getFormattedDate(activity)}))));
                builder.append(" (").append(this.getTextStatic(StateChangeReason.ADMIN_OVERRIDE.getI18nName())).append(")").append(",");
                break;
            }
            case STATE_INIT: {
                builder.append("state").append(",");
                builder.append(this.cleanCSVValue(PageActivityEntryProcessor.removeHtmlTags(this.getTextStatic("com.comalatech.activity.report.changed-state", new String[]{details.getDetailValue(ActionDetailType.STATE_NAME), this.getFormattedDate(activity)}))));
                builder.append(" (").append(this.getTextStatic(StateChangeReason.SPACE_INITIALISE.getI18nName())).append(")").append(",");
                break;
            }
            case STATE_EXPIRED: {
                builder.append("duedaterecordexpiry").append(",");
                builder.append(this.cleanCSVValue(PageActivityEntryProcessor.removeHtmlTags(this.getTextStatic("com.comalatech.activity.report.state-expired", new String[]{details.getDetailValue(ActionDetailType.STATE_NAME), this.getFormattedDate(activity)})))).append(",");
                break;
            }
            case STATE_EXPIRY_UPDATE: {
                builder.append("duedaterecord").append(",");
                builder.append(this.cleanCSVValue(PageActivityEntryProcessor.removeHtmlTags(this.getTextStatic("com.comalatech.activity.report.dueDateRecord.state", new String[]{details.getDetailValue(ActionDetailType.STATE_NAME), this.getFormattedDueDate(new Date(Long.parseLong(details.getDetailValue(ActionDetailType.NEW_EXPIRY_DATE)))), this.getFormattedDate(activity)})))).append(",");
                break;
            }
            case STATE_EXPIRY_REMOVED: {
                builder.append("duedaterecord").append(",");
                builder.append(this.cleanCSVValue(PageActivityEntryProcessor.removeHtmlTags(this.getTextStatic("com.comalatech.activity.report.dueDateRecord.state.remove", new String[]{details.getDetailValue(ActionDetailType.STATE_NAME), this.getFormattedDate(activity)})))).append(",");
            }
        }
    }

    private void addTaskFileContent(StringBuilder builder, Activity activity) {
        ActionDetails details = activity.getAction().getActionDetails();
        String taskName = "'" + details.getDetailValue(ActionDetailType.TASK_NAME) + "'";
        ActionType actionType = activity.getAction().getActionType();
        switch (actionType.getSubtype()) {
            case TASK_ASSIGNMENT: {
                List<Actor> assignees = details.getDetailParticipants(ActionDetailType.TASK_USER_ASSIGNED);
                String assigneesNames = assignees.stream().map(Actor::getName).collect(Collectors.joining(","));
                builder.append("assignment").append(",");
                builder.append(this.cleanCSVValue(PageActivityEntryProcessor.removeHtmlTags(this.getTextStatic("com.comalatech.activity.report.task.assigned", new String[]{taskName, assigneesNames, this.getFormattedDate(activity)})))).append(",");
                break;
            }
            case TASK_UNASSIGNMENT: {
                builder.append("assignment").append(",");
                builder.append(this.cleanCSVValue(PageActivityEntryProcessor.removeHtmlTags(this.getTextStatic("com.comalatech.activity.report.task.unassigned", new String[]{taskName, this.getFormattedDate(activity)})))).append(",");
                break;
            }
            case TASK_COMPLETION: {
                builder.append("completion").append(",");
                builder.append(this.cleanCSVValue(PageActivityEntryProcessor.removeHtmlTags(this.getTextStatic("com.comalatech.activity.report.task.completed", new String[]{taskName, this.getFormattedDate(activity)})))).append(",");
                break;
            }
            case TASK_CREATION: {
                builder.append("task").append(",");
                builder.append(this.cleanCSVValue(PageActivityEntryProcessor.removeHtmlTags(this.getTextStatic("com.comalatech.activity.report.task.created", new String[]{taskName, this.getFormattedDate(activity)})))).append(",");
                break;
            }
            case TASK_UPDATE: {
                builder.append("taskupdate").append(",");
                builder.append(this.cleanCSVValue(PageActivityEntryProcessor.removeHtmlTags(this.getTextStatic("com.comalatech.activity.report.task.updated", new String[]{taskName, this.getFormattedDate(activity)})))).append(",");
                break;
            }
            case TASK_DELETION: {
                builder.append("deletion").append(",");
                builder.append(this.cleanCSVValue(PageActivityEntryProcessor.removeHtmlTags(this.getTextStatic("com.comalatech.activity.report.task.deleted", new String[]{taskName, this.getFormattedDate(activity)})))).append(",");
                break;
            }
            case TASK_DUE_DATE: {
                builder.append("duedaterecord").append(",");
                builder.append(this.cleanCSVValue(PageActivityEntryProcessor.removeHtmlTags(this.getTextStatic("com.comalatech.activity.report.dueDateRecord.task", new String[]{taskName, this.getFormattedDueDate(new Date(Long.parseLong(details.getDetailValue(ActionDetailType.TASK_DUE_DATE)))), this.getFormattedDate(activity)})))).append(",");
                break;
            }
            case TASK_DUE_DATE_DELETED: {
                builder.append("duedaterecord").append(",");
                builder.append(this.cleanCSVValue(PageActivityEntryProcessor.removeHtmlTags(this.getTextStatic("com.comalatech.activity.report.dueDateRecord.task.remove", new String[]{taskName, this.getFormattedDate(activity)})))).append(",");
                break;
            }
            case TASK_DUE_DATE_EXPIRED: {
                builder.append("duedaterecordexpiry").append(",");
                builder.append(this.cleanCSVValue(PageActivityEntryProcessor.removeHtmlTags(this.getTextStatic("com.comalatech.activity.report.dueDateRecord.task.expired", new String[]{taskName})))).append(",");
            }
        }
    }

    private void addReadAckFileContent(StringBuilder builder, Activity activity) {
        ActionType actionType = activity.getAction().getActionType();
        if (actionType.getSubtype() == ActionType.Subtype.READACK_COMPLETED) {
            builder.append("read-ack").append(",");
            builder.append(this.cleanCSVValue(PageActivityEntryProcessor.removeHtmlTags(this.getTextStatic("readack.activity.report.confirmed.description", new String[]{this.getFormattedDate(activity)})))).append(",");
        }
    }

    private String getFormattedDate(Activity activity) {
        return this.dateFormatter.formatServerTime(new Date(activity.getMoment()));
    }

    private String getFormattedDueDate(Date duedate) {
        return this.dateFormatter.formatExpiryDateTime(duedate);
    }

    private String getSignatureMode(ActionDetails details) {
        ESignatureCredentials.Credentials signatureMode;
        SignatureType signatureType = SignatureType.NONE;
        String signatureTypeStr = details.getDetailValue(ActionDetailType.APPROVAL_SIGNATURE_TYPE);
        if (signatureTypeStr != null && !signatureTypeStr.isEmpty()) {
            try {
                signatureType = SignatureType.valueOf(signatureTypeStr);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((signatureMode = ESignatureCredentials.Credentials.fromString(details.getDetailValue(ActionDetailType.APPROVAL_SIGNATURE_MODE))) == ESignatureCredentials.Credentials.CONFLUENCE) {
            return this.getConfluenceSignatureMode(signatureType);
        }
        if (signatureMode == ESignatureCredentials.Credentials.OTP) {
            return this.getOTPSignatureMode(signatureType);
        }
        return "";
    }

    private String getConfluenceSignatureMode(SignatureType signatureType) {
        switch (signatureType) {
            case PASSWORD: {
                return this.getTextStatic("com.comalatech.activity.report.approval.esig.password");
            }
            case USERID_AND_PASSWORD: {
                return this.getTextStatic("com.comalatech.activity.report.approval.esig.user");
            }
        }
        return "";
    }

    private String getOTPSignatureMode(SignatureType signatureType) {
        switch (signatureType) {
            case PASSWORD: {
                return this.getTextStatic("com.comalatech.activity.report.approval.esig.otp.password");
            }
            case USERID_AND_PASSWORD: {
                return this.getTextStatic("com.comalatech.activity.report.approval.esig.otp.user");
            }
        }
        return "";
    }

    private String removeCSVInjectionCharacters(String content) {
        if (content != null) {
            content = content.replaceFirst("^[\\+\\-\\@\\=]", "");
        }
        return content;
    }

    private String cleanCSVValue(String value) {
        if (value == null) {
            return null;
        }
        if (value.trim().length() == 0) {
            return "";
        }
        return StringEscapeUtils.escapeCsv((String)this.removeCSVInjectionCharacters(value));
    }
}

