/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.model;

import com.atlassian.confluence.event.events.ConfluenceEvent;
import com.atlassian.confluence.event.events.label.LabelEvent;
import com.comalatech.confluence.states.event.StateExpireEvent;
import com.comalatech.confluence.states.event.StateTransitionEvent;
import com.comalatech.confluence.tasks.event.AllTasksCompleteEvent;
import com.comalatech.confluence.workflow.events.InternalApprovalEvent;
import com.comalatech.confluence.workflow.events.WorkflowCustomEvent;
import com.comalatech.confluence.workflow.model.Trigger;
import com.comalatech.confluence.workflow.model.TriggerEvents;
import com.comalatech.workflow.event.TaskEvent;
import com.comalatech.workflow.event.WorkflowPageParameterUpdatedEvent;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TriggeringEvent
implements Comparable {
    private static final Logger log = LoggerFactory.getLogger(TriggeringEvent.class);
    protected Class event;
    private Trigger[] triggers;

    public TriggeringEvent(Class event) {
        this.event = event;
        this.triggers = new Trigger[0];
    }

    public void addTrigger(Trigger trigger) {
        Trigger[] newtriggers = new Trigger[this.triggers.length + 1];
        System.arraycopy(this.triggers, 0, newtriggers, 0, this.triggers.length);
        newtriggers[this.triggers.length] = trigger;
        this.triggers = newtriggers;
    }

    public int compareTo(Object o) {
        if (o instanceof TriggeringEvent) {
            return this.compareTo(((TriggeringEvent)o).event);
        }
        if (o instanceof Class) {
            if (this.event.equals(o)) {
                return 0;
            }
            return this.event.getName().compareTo(((Class)o).getName());
        }
        if (o instanceof ConfluenceEvent) {
            if (this.event.isAssignableFrom(o.getClass())) {
                return 0;
            }
            return this.event.getName().compareTo(o.getClass().getName());
        }
        throw new IncompatibleClassChangeError("invalid object type " + o.getClass().getName());
    }

    public Class getEvent() {
        return this.event;
    }

    public Trigger[] getTriggers(final ConfluenceEvent event) {
        try {
            if (event instanceof LabelEvent) {
                return new TriggerSieve<LabelEvent>(){

                    @Override
                    public boolean matches(LabelEvent triggerEvent) {
                        if (!TextUtils.stringSet((String)triggerEvent.getLabel().getName())) {
                            return true;
                        }
                        return ((LabelEvent)event).getLabel().equals((Object)triggerEvent.getLabel());
                    }
                }.filter();
            }
            if (event instanceof InternalApprovalEvent) {
                return new TriggerSieve<InternalApprovalEvent>(){

                    @Override
                    public boolean matches(InternalApprovalEvent triggerEvent) {
                        if (((InternalApprovalEvent)event).getApprovalName().equalsIgnoreCase(triggerEvent.getApprovalName())) {
                            boolean f1 = ((InternalApprovalEvent)event).isPartial();
                            boolean f2 = triggerEvent.isPartial();
                            return f1 && f2 || !f1 && !f2;
                        }
                        return false;
                    }
                }.filter();
            }
            if (event instanceof WorkflowCustomEvent) {
                return new TriggerSieve<WorkflowCustomEvent>(){

                    @Override
                    public boolean matches(WorkflowCustomEvent triggerEvent) {
                        if (((WorkflowCustomEvent)event).getEventName().equalsIgnoreCase(triggerEvent.getEventName())) {
                            boolean f1 = ((WorkflowCustomEvent)event).isSuccess();
                            boolean f2 = triggerEvent.isSuccess();
                            return f1 && f2 || !f1 && !f2;
                        }
                        return false;
                    }
                }.filter();
            }
            if (event instanceof StateTransitionEvent) {
                return new TriggerSieve<StateTransitionEvent>(){

                    @Override
                    public boolean matches(StateTransitionEvent triggerEvent) {
                        return ((StateTransitionEvent)event).getState().getName().equalsIgnoreCase(triggerEvent.getState().getName());
                    }
                }.filter();
            }
            if (event instanceof StateExpireEvent) {
                return new TriggerSieve<StateExpireEvent>(){

                    @Override
                    public boolean matches(StateExpireEvent triggerEvent) {
                        return triggerEvent.getState() != null && ((StateExpireEvent)event).getState().getName().equalsIgnoreCase(triggerEvent.getState().getName());
                    }
                }.filter();
            }
            if (event instanceof TaskEvent) {
                return new TriggerSieve<TaskEvent>(){

                    @Override
                    public boolean matches(TaskEvent triggerEvent) {
                        return triggerEvent.getTask() == null || triggerEvent.getTask().getName().equalsIgnoreCase(((TaskEvent)event).getTask().getName());
                    }
                }.filter();
            }
            if (event instanceof AllTasksCompleteEvent) {
                return new TriggerSieve<AllTasksCompleteEvent>(){

                    @Override
                    public boolean matches(AllTasksCompleteEvent triggerEvent) {
                        return triggerEvent.getState() != null && ((AllTasksCompleteEvent)event).getState().getName().equalsIgnoreCase(triggerEvent.getState().getName());
                    }
                }.filter();
            }
            if (event instanceof WorkflowPageParameterUpdatedEvent) {
                return new TriggerSieve<WorkflowPageParameterUpdatedEvent>(){

                    @Override
                    public boolean matches(WorkflowPageParameterUpdatedEvent triggerEvent) {
                        return triggerEvent.getWorkflowParameter().getName().equalsIgnoreCase(((WorkflowPageParameterUpdatedEvent)event).getWorkflowParameter().getName());
                    }
                }.filter();
            }
            return this.triggers;
        }
        catch (Exception e) {
            log.error("comparing incompatible events " + this.event + " vs. " + event, (Throwable)e);
            return new Trigger[0];
        }
    }

    public String toString() {
        return "TriggeringEvent " + TriggerEvents.eventToString(this.event) + this.actionsToString();
    }

    private String actionsToString() {
        StringBuffer sb = new StringBuffer("{");
        for (int i = 0; i < this.triggers.length; ++i) {
            Trigger trigger = this.triggers[i];
            sb.append("[").append(trigger.getTrimmedAction(null)).append("] ");
        }
        sb.append("}");
        return sb.toString();
    }

    private abstract class TriggerSieve<E> {
        private TriggerSieve() {
        }

        public abstract boolean matches(E var1);

        public Trigger[] filter() {
            ArrayList<Trigger> filteredTriggers = new ArrayList<Trigger>();
            for (Trigger trigger : TriggeringEvent.this.triggers) {
                if (!this.matches(trigger.getEvent())) continue;
                filteredTriggers.add(trigger);
            }
            return filteredTriggers.toArray(new Trigger[filteredTriggers.size()]);
        }
    }
}

