/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.audit.rest;

import com.atlassian.confluence.api.service.accessmode.AccessModeService;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.atlassian.user.User;
import com.comalatech.confluence.adhocworkflows.rest.AbstractAdhocResources;
import com.comalatech.confluence.adhocworkflows.rest.permissions.WorkflowsAppRequired;
import com.comalatech.confluence.license.WorkflowsFeatureManager;
import com.comalatech.confluence.users.UserSearchManager;
import com.comalatech.confluence.workflow.WorkflowConfigurationManager;
import com.comalatech.confluence.workflow.audit.DefaultWorkflowAuditService;
import com.comalatech.confluence.workflow.permissions.WorkflowPermissionManager;
import com.comalatech.workflow.WorkflowHandler;
import com.comalatech.workflow.audit.WorkflowAuditService;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

@WebSudoRequired
@WorkflowsAppRequired
@Path(value="/auditlog")
public class AuditLogResources
extends AbstractAdhocResources
implements ApplicationContextAware,
InitializingBean {
    private ApplicationContext applicationContext;
    private WorkflowAuditService workflowAuditService;

    public AuditLogResources(PageManager pageManager, PermissionManager permissionManager, WorkflowPermissionManager workflowPermissionManager, SpaceManager spaceManager, SpacePermissionManager spacePermissionManager, AccessModeService accessModeService, WorkflowsFeatureManager workflowsFeatureManager, WorkflowConfigurationManager workflowConfigurationManager, WorkflowHandler workflowHandler, UserSearchManager userSearchManager, BootstrapManager bootstrapManager) {
        super(pageManager, permissionManager, workflowPermissionManager, spaceManager, spacePermissionManager, accessModeService, workflowsFeatureManager, workflowConfigurationManager, workflowHandler, userSearchManager, bootstrapManager);
    }

    public void afterPropertiesSet() throws Exception {
        if (this.workflowsFeatureManager.isWorkflowsApp()) {
            this.workflowAuditService = (WorkflowAuditService)this.applicationContext.getBean("workflowAuditService", WorkflowAuditService.class);
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/clear")
    public Response clearLog(@QueryParam(value="key") String spaceKey) {
        if (!this.permissionManager.hasPermission((User)AuthenticatedUserThreadLocal.get(), Permission.ADMINISTER, PermissionManager.TARGET_APPLICATION)) {
            return Response.status((int)403).build();
        }
        ((DefaultWorkflowAuditService)this.workflowAuditService).removeAllRecords(spaceKey);
        return Response.ok().build();
    }
}

