/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.analytics.usecases.workflowsmarkup;

import com.atlassian.fugue.Pair;
import com.comalatech.confluence.workflow.ValueReference;
import com.comalatech.confluence.workflow.analytics.usecases.workflowsmarkup.infrastructure.CustomParameters;
import com.comalatech.confluence.workflow.analytics.usecases.workflowsmarkup.infrastructure.FilterDefaults;
import com.comalatech.confluence.workflow.analytics.usecases.workflowsmarkup.infrastructure.StateFilterDefaults;
import com.comalatech.confluence.workflow.macros.actions.AvailableActions;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class MapWorkflowsMarkupParserUseCase {
    private static final String TRIGGERS = "triggers";
    private static final String STATES = "states";
    private static final String READ_ACK = "readAck";
    private static final String TYPE = "type";
    private static final String EVENT = "event";
    private static final String ACTIONS = "actions";
    private static final String SUPPLIER = "supplier";
    private static final String CUSTOM_REFERENCE = "CustomReference";
    private static final String TRANSITIONS = "transitions";
    private static final String TASKS = "tasks";
    private static final String NAME = "name";
    private static final String APPROVALS = "approvals";
    private static final String CONDITIONS = "conditions";
    private static final String EVENTS = "events";
    private static final String ALL_CONDITIONS = "allConditions";
    private static final String VALUE_REFERENCES = "valueReferences";
    private static final String USES_SUPPLIER = "usesSupplier";
    private static final String CUSTOM_ACTION = "customAction";
    private static final String NAMED_TASKS = "namedTasks";
    private static final String STATE_PROPERTIES = "stateProperties";
    private static final String STATE_TRANSITIONS = "stateTransitions";
    private static final String APPROVAL_PROPERTIES = "approvalProperties";
    private static final String APPROVAL_CONDITIONS = "approvalConditions";
    private static final String PROPERTIES = "properties";
    private static final String PARAMETERS = "parameters";
    private static final String READ_ACK_PROPERTIES = "readAckProperties";
    protected static final String VALUE_REFERENCE_REGEXP = "(@\\w*@)|(@\\w* *?> ?.*@)|(@\\w*:\\w* *?> *?\\w*@)|(@\\w*.*?@)";
    protected static final String TRIGGER_ACTIONS_REGEXP = "(\\{\\w*-\\w*-\\w*:?)|(\\{\\w*-\\w*:?)";
    public final BiConsumer<Map.Entry<String, Object>, Map<String, Object>> parseTriggers = (keyValue, accumulatorMap) -> {
        if (keyValue != null && ((String)keyValue.getKey()).equals(TRIGGERS)) {
            this.processTriggers((List)keyValue.getValue(), (Map<String, Object>)accumulatorMap);
        }
    };
    public final BiConsumer<Map.Entry<String, Object>, Map<String, Object>> parseReadAck = (keyValue, accumulatorMap) -> {
        Set readAclProperties;
        if (keyValue != null && ((String)keyValue.getKey()).equals(READ_ACK) && !(readAclProperties = ((Map)keyValue.getValue()).entrySet().stream().filter(readAckKeyValue -> !(readAckKeyValue.getValue() instanceof Map)).filter(readAckKeyValue -> FilterDefaults.isNotDefaultValue((String)readAckKeyValue.getKey(), readAckKeyValue.getValue())).map(Map.Entry::getKey).collect(Collectors.toSet())).isEmpty()) {
            accumulatorMap.put(READ_ACK_PROPERTIES, readAclProperties);
        }
    };
    public final BiConsumer<Map.Entry<String, Object>, Map<String, Object>> parseStates = (keyValue, accumulatorMap) -> {
        if (keyValue != null && ((String)keyValue.getKey()).equals(STATES)) {
            this.processStates((List)keyValue.getValue(), (Map<String, Object>)accumulatorMap);
        }
    };
    public final BiConsumer<Map.Entry<String, Object>, Map<String, Object>> parseProperties = (keyValue, accumulatorMap) -> {
        if (keyValue != null) {
            String currentKey;
            HashSet<String> properties = (HashSet<String>)accumulatorMap.get(PROPERTIES);
            if (properties == null) {
                properties = new HashSet<String>();
            }
            if (!(currentKey = (String)keyValue.getKey()).equalsIgnoreCase("blobTriggers")) {
                if (currentKey.equalsIgnoreCase(READ_ACK) | !(keyValue.getValue() instanceof Map) && FilterDefaults.isNotDefaultValue(currentKey, keyValue.getValue())) {
                    properties.add(currentKey);
                }
                if (!properties.isEmpty()) {
                    accumulatorMap.put(PROPERTIES, properties);
                }
            }
        }
    };
    public final BiConsumer<Map.Entry<String, Object>, Map<String, Object>> parseParameters = (keyValue, accumulatorMap) -> {
        if (keyValue != null && ((String)keyValue.getKey()).equals(PARAMETERS)) {
            LinkedHashSet types = new LinkedHashSet();
            for (Map element : (List)keyValue.getValue()) {
                Set type = element.entrySet().stream().filter(entry -> ((String)entry.getKey()).equals(TYPE)).map(Map.Entry::getValue).collect(Collectors.toSet());
                types.addAll(type);
            }
            if (!types.isEmpty()) {
                accumulatorMap.put(PARAMETERS, types);
            }
        }
    };

    private void processTriggers(List value, Map<String, Object> result) {
        Pair<Set<String>, String> valueReferencesPair = null;
        HashSet<String> events = new HashSet<String>();
        HashSet<String> allConditions = new HashSet<String>();
        HashSet<String> allActions = new HashSet<String>();
        HashSet allValueReferences = new HashSet();
        Pattern pattern = Pattern.compile(TRIGGER_ACTIONS_REGEXP);
        for (Map element : value) {
            for (Map.Entry<String, Object> entry : element.entrySet()) {
                String currentKey = (String)entry.getKey();
                if (currentKey.equals(EVENT)) {
                    events.addAll(this.findKey(entry, NAME));
                    continue;
                }
                if (currentKey.equals(ACTIONS)) {
                    valueReferencesPair = this.processEventReferences((String)entry.getValue());
                    allValueReferences.addAll((Collection)valueReferencesPair.left());
                    Matcher matcher = pattern.matcher((String)entry.getValue());
                    while (matcher.find()) {
                        String action;
                        String match = matcher.group();
                        int finalIndex = match.indexOf(":");
                        if (finalIndex == -1) {
                            finalIndex = match.length();
                        }
                        if (AvailableActions.isAction(action = match.substring(match.indexOf("{") + 1, finalIndex).trim())) {
                            allActions.add(action);
                        } else {
                            allActions.add(CUSTOM_ACTION);
                        }
                        valueReferencesPair = this.processEventReferences((String)entry.getValue());
                        allValueReferences.addAll((Collection)valueReferencesPair.left());
                    }
                    continue;
                }
                if (!currentKey.equals(CONDITIONS)) continue;
                allConditions.addAll(this.findKey(entry, TYPE));
            }
        }
        MapWorkflowsMarkupParserUseCase.addIf(events, map -> !map.isEmpty(), () -> result.put(EVENTS, events));
        MapWorkflowsMarkupParserUseCase.addIf(allConditions, map -> !map.isEmpty(), () -> result.put(ALL_CONDITIONS, allConditions));
        MapWorkflowsMarkupParserUseCase.addIf(allActions, map -> !map.isEmpty(), () -> result.put(ACTIONS, allActions));
        MapWorkflowsMarkupParserUseCase.addIf(allValueReferences, map -> !map.isEmpty(), () -> result.put(VALUE_REFERENCES, allValueReferences));
        if (valueReferencesPair != null) {
            Set supplierValue = result.getOrDefault(USES_SUPPLIER, new HashSet());
            if (!supplierValue.isEmpty() && ((String)valueReferencesPair.right()).equalsIgnoreCase("true")) {
                supplierValue.clear();
            }
            supplierValue.add((String)valueReferencesPair.right());
            result.put(USES_SUPPLIER, supplierValue);
        }
    }

    private Pair<Set<String>, String> processEventReferences(String action) {
        HashSet<String> valueReferences = new HashSet<String>();
        HashSet<String> referenceTypes = new HashSet<String>();
        Pattern pattern = Pattern.compile(VALUE_REFERENCE_REGEXP);
        Matcher matcher = pattern.matcher(action);
        while (matcher.find()) {
            String match = matcher.group();
            String valueRef = match.substring(match.indexOf("@", 0) + 1, match.lastIndexOf("@"));
            if (match.contains(":")) {
                referenceTypes.add(SUPPLIER);
                valueReferences.addAll(this.parseValueReferences(valueRef));
                continue;
            }
            if (match.contains(">")) {
                valueReferences.addAll(this.parseValueReferences(valueRef));
                continue;
            }
            String trimmedVr = valueRef.trim();
            valueReferences.addAll(this.parseValueReferences(trimmedVr));
        }
        return new Pair(valueReferences, (Object)String.valueOf(referenceTypes.size() > 0));
    }

    private Set<String> parseValueReferences(String valueRef) {
        String[] split;
        LinkedHashSet<String> valueReferences = new LinkedHashSet<String>();
        for (String s : split = valueRef.split(">")) {
            String trimmedValueReference = s.trim();
            if (ValueReference.isValueReference(trimmedValueReference)) {
                valueReferences.add(trimmedValueReference);
                continue;
            }
            if (CustomParameters.isCustomParameterFromSampleWorkflow(s)) continue;
            valueReferences.add(CUSTOM_REFERENCE);
        }
        return valueReferences;
    }

    private void processStates(List<Map> value, Map<String, Object> result) {
        HashSet properties = new HashSet();
        HashSet allTransitions = new HashSet();
        HashSet<String> allApprovalProperties = new HashSet<String>();
        HashSet<String> allApprovalConditions = new HashSet<String>();
        HashSet namedTasks = new HashSet();
        for (Map element : value) {
            for (Map.Entry entry : element.entrySet()) {
                if (!(entry.getValue() instanceof Map) && !(entry.getValue() instanceof List)) {
                    if (!StateFilterDefaults.isNotDefaultValue((String)entry.getKey(), entry.getValue())) continue;
                    properties.add(entry.getKey());
                    continue;
                }
                if (((String)entry.getKey()).equals(TRANSITIONS)) {
                    Set currentTransitions = ((Map)entry.getValue()).keySet();
                    allTransitions.addAll(currentTransitions);
                    continue;
                }
                if (((String)entry.getKey()).equals(TASKS)) {
                    Set tasksProperties = ((List)entry.getValue()).stream().map(Map::keySet).flatMap(Collection::stream).collect(Collectors.toSet());
                    namedTasks.addAll(tasksProperties);
                    continue;
                }
                if (((String)entry.getKey()).equals(APPROVALS)) {
                    for (Map approval : (List)entry.getValue()) {
                        for (Map.Entry<String, Object> entry2 : approval.entrySet()) {
                            if (((String)entry2.getKey()).equals(CONDITIONS)) {
                                allApprovalConditions.addAll(this.findKey(entry2, TYPE));
                                continue;
                            }
                            if (!FilterDefaults.isNotDefaultValue((String)entry2.getKey(), entry2.getValue())) continue;
                            allApprovalProperties.add(entry2.getKey());
                        }
                    }
                    continue;
                }
                properties.add(entry.getKey());
            }
        }
        MapWorkflowsMarkupParserUseCase.addIf(properties, map -> !map.isEmpty(), () -> result.put(STATE_PROPERTIES, properties));
        MapWorkflowsMarkupParserUseCase.addIf(allTransitions, map -> !map.isEmpty(), () -> result.put(STATE_TRANSITIONS, allTransitions));
        MapWorkflowsMarkupParserUseCase.addIf(allApprovalProperties, map -> !map.isEmpty(), () -> result.put(APPROVAL_PROPERTIES, allApprovalProperties));
        MapWorkflowsMarkupParserUseCase.addIf(allApprovalConditions, map -> !map.isEmpty(), () -> result.put(APPROVAL_CONDITIONS, allApprovalConditions));
        MapWorkflowsMarkupParserUseCase.addIf(namedTasks, map -> !map.isEmpty(), () -> result.put(NAMED_TASKS, namedTasks));
    }

    private Set<String> findKey(Map.Entry<String, Object> stringStringEntry, String filterKey) {
        HashSet<String> result = new HashSet<String>();
        if (stringStringEntry.getValue() instanceof Map) {
            return ((Map)stringStringEntry.getValue()).entrySet().stream().filter(conditionEntry -> ((String)conditionEntry.getKey()).equals(filterKey)).map(Map.Entry::getValue).collect(Collectors.toSet());
        }
        for (Map conditions : (List)stringStringEntry.getValue()) {
            conditions.entrySet().stream().filter(conditionEntry -> ((String)conditionEntry.getKey()).equals(filterKey)).map(Map.Entry::getValue).findFirst().ifPresent(result::add);
        }
        return result;
    }

    public static <V> void addIf(V value, Predicate<V> condition, Runnable action) {
        if (condition.and(Objects::nonNull).test(value)) {
            action.run();
        }
    }
}

