/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.accesor;

import com.atlassian.confluence.persistence.EntityManagerProvider;
import com.atlassian.confluence.security.ContentPermission;
import com.comalatech.confluence.workflow.accesor.ContentRestrictionWorkflowRecordAccessor;
import com.comalatech.confluence.workflow.accesor.entity.ContentRestrictionWorkflowRecord;
import java.util.List;
import java.util.stream.Collectors;
import javax.persistence.Tuple;
import javax.persistence.TypedQuery;

public class ContentRestrictionWorkflowRecordAccessorImpl
implements ContentRestrictionWorkflowRecordAccessor {
    private final EntityManagerProvider entityManagerProvider;

    public ContentRestrictionWorkflowRecordAccessorImpl(EntityManagerProvider entityManagerProvider) {
        this.entityManagerProvider = entityManagerProvider;
    }

    @Override
    public List<ContentRestrictionWorkflowRecord> findAllContentRestrictionSpaceWorkflows(List<String> spaceIdList) {
        return this.getPageRestrictionWorkflowRecords("select content.id as contentId, content.title as title, space.key as key, permissionSet.type as type, permission as permission, contentProperty.stringVal as state from ConfluenceBandanaRecord bandana, Space space, ContentEntityObject content, ContentPermissionSet permissionSet, ContentPermission permission, BucketPropertySetItem contentProperty where bandana.key like '%com.comalatech.workflow.production.template%' and bandana.context = space.key and content.space.id = space.id and contentProperty.entityId = content.id and content.id = permissionSet.owningContent.id and permissionSet.id = permission.owningSet.id and content.contentStatus = 'current' and bandana.value not like '%disabled=true%' and contentProperty.key = 'metadata.awpState' and contentProperty.stringVal is not null and space.key in (:spacekeys)", spaceIdList);
    }

    @Override
    public List<ContentRestrictionWorkflowRecord> findAllContentRestrictionWorkflows(List<String> spaceIdList) {
        return this.getPageRestrictionWorkflowRecords("Select content.id as contentId, content.title as title, content.space.key as key, permissionSet.type as type, permission as permission, contentProperty.stringVal as state from BucketPropertySetItem contentProperty, ContentEntityObject content, ContentPermissionSet permissionSet, ContentPermission permission where content.id = contentProperty.entityId and content.id = permissionSet.owningContent.id and permissionSet.id = permission.owningSet.id and contentProperty.key = 'metadata.awpState' and contentProperty.stringVal is not null and content.id not in (Select aPropertyEntry.entityId from BucketPropertySetItem aPropertyEntry where aPropertyEntry.key = 'com.comalatech.workflow.read-ack') and content.id in (Select bPropertyEntry.entityId from BucketPropertySetItem bPropertyEntry where bPropertyEntry.key like '%com.comalatech.workflow.adhoc.%') and content.space.key in (:spacekeys)", spaceIdList);
    }

    @Override
    public List<ContentRestrictionWorkflowRecord> findAllContentInheritedRestrictionSpaceWorkflows(List<String> spaceIdList) {
        return this.getPageInheritedRestrictionWorkflowRecords("select content.id as contentId, content.title as title, space.key as key, contentProperty.stringVal as state from ConfluenceBandanaRecord bandana, Space space, ContentEntityObject content, BucketPropertySetItem contentProperty join content.ancestors a where bandana.key like '%com.comalatech.workflow.production.template%' and bandana.context = space.key and content.space.id = space.id and contentProperty.entityId = content.id and content.contentStatus = 'current' and bandana.value not like '%disabled=true%' and contentProperty.key = 'metadata.awpState' and contentProperty.stringVal is not null and a.id in (Select c.id from ContentEntityObject c, ContentPermissionSet permissionSet, ContentPermission permission where c.id = permissionSet.owningContent.id and permissionSet.id = permission.owningSet.id and c.space.id = space.id) and space.key in (:spacekeys) ", spaceIdList);
    }

    @Override
    public List<ContentRestrictionWorkflowRecord> findAllContentInheritedRestrictionWorkflows(List<String> spaceIdList) {
        return this.getPageInheritedRestrictionWorkflowRecords("Select content.id as contentId, content.title as title, content.space.key as key, contentProperty.stringVal as state from BucketPropertySetItem contentProperty, ContentEntityObject content join content.ancestors a where content.id = contentProperty.entityId and contentProperty.key = 'metadata.awpState' and contentProperty.stringVal is not null and content.id not in (Select aPropertyEntry.entityId from BucketPropertySetItem aPropertyEntry where aPropertyEntry.key = 'com.comalatech.workflow.read-ack') and content.id in (Select bPropertyEntry.entityId from BucketPropertySetItem bPropertyEntry where bPropertyEntry.key like '%com.comalatech.workflow.adhoc.%') and a.id in (Select c.id from ContentEntityObject c, ContentPermissionSet permissionSet, ContentPermission permission where c.id = permissionSet.owningContent.id and permissionSet.id = permission.owningSet.id and c.space.id = content.space.id) and content.space.key in (:spacekeys)", spaceIdList);
    }

    private List<ContentRestrictionWorkflowRecord> getPageInheritedRestrictionWorkflowRecords(String hql, List<String> spaceIdList) {
        TypedQuery query = this.entityManagerProvider.getEntityManager().createQuery(hql, Tuple.class);
        query.setParameter("spacekeys", spaceIdList);
        return query.getResultList().stream().map(queryRecord -> ContentRestrictionWorkflowRecord.builder().contentId((Long)queryRecord.get("contentId")).title((String)queryRecord.get("title")).spaceKey((String)queryRecord.get("key")).state((String)queryRecord.get("state")).inheritedRestrictions(true).build()).collect(Collectors.toList());
    }

    private List<ContentRestrictionWorkflowRecord> getPageRestrictionWorkflowRecords(String hql, List<String> spaceIdList) {
        TypedQuery query = this.entityManagerProvider.getEntityManager().createQuery(hql, Tuple.class);
        query.setParameter("spacekeys", spaceIdList);
        return query.getResultList().stream().map(queryRecord -> ContentRestrictionWorkflowRecord.builder().contentId((Long)queryRecord.get("contentId")).title((String)queryRecord.get("title")).spaceKey((String)queryRecord.get("key")).permissionType((String)queryRecord.get("type")).username(((ContentPermission)queryRecord.get("permission")).getUserSubject() == null ? null : ((ContentPermission)queryRecord.get("permission")).getUserSubject().getName()).groupName(((ContentPermission)queryRecord.get("permission")).getGroupName()).state((String)queryRecord.get("state")).inheritedRestrictions(false).build()).collect(Collectors.toList());
    }
}

