/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.translator.domain;

import com.comalatech.confluence.translator.domain.CloudTranslation;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class ServerWorkflow {
    private static final String STATE = "state";
    private static final String APPROVAL = "approval";
    private static final String STATES = "states";
    private static final String UNSUPPORTED_ELEMENTS = "unsupportedElements";
    private static final String UNSUPPORTED_PARAMETERS = "unsupportedParameters";
    private static final String CONTENT_TYPES = "contentTypes";
    private static final String DISPLAY_PROGRESS_TRACKER = "displayProgressTracker";
    private static final String NAME = "name";
    private static final String DESCRIPTION = "description";
    private static final String COLOUR = "colour";
    private static final String FINAL = "final";
    private static final String TRANSITIONS = "transitions";
    private static final String APPROVALS = "approvals";
    private static final String APPROVE_LABEL = "approveLabel";
    private static final String REJECT_LABEL = "rejectLabel";
    private static final String SUBMIT = "submit";
    private static final String SELECT = "select";
    private static final String WORKFLOW = "workflow";
    private static final Set<String> ROOT_ELEMENTS_TO_BE_IGNORED = new HashSet<String>(Arrays.asList("active", "blobTriggers", "key"));
    private static final Set<String> APPROVAL_PARAMETERS_TO_BE_IGNORED = new HashSet<String>(Collections.singleton("visibleContentTypes"));
    private static final Set<String> WORKFLOW_UNSUPPORTED_PARAMETERS = new HashSet<String>(Arrays.asList("adminUsers", "invertLabels", "labels", "stickyLabels", "updateStatus"));
    private static final Set<String> WORKFLOW_UNSUPPORTED_SPECIAL_PARAMETERS = new HashSet<String>(Arrays.asList("contentTypes", "displayProgressTracker"));
    private static final Set<String> ROOT_SUPPORTED_ELEMENTS = new HashSet<String>(Arrays.asList("name", "description", "states"));
    private static final Set<String> STATE_SUPPORTED_PARAMETERS = new HashSet<String>(Arrays.asList("name", "description", "colour", "final", "transitions", "approvals"));
    private static final Set<String> APPROVAL_SUPPORTED_PARAMETERS = new HashSet<String>(Arrays.asList("name", "description", "approveLabel", "rejectLabel"));
    private static final Map<String, String> UNSUPPORTED_KEYS_DICTIONARY = new HashMap<String, String>(){
        {
            this.put("pageFooter", "pagefooter");
            this.put("instructions", "workflow-instructions");
            this.put("parameters", "workflowparameter");
            this.put("readAck", "read-ack");
            this.put("triggers", "trigger");
            this.put("dueDate", "duedate");
            this.put("changeDueDate", "changeduedate");
            this.put("hideFromPath", "hidefrompath");
            this.put(ServerWorkflow.CONTENT_TYPES, "content");
            this.put("hideSelection", "hideselection");
            this.put(ServerWorkflow.DISPLAY_PROGRESS_TRACKER, "progresstracker");
        }
    };
    private final Map<String, Object> workflow;

    public CloudTranslation toCloud() {
        Set<Object> unsupportedParameters = this.getUnsupportedParameters();
        Set<Object> rootUnsupportedElements = this.getRootUnsupportedElements();
        HashMap<String, Object> cloudWorkflow = new HashMap<String, Object>();
        ServerWorkflow.addNameAndDescription(this.workflow, cloudWorkflow);
        cloudWorkflow.put(STATES, this.getCloudStates(unsupportedParameters));
        CloudTranslation cloudTranslation = CloudTranslation.builder().workflow(cloudWorkflow).build();
        if (!rootUnsupportedElements.isEmpty()) {
            ServerWorkflow.convertKeysToMarkupStyle(rootUnsupportedElements);
            cloudTranslation.addErrors(UNSUPPORTED_ELEMENTS, rootUnsupportedElements);
        }
        if (!unsupportedParameters.isEmpty()) {
            cloudTranslation.addErrors(UNSUPPORTED_PARAMETERS, unsupportedParameters);
        }
        return cloudTranslation;
    }

    private List<Map<String, Object>> getCloudStates(Set<Object> unsupportedParameters) {
        HashSet<Object> statesUnsupportedParameters = new HashSet<Object>();
        HashSet<Object> approvalsUnsupportedParameters = new HashSet<Object>();
        List<Map<String, Object>> cloudStates = ((Collection)this.workflow.get(STATES)).parallelStream().map(e -> (Map)e).map(state -> {
            Object approvals;
            Object transitions;
            statesUnsupportedParameters.addAll(state.keySet().parallelStream().filter(e -> !STATE_SUPPORTED_PARAMETERS.contains(e)).collect(Collectors.toSet()));
            HashMap<String, Object> cloudState = new HashMap<String, Object>();
            ServerWorkflow.addNameAndDescription(state, cloudState);
            cloudState.put(COLOUR, state.get(COLOUR));
            Boolean isFinal = (Boolean)state.get(FINAL);
            if (null != isFinal) {
                cloudState.put(FINAL, isFinal);
            }
            if (null != (transitions = state.get(TRANSITIONS))) {
                Map cloudTransitions = (Map)transitions;
                if (cloudTransitions.containsKey(SUBMIT)) {
                    cloudTransitions.put(SELECT, (String)cloudTransitions.get(SUBMIT));
                    cloudTransitions.remove(SUBMIT);
                    cloudState.put(TRANSITIONS, cloudTransitions);
                } else {
                    cloudState.put(TRANSITIONS, transitions);
                }
            }
            if (null != (approvals = state.get(APPROVALS))) {
                List<Map<String, Object>> cloudApprovals = ServerWorkflow.getCloudApprovals(approvalsUnsupportedParameters, (Collection)approvals);
                cloudState.put(APPROVALS, cloudApprovals);
            }
            return cloudState;
        }).collect(Collectors.toList());
        if (!statesUnsupportedParameters.isEmpty()) {
            ServerWorkflow.convertKeysToMarkupStyle(statesUnsupportedParameters);
            unsupportedParameters.add(Collections.singletonMap(STATE, statesUnsupportedParameters));
        }
        if (!approvalsUnsupportedParameters.isEmpty()) {
            ServerWorkflow.convertKeysToMarkupStyle(approvalsUnsupportedParameters);
            unsupportedParameters.add(Collections.singletonMap(APPROVAL, approvalsUnsupportedParameters));
        }
        return cloudStates;
    }

    private static List<Map<String, Object>> getCloudApprovals(Set<Object> approvalsUnsupportedParameters, Collection<?> approvals) {
        return approvals.parallelStream().map(e -> (Map)e).map(approval -> {
            String rejectLabel;
            HashMap<String, Object> cloudApproval = new HashMap<String, Object>();
            ServerWorkflow.addNameAndDescription(approval, cloudApproval);
            approvalsUnsupportedParameters.addAll(approval.entrySet().parallelStream().filter(entry -> !APPROVAL_SUPPORTED_PARAMETERS.contains(entry.getKey())).filter(entry -> !APPROVAL_PARAMETERS_TO_BE_IGNORED.contains(entry.getKey())).filter(entry -> !"minimum".equals(entry.getKey()) || !entry.getValue().equals("1")).map(Map.Entry::getKey).collect(Collectors.toSet()));
            String approveLabel = (String)approval.get(APPROVE_LABEL);
            if (null != approveLabel) {
                cloudApproval.put(APPROVE_LABEL, approveLabel);
            }
            if (null != (rejectLabel = (String)approval.get(REJECT_LABEL))) {
                cloudApproval.put(REJECT_LABEL, rejectLabel);
            }
            return cloudApproval;
        }).collect(Collectors.toList());
    }

    private Set<Object> getRootUnsupportedElements() {
        return this.workflow.keySet().parallelStream().filter(e -> !ROOT_SUPPORTED_ELEMENTS.contains(e)).filter(e -> !ROOT_ELEMENTS_TO_BE_IGNORED.contains(e)).filter(e -> !WORKFLOW_UNSUPPORTED_PARAMETERS.contains(e)).filter(e -> !WORKFLOW_UNSUPPORTED_SPECIAL_PARAMETERS.contains(e)).collect(Collectors.toSet());
    }

    private Set<Object> getUnsupportedParameters() {
        Set<Object> unsupportedParametersKeys = this.workflow.entrySet().parallelStream().filter(ServerWorkflow::isUnsupportedParameter).map(Map.Entry::getKey).collect(Collectors.toSet());
        HashSet<Object> unsupportedParameters = new HashSet<Object>();
        if (!unsupportedParametersKeys.isEmpty()) {
            ServerWorkflow.convertKeysToMarkupStyle(unsupportedParametersKeys);
            unsupportedParameters.add(Collections.singletonMap(WORKFLOW, unsupportedParametersKeys));
        }
        return unsupportedParameters;
    }

    private static boolean isUnsupportedParameter(Map.Entry<String, Object> entry) {
        return DISPLAY_PROGRESS_TRACKER.equals(entry.getKey()) && (Boolean)entry.getValue() == false || CONTENT_TYPES.equals(entry.getKey()) && ((List)entry.getValue()).size() != 2 || WORKFLOW_UNSUPPORTED_PARAMETERS.contains(entry.getKey());
    }

    private static void convertKeysToMarkupStyle(Set<Object> unsupported) {
        UNSUPPORTED_KEYS_DICTIONARY.keySet().parallelStream().forEach(key -> {
            if (unsupported.contains(key)) {
                unsupported.remove(key);
                unsupported.add(UNSUPPORTED_KEYS_DICTIONARY.get(key));
            }
        });
    }

    private static void addNameAndDescription(Map<String, Object> source, Map<String, Object> target) {
        target.put(NAME, source.get(NAME));
        String description = (String)source.get(DESCRIPTION);
        if (null != description) {
            target.put(DESCRIPTION, description);
        }
    }

    ServerWorkflow(Map<String, Object> workflow) {
        this.workflow = workflow;
    }

    public static ServerWorkflowBuilder builder() {
        return new ServerWorkflowBuilder();
    }

    public static class ServerWorkflowBuilder {
        private Map<String, Object> workflow;

        ServerWorkflowBuilder() {
        }

        public ServerWorkflowBuilder workflow(Map<String, Object> workflow) {
            this.workflow = workflow;
            return this;
        }

        public ServerWorkflow build() {
            return new ServerWorkflow(this.workflow);
        }

        public String toString() {
            return "ServerWorkflow.ServerWorkflowBuilder(workflow=" + this.workflow + ")";
        }
    }
}

