/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.metadata.atlassian;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.DefaultConversionContext;
import com.atlassian.confluence.content.render.xhtml.XhtmlException;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.DefaultSaveContext;
import com.atlassian.confluence.core.SaveContext;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.xhtml.api.MacroDefinition;
import com.atlassian.confluence.xhtml.api.MacroDefinitionUpdater;
import com.atlassian.confluence.xhtml.api.XhtmlContent;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.renderer.RenderContext;
import com.comalatech.confluence.metadata.atlassian.AtlassianMetadataHandler;
import com.comalatech.confluence.workflow.PageWorkflows;
import com.comalatech.confluence.workflow.events.PageStatusMacroUpdateEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAtlassianMetadataHandler
implements AtlassianMetadataHandler {
    private static final Logger log = LoggerFactory.getLogger(DefaultAtlassianMetadataHandler.class);
    private PageManager pageManager;
    private XhtmlContent xhtmlContent;
    private EventPublisher eventPublisher;
    private ThreadLocal<Long> threadLocal = new ThreadLocal();

    public DefaultAtlassianMetadataHandler(PageManager pageManager, XhtmlContent xhtmlContent, EventPublisher eventPublisher) {
        this.pageManager = pageManager;
        this.xhtmlContent = xhtmlContent;
        this.eventPublisher = eventPublisher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updateProperties(final AbstractPage page, final PageWorkflows pageWorkflows) {
        if (!pageWorkflows.isUpdateStatus()) {
            return false;
        }
        if (this.threadLocal.get() != null) {
            log.error("recursively triggering update properties on " + page + " check workflow");
            return false;
        }
        try {
            String body = this.xhtmlContent.updateMacroDefinitions(page.getBodyAsString(), (ConversionContext)new DefaultConversionContext((RenderContext)page.toPageContext()), new MacroDefinitionUpdater(){

                public MacroDefinition update(MacroDefinition macroDefinition) {
                    if (macroDefinition.getName().equals("status") && DefaultAtlassianMetadataHandler.this.threadLocal.get() == null && !pageWorkflows.getValueStore().getPageState().getName().equals(macroDefinition.getParameters().get("title"))) {
                        DefaultAtlassianMetadataHandler.this.threadLocal.set(page.getId());
                        return pageWorkflows.getStateAsStatusMacro();
                    }
                    return macroDefinition;
                }
            });
            if (this.threadLocal.get() != null) {
                page.setBodyAsString(body);
                DefaultSaveContext saveContext = new DefaultSaveContext(true, false, true);
                this.pageManager.saveContentEntity((ContentEntityObject)page, (SaveContext)saveContext);
                String newStatus = pageWorkflows.getValueStore().getPageState().getName();
                PageStatusMacroUpdateEvent event = new PageStatusMacroUpdateEvent(this.pageManager, (ContentEntityObject)page, newStatus);
                this.eventPublisher.publish((Object)event);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (XhtmlException e) {
            log.error("Could not parse properties on " + page, (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.threadLocal.set(null);
        }
    }
}

