/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.ipc.api;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.comalatech.confluence.states.StateManager;
import com.comalatech.confluence.states.model.PageState;
import com.comalatech.confluence.workflow.PageWorkflows;
import com.comalatech.confluence.workflow.WorkflowAccessor;
import com.comalatech.workflow.WorkflowException;

public class AbstractAdhocService {
    protected final UserAccessor userAccessor;
    protected final WorkflowAccessor workflowAccessor;
    protected final StateManager stateManager;

    public AbstractAdhocService(UserAccessor userAccessor, WorkflowAccessor workflowAccessor, StateManager stateManager) {
        this.userAccessor = userAccessor;
        this.workflowAccessor = workflowAccessor;
        this.stateManager = stateManager;
    }

    protected AbstractPage getPage(ContentEntityObject content) throws WorkflowException {
        if (content instanceof AbstractPage) {
            return (AbstractPage)content;
        }
        throw new WorkflowException("Invalid Content, must be an abstract page for workflows: " + content);
    }

    protected ConfluenceUser getUser(String name) throws WorkflowException {
        ConfluenceUser user = this.userAccessor.getUserByName(name);
        if (user == null) {
            throw new WorkflowException("Invalid user name " + name);
        }
        return user;
    }

    protected PageWorkflows getPageWorkflows(AbstractPage page) throws WorkflowException {
        PageWorkflows pageWorkflows = this.workflowAccessor.getPageWorkflows(page);
        if (pageWorkflows == null) {
            throw new WorkflowException(page.toString() + " does not have a workflow");
        }
        return pageWorkflows;
    }

    protected abstract class WorkflowCommand {
        private AbstractPage page;
        private ConfluenceUser user;
        private PageWorkflows pageWorkflows;
        private PageState state;

        public WorkflowCommand(ContentEntityObject content) throws WorkflowException {
            this(content, AuthenticatedUserThreadLocal.get());
        }

        public WorkflowCommand(ContentEntityObject content, ConfluenceUser user) throws WorkflowException {
            this.page = AbstractAdhocService.this.getPage(content);
            this.user = user;
            this.pageWorkflows = AbstractAdhocService.this.getPageWorkflows(this.page);
            this.state = this.pageWorkflows.getValueStore().getPageState();
            if (this.state == null) {
                this.state = AbstractAdhocService.this.stateManager.setState(this.pageWorkflows.getValueStore(), this.pageWorkflows.getStatesContainer().getInitialState(), true, user, null, null, this.pageWorkflows.getReadAck());
            }
        }

        public abstract Object doCommand(AbstractPage var1, ConfluenceUser var2, PageWorkflows var3, PageState var4) throws WorkflowException;

        public Object execute() throws WorkflowException {
            return this.doCommand(this.page, this.user, this.pageWorkflows, this.state);
        }
    }
}

