/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.documentActivity.service.provider.confluence.filter;

import com.atlassian.confluence.core.VersionHistorySummary;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.user.ConfluenceUser;
import com.comalatech.confluence.documentActivity.service.model.DocumentActivityQuery;
import com.comalatech.confluence.documentActivity.service.model.DocumentActivityQueryFilter;
import com.comalatech.confluence.documentActivity.service.provider.confluence.filter.contract.CommentActivityFilter;
import com.comalatech.confluence.documentActivity.service.provider.confluence.filter.contract.PageEditActivityFilter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.apache.commons.collections4.CollectionUtils;

public class UserFilter
implements PageEditActivityFilter,
CommentActivityFilter {
    @Override
    public boolean filter(VersionHistorySummary version, DocumentActivityQuery query) {
        return this.match(version.getContributorSet(), (DocumentActivityQueryFilter)query.getFilters());
    }

    @Override
    public boolean filter(Comment comment, DocumentActivityQuery query) {
        return this.match(Arrays.asList(comment.getCreator(), comment.getLastModifier()), (DocumentActivityQueryFilter)query.getFilters());
    }

    private boolean match(Collection<ConfluenceUser> users, DocumentActivityQueryFilter filters) {
        if (filters != null && CollectionUtils.isNotEmpty(filters.getParticipants())) {
            return false;
        }
        if (filters == null || CollectionUtils.isEmpty(filters.getActors())) {
            return true;
        }
        HashSet userKeys = new HashSet(CollectionUtils.isNotEmpty(filters.getActors()) ? filters.getActors() : Collections.emptyList());
        return users.stream().map(user -> user.getKey().getStringValue()).anyMatch(userKeys::contains);
    }
}

